/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.time.LocalDateTime;
import java.time.ZoneOffset;
import net.minecraft.src.NBTTagCompound;

public class SavedServer {
    public String nickname;
    public String address;
    public LocalDateTime lastPlayed;

    public SavedServer(String nickname, String address, LocalDateTime lastPlayed) {
        this.nickname = nickname;
        this.address = address;
        this.lastPlayed = lastPlayed;
    }

    public static SavedServer readFromTag(NBTTagCompound tag) {
        return new SavedServer(tag.getString("nickname"), tag.getString("address"), LocalDateTime.ofEpochSecond(tag.getLong("lastPlayed"), 0, ZoneOffset.UTC));
    }

    public void writeToTag(NBTTagCompound tag, int index) {
        NBTTagCompound subTag = new NBTTagCompound();
        subTag.setString("nickname", this.nickname);
        subTag.setString("address", this.address);
        subTag.setLong("lastPlayed", this.lastPlayed.toEpochSecond(ZoneOffset.UTC));
        tag.setCompoundTag(Integer.toString(index), subTag);
    }
}

