/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.SavedServer;

public class SavedServerList {
    private File serverListFile;
    public List<SavedServer> servers = new ArrayList<SavedServer>();

    private SavedServerList() {
    }

    public static SavedServerList readFromFile(File file) {
        SavedServerList serverList = new SavedServerList();
        serverList.serverListFile = file;
        try {
            FileInputStream fileStream = new FileInputStream(file);
            DataInputStream dataStream = new DataInputStream(fileStream);
            NBTTagCompound tag = new NBTTagCompound();
            tag.readTagContents(dataStream);
            for (NBTTagCompound subTag : tag.func_28110_c()) {
                serverList.servers.add(new SavedServer(subTag.getString("nickname"), subTag.getString("address"), LocalDateTime.ofEpochSecond(subTag.getLong("lastPlayed"), 0, ZoneOffset.UTC)));
            }
            fileStream.close();
        }
        catch (Exception e2) {
            return serverList;
        }
        return serverList;
    }

    public void writeToFile() {
        try {
            FileOutputStream fileStream = new FileOutputStream(this.serverListFile);
            DataOutputStream dataStream = new DataOutputStream(fileStream);
            NBTTagCompound tag = new NBTTagCompound();
            for (int i2 = 0; i2 < this.servers.size(); ++i2) {
                this.servers.get(i2).writeToTag(tag, i2);
            }
            tag.writeTagContents(dataStream);
            fileStream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

