/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.Season;
import net.minecraft.src.SeasonColorProperties;

public abstract class SeasonColorized
extends Season {
    SeasonColorProperties scp = null;

    public SeasonColorized(int id2, boolean hasFallingLeaves, boolean hasDeeperSnow) {
        super(id2, hasFallingLeaves, hasDeeperSnow);
    }

    @Override
    public int getPeakGrassColorizer(int color) {
        int r2 = color >> 16 & 0xFF;
        int g2 = color >> 8 & 0xFF;
        int b2 = color >> 0 & 0xFF;
        if (this.scp.grassMethod == SeasonColorProperties.ColorMethod.none) {
            return color;
        }
        if (this.scp.grassMethod == SeasonColorProperties.ColorMethod.modify) {
            if (this.scp.grassRMethod == SeasonColorProperties.ValueMethod.flat) {
                r2 = (int)(this.scp.grassR * 255.0f);
            } else if (this.scp.grassRMethod == SeasonColorProperties.ValueMethod.mult) {
                r2 = (int)((float)r2 * this.scp.grassR);
            } else if (this.scp.grassRMethod == SeasonColorProperties.ValueMethod.add) {
                r2 = (int)((float)r2 + this.scp.grassR);
            }
            if (this.scp.grassGMethod == SeasonColorProperties.ValueMethod.flat) {
                g2 = (int)(this.scp.grassG * 255.0f);
            } else if (this.scp.grassGMethod == SeasonColorProperties.ValueMethod.mult) {
                g2 = (int)((float)g2 * this.scp.grassG);
            } else if (this.scp.grassGMethod == SeasonColorProperties.ValueMethod.add) {
                g2 = (int)((float)g2 + this.scp.grassG);
            }
            if (this.scp.grassBMethod == SeasonColorProperties.ValueMethod.flat) {
                b2 = (int)(this.scp.grassB * 255.0f);
            } else if (this.scp.grassBMethod == SeasonColorProperties.ValueMethod.mult) {
                b2 = (int)((float)b2 * this.scp.grassB);
            } else if (this.scp.grassBMethod == SeasonColorProperties.ValueMethod.add) {
                b2 = (int)((float)b2 + this.scp.grassB);
            }
        } else if (this.scp.grassMethod == SeasonColorProperties.ColorMethod.desaturate) {
            int grey = (r2 + g2 + b2) / 3;
            int dr2 = r2 - grey;
            int dg2 = g2 - grey;
            int db2 = b2 - grey;
            r2 = this.scp.grassRMethod == SeasonColorProperties.ValueMethod.mult ? grey + (int)((float)dr2 * this.scp.grassR) : grey;
            g2 = this.scp.grassGMethod == SeasonColorProperties.ValueMethod.mult ? grey + (int)((float)dg2 * this.scp.grassG) : grey;
            b2 = this.scp.grassBMethod == SeasonColorProperties.ValueMethod.mult ? grey + (int)((float)db2 * this.scp.grassB) : grey;
        }
        if (r2 < 0) {
            r2 = 0;
        }
        if (r2 > 255) {
            r2 = 255;
        }
        if (g2 < 0) {
            g2 = 0;
        }
        if (g2 > 255) {
            g2 = 255;
        }
        if (b2 < 0) {
            b2 = 0;
        }
        if (b2 > 255) {
            b2 = 255;
        }
        return r2 << 16 | g2 << 8 | b2 << 0;
    }

    @Override
    public int getPeakFoliageColorizer(int color) {
        int r2 = color >> 16 & 0xFF;
        int g2 = color >> 8 & 0xFF;
        int b2 = color >> 0 & 0xFF;
        if (this.scp.foliageMethod == SeasonColorProperties.ColorMethod.none) {
            return color;
        }
        if (this.scp.foliageMethod == SeasonColorProperties.ColorMethod.modify) {
            if (this.scp.foliageRMethod == SeasonColorProperties.ValueMethod.flat) {
                r2 = (int)(this.scp.foliageR * 255.0f);
            } else if (this.scp.foliageRMethod == SeasonColorProperties.ValueMethod.mult) {
                r2 = (int)((float)r2 * this.scp.foliageR);
            } else if (this.scp.foliageRMethod == SeasonColorProperties.ValueMethod.add) {
                r2 = (int)((float)r2 + this.scp.foliageR);
            }
            if (this.scp.foliageGMethod == SeasonColorProperties.ValueMethod.flat) {
                g2 = (int)(this.scp.foliageG * 255.0f);
            } else if (this.scp.foliageGMethod == SeasonColorProperties.ValueMethod.mult) {
                g2 = (int)((float)g2 * this.scp.foliageG);
            } else if (this.scp.foliageGMethod == SeasonColorProperties.ValueMethod.add) {
                g2 = (int)((float)g2 + this.scp.foliageG);
            }
            if (this.scp.foliageBMethod == SeasonColorProperties.ValueMethod.flat) {
                b2 = (int)(this.scp.foliageB * 255.0f);
            } else if (this.scp.foliageBMethod == SeasonColorProperties.ValueMethod.mult) {
                b2 = (int)((float)b2 * this.scp.foliageB);
            } else if (this.scp.foliageBMethod == SeasonColorProperties.ValueMethod.add) {
                b2 = (int)((float)b2 + this.scp.foliageB);
            }
        } else if (this.scp.foliageMethod == SeasonColorProperties.ColorMethod.desaturate) {
            int grey = (r2 + g2 + b2) / 3;
            int dr2 = r2 - grey;
            int dg2 = g2 - grey;
            int db2 = b2 - grey;
            r2 = this.scp.foliageRMethod == SeasonColorProperties.ValueMethod.mult ? grey + (int)((float)dr2 * this.scp.foliageR) : grey;
            g2 = this.scp.foliageGMethod == SeasonColorProperties.ValueMethod.mult ? grey + (int)((float)dg2 * this.scp.foliageG) : grey;
            b2 = this.scp.foliageBMethod == SeasonColorProperties.ValueMethod.mult ? grey + (int)((float)db2 * this.scp.foliageB) : grey;
        }
        return r2 << 16 | g2 << 8 | b2 << 0;
    }
}

