/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import net.minecraft.server.MinecraftServer;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.Dimension;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPlayerMP;
import net.minecraft.src.IPlayerFileData;
import net.minecraft.src.ItemInWorldManager;
import net.minecraft.src.NetLoginHandler;
import net.minecraft.src.Packet;
import net.minecraft.src.Packet3Chat;
import net.minecraft.src.Packet41EntityPlayerGamemode;
import net.minecraft.src.Packet4UpdateTime;
import net.minecraft.src.Packet70Bed;
import net.minecraft.src.Packet9Respawn;
import net.minecraft.src.PlayerManager;
import net.minecraft.src.Teleporter;
import net.minecraft.src.TileEntity;
import net.minecraft.src.WorldServer;

public class ServerConfigurationManager {
    public static Logger logger = Logger.getLogger("Minecraft");
    public List<EntityPlayerMP> playerEntities = new ArrayList<EntityPlayerMP>();
    private MinecraftServer mcServer;
    private PlayerManager[] playerManagerObj;
    private int maxPlayers;
    private Set bannedPlayers = new HashSet();
    private Set bannedIPs = new HashSet();
    private Set ops = new HashSet();
    private Set whiteListedIPs = new HashSet();
    private File bannedPlayersFile;
    private File ipBanFile;
    private File opFile;
    private File whitelistPlayersFile;
    private IPlayerFileData playerNBTManagerObj;
    private boolean whiteListEnforced;

    public ServerConfigurationManager(MinecraftServer minecraftserver) {
        this.playerManagerObj = new PlayerManager[Dimension.dimensionList.length];
        this.mcServer = minecraftserver;
        this.bannedPlayersFile = minecraftserver.getFile("banned-players.txt");
        this.ipBanFile = minecraftserver.getFile("banned-ips.txt");
        this.opFile = minecraftserver.getFile("ops.txt");
        this.whitelistPlayersFile = minecraftserver.getFile("white-list.txt");
        int i2 = minecraftserver.propertyManagerObj.getIntProperty("view-distance", 10);
        for (int q2 = 0; q2 < Dimension.dimensionList.length; ++q2) {
            this.playerManagerObj[q2] = new PlayerManager(minecraftserver, q2, i2);
        }
        this.maxPlayers = minecraftserver.propertyManagerObj.getIntProperty("max-players", 20);
        this.whiteListEnforced = minecraftserver.propertyManagerObj.getBooleanProperty("white-list", false);
        this.readBannedPlayers();
        this.loadBannedList();
        this.loadOps();
        this.loadWhiteList();
        this.writeBannedPlayers();
        this.saveBannedList();
        this.saveOps();
        this.saveWhiteList();
    }

    public void setPlayerManager(WorldServer[] aworldserver) {
        this.playerNBTManagerObj = aworldserver[0].getSaveHandler().func_22090_d();
    }

    public void func_28172_a(EntityPlayerMP entityplayermp) {
        this.playerManagerObj[0].removePlayer(entityplayermp);
        this.playerManagerObj[1].removePlayer(entityplayermp);
        this.getPlayerManager(entityplayermp.dimension).addPlayer(entityplayermp);
        WorldServer worldserver = this.mcServer.getWorldManager(entityplayermp.dimension);
        worldserver.chunkProviderServer.prepareChunk((int)entityplayermp.posX >> 4, (int)entityplayermp.posZ >> 4);
    }

    public int getMaxTrackingDistance() {
        return this.playerManagerObj[0].getMaxTrackingDistance();
    }

    public PlayerManager getPlayerManager(int i2) {
        return this.playerManagerObj[i2];
    }

    public void readPlayerDataFromFile(EntityPlayerMP entityplayermp) {
        this.playerNBTManagerObj.readPlayerData(entityplayermp);
    }

    public void playerLoggedIn(EntityPlayerMP player) {
        this.playerEntities.add(player);
        player.playerNetServerHandler.handleSendInitialPlayerList();
        WorldServer world = this.mcServer.getWorldManager(player.dimension);
        world.chunkProviderServer.prepareChunk((int)player.posX >> 4, (int)player.posZ >> 4);
        if (!world.getWorldType().worldProvider.hasNoSky) {
            while (world.getCollidingSolidBlockBoundingBoxes(player, player.boundingBox).size() != 0) {
                player.setPosition(player.posX, player.posY + 1.0, player.posZ);
            }
        }
        world.entityJoinedWorld(player);
        this.getPlayerManager(player.dimension).addPlayer(player);
    }

    public void func_613_b(EntityPlayerMP entityplayermp) {
        this.getPlayerManager(entityplayermp.dimension).func_543_c(entityplayermp);
    }

    public void playerLoggedOut(EntityPlayerMP entityplayermp) {
        this.playerNBTManagerObj.writePlayerData(entityplayermp);
        this.mcServer.getWorldManager(entityplayermp.dimension).setEntityDead(entityplayermp);
        this.playerEntities.remove(entityplayermp);
        this.getPlayerManager(entityplayermp.dimension).removePlayer(entityplayermp);
    }

    public EntityPlayerMP login(NetLoginHandler netloginhandler, String s2) {
        if (this.bannedPlayers.contains(s2.trim().toLowerCase())) {
            netloginhandler.kickUser("You are banned from this server!");
            return null;
        }
        if (!this.isAllowedToLogin(s2)) {
            netloginhandler.kickUser("You are not white-listed on this server!");
            return null;
        }
        String s1 = netloginhandler.netManager.getRemoteAddress().toString();
        s1 = s1.substring(s1.indexOf("/") + 1);
        if (this.bannedIPs.contains(s1 = s1.substring(0, s1.indexOf(":")))) {
            netloginhandler.kickUser("Your IP address is banned from this server!");
            return null;
        }
        if (this.playerEntities.size() >= this.maxPlayers) {
            netloginhandler.kickUser("The server is full!");
            return null;
        }
        for (int i2 = 0; i2 < this.playerEntities.size(); ++i2) {
            EntityPlayerMP entityplayermp = this.playerEntities.get(i2);
            if (!entityplayermp.username.equalsIgnoreCase(s2)) continue;
            entityplayermp.playerNetServerHandler.kickPlayer("You logged in from another location");
        }
        return new EntityPlayerMP(this.mcServer, this.mcServer.getWorldManager(0), s2, new ItemInWorldManager(this.mcServer.getWorldManager(0)));
    }

    public EntityPlayerMP recreatePlayerEntity(EntityPlayerMP entityplayermp, int i2) {
        this.mcServer.getEntityTracker(entityplayermp.dimension).removeTrackedPlayerSymmetric(entityplayermp);
        this.mcServer.getEntityTracker(entityplayermp.dimension).untrackEntity(entityplayermp);
        this.getPlayerManager(entityplayermp.dimension).removePlayer(entityplayermp);
        this.playerEntities.remove(entityplayermp);
        this.mcServer.getWorldManager(entityplayermp.dimension).removePlayer(entityplayermp);
        ChunkCoordinates chunkcoordinates = entityplayermp.getPlayerSpawnCoordinate();
        entityplayermp.dimension = i2;
        EntityPlayerMP entityplayermp1 = new EntityPlayerMP(this.mcServer, this.mcServer.getWorldManager(entityplayermp.dimension), entityplayermp.username, new ItemInWorldManager(this.mcServer.getWorldManager(entityplayermp.dimension)));
        entityplayermp1.entityId = entityplayermp.entityId;
        entityplayermp1.chatColor = entityplayermp.chatColor;
        entityplayermp1.nickname = entityplayermp.nickname;
        entityplayermp1.gamemode = entityplayermp.getGamemode();
        entityplayermp1.playerNetServerHandler = entityplayermp.playerNetServerHandler;
        WorldServer worldserver = this.mcServer.getWorldManager(entityplayermp.dimension);
        if (chunkcoordinates != null) {
            ChunkCoordinates chunkcoordinates1 = EntityPlayer.func_25060_a(this.mcServer.getWorldManager(entityplayermp.dimension), chunkcoordinates);
            if (chunkcoordinates1 != null) {
                entityplayermp1.setLocationAndAngles((float)chunkcoordinates1.x + 0.5f, (float)chunkcoordinates1.y + 0.1f, (float)chunkcoordinates1.z + 0.5f, 0.0f, 0.0f);
                entityplayermp1.setPlayerSpawnCoordinate(chunkcoordinates);
            } else {
                entityplayermp1.playerNetServerHandler.sendPacket(new Packet70Bed(0));
            }
        }
        worldserver.chunkProviderServer.prepareChunk((int)entityplayermp1.posX >> 4, (int)entityplayermp1.posZ >> 4);
        while (worldserver.getCollidingBoundingBoxes(entityplayermp1, entityplayermp1.boundingBox).size() != 0) {
            entityplayermp1.setPosition(entityplayermp1.posX, entityplayermp1.posY + 1.0, entityplayermp1.posZ);
        }
        entityplayermp1.playerNetServerHandler.sendPacket(new Packet9Respawn((byte)entityplayermp1.dimension));
        this.mcServer.configManager.sendPacketToPlayer(entityplayermp1.username, new Packet41EntityPlayerGamemode(entityplayermp1.gamemode.id));
        entityplayermp1.playerNetServerHandler.teleportTo(entityplayermp1.posX, entityplayermp1.posY, entityplayermp1.posZ, entityplayermp1.rotationYaw, entityplayermp1.rotationPitch);
        this.func_28170_a(entityplayermp1, worldserver);
        this.getPlayerManager(entityplayermp1.dimension).addPlayer(entityplayermp1);
        worldserver.entityJoinedWorld(entityplayermp1);
        this.playerEntities.add(entityplayermp1);
        entityplayermp1.func_20057_k();
        entityplayermp1.func_22068_s();
        return entityplayermp1;
    }

    public void sendPlayerToOtherDimension(EntityPlayerMP entityplayermp, int targetDim) {
        WorldServer worldserver = this.mcServer.getWorldManager(entityplayermp.dimension);
        Dimension lastDim = Dimension.dimensionList[entityplayermp.dimension];
        Dimension newDim = Dimension.dimensionList[targetDim];
        entityplayermp.dimension = targetDim;
        WorldServer worldserver1 = this.mcServer.getWorldManager(entityplayermp.dimension);
        entityplayermp.playerNetServerHandler.sendPacket(new Packet9Respawn((byte)entityplayermp.dimension));
        worldserver.removePlayer(entityplayermp);
        entityplayermp.isDead = false;
        double d2 = entityplayermp.posX;
        double d1 = entityplayermp.posZ;
        double d22 = 8.0;
        entityplayermp.setLocationAndAngles(d2 *= (double)Dimension.getCoordScale(lastDim, newDim), entityplayermp.posY, d1 *= (double)Dimension.getCoordScale(lastDim, newDim), entityplayermp.rotationYaw, entityplayermp.rotationPitch);
        if (entityplayermp.isEntityAlive()) {
            worldserver.updateEntityWithOptionalForce(entityplayermp, false);
        }
        if (entityplayermp.isEntityAlive()) {
            worldserver1.entityJoinedWorld(entityplayermp);
            entityplayermp.setLocationAndAngles(d2, entityplayermp.posY, d1, entityplayermp.rotationYaw, entityplayermp.rotationPitch);
            worldserver1.updateEntityWithOptionalForce(entityplayermp, false);
            worldserver1.chunkProviderServer.chunkLoadOverride = true;
            new Teleporter().func_4107_a(worldserver1, entityplayermp, lastDim, newDim);
            worldserver1.chunkProviderServer.chunkLoadOverride = false;
        }
        this.func_28172_a(entityplayermp);
        entityplayermp.playerNetServerHandler.teleportTo(entityplayermp.posX, entityplayermp.posY, entityplayermp.posZ, entityplayermp.rotationYaw, entityplayermp.rotationPitch);
        entityplayermp.playerNetServerHandler.sendPacket(new Packet41EntityPlayerGamemode(entityplayermp.getGamemode().id));
        entityplayermp.setWorld(worldserver1);
        this.func_28170_a(entityplayermp, worldserver1);
        this.func_30008_g(entityplayermp);
    }

    public void onTick() {
        for (int i2 = 0; i2 < this.playerManagerObj.length; ++i2) {
            this.playerManagerObj[i2].updatePlayerInstances();
        }
    }

    public void markBlockNeedsUpdate(int i2, int j2, int k2, int l2) {
        this.getPlayerManager(l2).markBlockNeedsUpdate(i2, j2, k2);
    }

    public void sendPacketToAllPlayers(Packet packet) {
        for (int i2 = 0; i2 < this.playerEntities.size(); ++i2) {
            EntityPlayerMP entityplayermp = this.playerEntities.get(i2);
            entityplayermp.playerNetServerHandler.sendPacket(packet);
        }
    }

    public void sendPacketToAllPlayersInDimension(Packet packet, int i2) {
        for (int j2 = 0; j2 < this.playerEntities.size(); ++j2) {
            EntityPlayerMP entityplayermp = this.playerEntities.get(j2);
            if (entityplayermp.dimension != i2) continue;
            entityplayermp.playerNetServerHandler.sendPacket(packet);
        }
    }

    public String getPlayerList() {
        String s2 = "";
        for (int i2 = 0; i2 < this.playerEntities.size(); ++i2) {
            if (i2 > 0) {
                s2 = s2 + ", ";
            }
            s2 = s2 + this.playerEntities.get(i2).getDisplayName();
        }
        return s2;
    }

    public void banPlayer(String s2) {
        this.bannedPlayers.add(s2.toLowerCase());
        this.writeBannedPlayers();
    }

    public void pardonPlayer(String s2) {
        this.bannedPlayers.remove(s2.toLowerCase());
        this.writeBannedPlayers();
    }

    private void readBannedPlayers() {
        try {
            this.bannedPlayers.clear();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.bannedPlayersFile));
            String s2 = "";
            while ((s2 = bufferedreader.readLine()) != null) {
                this.bannedPlayers.add(s2.trim().toLowerCase());
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to load ban list: " + exception);
        }
    }

    private void writeBannedPlayers() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.bannedPlayersFile, false));
            for (String s2 : this.bannedPlayers) {
                printwriter.println(s2);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to save ban list: " + exception);
        }
    }

    public void banIP(String s2) {
        this.bannedIPs.add(s2.toLowerCase());
        this.saveBannedList();
    }

    public void pardonIP(String s2) {
        this.bannedIPs.remove(s2.toLowerCase());
        this.saveBannedList();
    }

    private void loadBannedList() {
        try {
            this.bannedIPs.clear();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.ipBanFile));
            String s2 = "";
            while ((s2 = bufferedreader.readLine()) != null) {
                this.bannedIPs.add(s2.trim().toLowerCase());
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to load ip ban list: " + exception);
        }
    }

    private void saveBannedList() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.ipBanFile, false));
            for (String s2 : this.bannedIPs) {
                printwriter.println(s2);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to save ip ban list: " + exception);
        }
    }

    public void opPlayer(String s2) {
        this.ops.add(s2.toLowerCase());
        this.saveOps();
    }

    public void deopPlayer(String s2) {
        this.ops.remove(s2.toLowerCase());
        this.saveOps();
    }

    private void loadOps() {
        try {
            this.ops.clear();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.opFile));
            String s2 = "";
            while ((s2 = bufferedreader.readLine()) != null) {
                this.ops.add(s2.trim().toLowerCase());
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to load ip ban list: " + exception);
        }
    }

    private void saveOps() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.opFile, false));
            for (String s2 : this.ops) {
                printwriter.println(s2);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to save ip ban list: " + exception);
        }
    }

    private void loadWhiteList() {
        try {
            this.whiteListedIPs.clear();
            BufferedReader bufferedreader = new BufferedReader(new FileReader(this.whitelistPlayersFile));
            String s2 = "";
            while ((s2 = bufferedreader.readLine()) != null) {
                this.whiteListedIPs.add(s2.trim().toLowerCase());
            }
            bufferedreader.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to load white-list: " + exception);
        }
    }

    private void saveWhiteList() {
        try {
            PrintWriter printwriter = new PrintWriter(new FileWriter(this.whitelistPlayersFile, false));
            for (String s2 : this.whiteListedIPs) {
                printwriter.println(s2);
            }
            printwriter.close();
        }
        catch (Exception exception) {
            logger.warning("Failed to save white-list: " + exception);
        }
    }

    public boolean isAllowedToLogin(String s2) {
        s2 = s2.trim().toLowerCase();
        return !this.whiteListEnforced || this.ops.contains(s2) || this.whiteListedIPs.contains(s2);
    }

    public boolean isOp(String s2) {
        return this.ops.contains(s2.trim().toLowerCase());
    }

    public EntityPlayerMP getPlayerEntity(String s2) {
        for (int i2 = 0; i2 < this.playerEntities.size(); ++i2) {
            EntityPlayerMP entityplayermp = this.playerEntities.get(i2);
            if (!entityplayermp.username.equalsIgnoreCase(s2)) continue;
            return entityplayermp;
        }
        return null;
    }

    public void sendChatMessageToPlayer(String s2, String s1) {
        EntityPlayerMP entityplayermp = this.getPlayerEntity(s2);
        if (entityplayermp != null) {
            entityplayermp.playerNetServerHandler.sendPacket(new Packet3Chat(s1));
        }
    }

    public void sendPacketToPlayersAroundPoint(double d2, double d1, double d22, double d3, int i2, Packet packet) {
        this.func_28171_a(null, d2, d1, d22, d3, i2, packet);
    }

    public void func_28171_a(EntityPlayer entityplayer, double d2, double d1, double d22, double d3, int i2, Packet packet) {
        for (int j2 = 0; j2 < this.playerEntities.size(); ++j2) {
            double d6;
            double d5;
            double d4;
            EntityPlayerMP entityplayermp = this.playerEntities.get(j2);
            if (entityplayermp == entityplayer || entityplayermp.dimension != i2 || !((d4 = d2 - entityplayermp.posX) * d4 + (d5 = d1 - entityplayermp.posY) * d5 + (d6 = d22 - entityplayermp.posZ) * d6 < d3 * d3)) continue;
            entityplayermp.playerNetServerHandler.sendPacket(packet);
        }
    }

    public void sendChatMessageToAllOps(String s2) {
        Packet3Chat packet3chat = new Packet3Chat(s2);
        for (int i2 = 0; i2 < this.playerEntities.size(); ++i2) {
            EntityPlayerMP entityplayermp = this.playerEntities.get(i2);
            if (!this.isOp(entityplayermp.username)) continue;
            entityplayermp.playerNetServerHandler.sendPacket(packet3chat);
        }
    }

    public boolean sendPacketToPlayer(String s2, Packet packet) {
        EntityPlayerMP entityplayermp = this.getPlayerEntity(s2);
        if (entityplayermp != null) {
            entityplayermp.playerNetServerHandler.sendPacket(packet);
            return true;
        }
        return false;
    }

    public void savePlayerStates() {
        for (int i2 = 0; i2 < this.playerEntities.size(); ++i2) {
            this.playerNBTManagerObj.writePlayerData(this.playerEntities.get(i2));
        }
    }

    public void sentTileEntityToPlayer(int i2, int j2, int k2, TileEntity tileentity) {
    }

    public void addToWhiteList(String s2) {
        this.whiteListedIPs.add(s2);
        this.saveWhiteList();
    }

    public void removeFromWhiteList(String s2) {
        this.whiteListedIPs.remove(s2);
        this.saveWhiteList();
    }

    public Set getWhiteListedIPs() {
        return this.whiteListedIPs;
    }

    public void reloadWhiteList() {
        this.loadWhiteList();
    }

    public void func_28170_a(EntityPlayerMP entityplayermp, WorldServer worldserver) {
        entityplayermp.playerNetServerHandler.sendPacket(new Packet4UpdateTime(worldserver.getWorldTime()));
    }

    public void func_30008_g(EntityPlayerMP entityplayermp) {
        entityplayermp.func_28017_a(entityplayermp.inventorySlots);
        entityplayermp.func_30001_B();
    }
}

