/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.IInventory;
import net.minecraft.src.InventoryPlayer;
import net.minecraft.src.ItemStack;
import net.minecraft.src.StatList;

public class Slot {
    protected final int slotIndex;
    protected final IInventory inventory;
    public int id;
    public int xDisplayPosition;
    public int yDisplayPosition;
    public boolean discovered = true;

    public Slot(IInventory iinventory, int id2, int x2, int y2) {
        this.inventory = iinventory;
        this.slotIndex = id2;
        this.xDisplayPosition = x2;
        this.yDisplayPosition = y2;
    }

    public ItemStack decrStackSize(int i2) {
        return this.inventory.decrStackSize(this.slotIndex, i2);
    }

    public int getBackgroundIconIndex() {
        return -1;
    }

    public boolean hasStack() {
        return this.getStack() != null;
    }

    public int getSlotStackLimit() {
        return this.inventory.getInventoryStackLimit();
    }

    public ItemStack getStack() {
        return this.inventory.getStackInSlot(this.slotIndex);
    }

    public boolean isHere(IInventory iinventory, int i2) {
        return iinventory == this.inventory && i2 == this.slotIndex;
    }

    public boolean canPutStackInSlot(ItemStack itemstack) {
        return true;
    }

    public void onPickupFromSlot(ItemStack itemstack) {
        this.onSlotChanged();
    }

    public void onSlotChanged() {
        this.inventory.onInventoryChanged();
    }

    public void putStack(ItemStack itemstack) {
        this.inventory.setInventorySlotContents(this.slotIndex, itemstack);
        this.onSlotChanged();
        if (this.inventory instanceof InventoryPlayer) {
            InventoryPlayer inventoryPlayer = (InventoryPlayer)this.inventory;
            if (itemstack != null) {
                inventoryPlayer.player.addStat(StatList.pickUpItemStats[itemstack.itemID], 1);
            }
        }
    }
}

