/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.src.CodecMus;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.GameSettings;
import net.minecraft.src.MathHelper;
import net.minecraft.src.SoundPool;
import net.minecraft.src.SoundPoolEntry;
import paulscode.sound.SoundSystem;
import paulscode.sound.SoundSystemConfig;
import paulscode.sound.codecs.CodecJOrbis;
import paulscode.sound.codecs.CodecWav;
import paulscode.sound.libraries.LibraryLWJGLOpenAL;

public class SoundManager {
    private static SoundSystem sndSystem;
    private static boolean loaded;
    private static final int MUSINTERVAL = 6000;
    private final SoundPool soundPoolSounds = new SoundPool();
    private final SoundPool soundPoolStreaming = new SoundPool();
    private final SoundPool soundPoolMusic = new SoundPool();
    private final SoundPool cave = new SoundPool();
    private int field_587_e = 0;
    private GameSettings options;
    private final Random rand = new Random();
    private Minecraft mc;
    private int ticksBeforeMusic = this.rand.nextInt(6000);

    private static void loadModAudio(String s2, SoundPool soundpool) {
        File file = Minecraft.getAppDir(s2);
        try {
            SoundManager.walkFolder(file, file, soundpool);
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    private static void walkFolder(File file, File file1, SoundPool soundpool) throws IOException {
        File[] afile;
        if ((file1.exists() || file1.mkdirs()) && (afile = file1.listFiles()) != null && afile.length > 0) {
            for (int i2 = 0; i2 < afile.length; ++i2) {
                if (afile[i2].getName().startsWith(".")) continue;
                if (afile[i2].isDirectory()) {
                    SoundManager.walkFolder(file, afile[i2], soundpool);
                    continue;
                }
                if (!afile[i2].isFile()) continue;
                String s2 = afile[i2].getPath().substring(file.getPath().length() + 1).replace('\\', '/');
                soundpool.addSound(s2, afile[i2]);
            }
        }
    }

    public void addMusic(String s2, File file) {
        this.soundPoolMusic.addSound(s2, file);
    }

    public void addSound(String s2, File file) {
        this.soundPoolSounds.addSound(s2, file);
    }

    public void addStreaming(String s2, File file) {
        this.soundPoolStreaming.addSound(s2, file);
    }

    public void closeMinecraft() {
        if (loaded) {
            sndSystem.cleanup();
        }
    }

    public void func_338_a(EntityLiving entityliving, float f2) {
        if (!loaded || ((Float)this.options.soundVolume.value).floatValue() == 0.0f || sndSystem == null) {
            return;
        }
        if (entityliving == null) {
            return;
        }
        float f1 = entityliving.prevRotationYaw + (entityliving.rotationYaw - entityliving.prevRotationYaw) * f2;
        double d2 = entityliving.prevPosX + (entityliving.posX - entityliving.prevPosX) * (double)f2;
        double d1 = entityliving.prevPosY + (entityliving.posY - entityliving.prevPosY) * (double)f2;
        double d22 = entityliving.prevPosZ + (entityliving.posZ - entityliving.prevPosZ) * (double)f2;
        float f22 = MathHelper.cos(-f1 * 0.01745329f - 3.141593f);
        float f3 = MathHelper.sin(-f1 * 0.01745329f - 3.141593f);
        float f4 = -f3;
        float f5 = 0.0f;
        float f6 = -f22;
        float f7 = 0.0f;
        float f8 = 1.0f;
        float f9 = 0.0f;
        sndSystem.setListenerPosition((float)d2, (float)d1, (float)d22);
        sndSystem.setListenerOrientation(f4, 0.0f, f6, 0.0f, 1.0f, 0.0f);
    }

    public void loadSoundSettings(GameSettings gamesettings) {
        this.soundPoolStreaming.field_1657_b = false;
        this.options = gamesettings;
        if (!(loaded || gamesettings != null && ((Float)gamesettings.soundVolume.value).floatValue() == 0.0f && ((Float)gamesettings.musicVolume.value).floatValue() == 0.0f)) {
            this.tryToSetLibraryAndCodecs();
        }
        SoundManager.loadModAudio("minecraft-bta/resources/mod/sound", this.soundPoolSounds);
        SoundManager.loadModAudio("minecraft-bta/resources/mod/streaming", this.soundPoolStreaming);
        SoundManager.loadModAudio("minecraft-bta/resources/mod/music", this.soundPoolMusic);
        SoundManager.loadModAudio("minecraft-bta/resources/mod/cavemusic", this.cave);
        try {
            Field field = Minecraft.class.getDeclaredFields()[1];
            field.setAccessible(true);
            this.mc = (Minecraft)field.get(null);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public void onSoundOptionsChanged() {
        if (!(loaded || ((Float)this.options.soundVolume.value).floatValue() == 0.0f && ((Float)this.options.musicVolume.value).floatValue() == 0.0f)) {
            this.tryToSetLibraryAndCodecs();
        }
        if (sndSystem != null && loaded) {
            if (((Float)this.options.musicVolume.value).floatValue() == 0.0f) {
                sndSystem.stop("BgMusic");
            } else {
                sndSystem.setVolume("BgMusic", ((Float)this.options.musicVolume.value).floatValue());
            }
        }
    }

    public void playRandomMusicIfReady() {
        if (!loaded || ((Float)this.options.musicVolume.value).floatValue() == 0.0f || sndSystem == null) {
            return;
        }
        if (!sndSystem.playing("BgMusic") && !sndSystem.playing("streaming")) {
            if (this.ticksBeforeMusic > 0) {
                --this.ticksBeforeMusic;
                return;
            }
            SoundPoolEntry soundpoolentry = null;
            soundpoolentry = this.mc != null && this.mc.thePlayer != null && !this.mc.thePlayer.worldObj.canBlockSeeTheSky(MathHelper.floor_double(this.mc.thePlayer.posX), MathHelper.floor_double(this.mc.thePlayer.posY), MathHelper.floor_double(this.mc.thePlayer.posZ)) ? this.cave.getRandomSound() : this.soundPoolMusic.getRandomSound();
            if (soundpoolentry != null) {
                this.ticksBeforeMusic = this.rand.nextInt(6000) + 6000;
                sndSystem.backgroundMusic("BgMusic", soundpoolentry.soundUrl, soundpoolentry.soundName, false);
                sndSystem.setVolume("BgMusic", ((Float)this.options.musicVolume.value).floatValue());
                sndSystem.play("BgMusic");
            }
        }
    }

    public void playSound(String s2, float f2, float f1, float f22, float f3, float f4) {
        if (!loaded || ((Float)this.options.soundVolume.value).floatValue() == 0.0f || sndSystem == null) {
            return;
        }
        SoundPoolEntry soundpoolentry = this.soundPoolSounds.getRandomSoundFromSoundPool(s2);
        if (soundpoolentry != null && f3 > 0.0f) {
            this.field_587_e = (this.field_587_e + 1) % 256;
            String s1 = "sound_" + this.field_587_e;
            float f5 = 16.0f;
            if (f3 > 1.0f) {
                f5 *= f3;
            }
            sndSystem.newSource(f3 > 1.0f, s1, soundpoolentry.soundUrl, soundpoolentry.soundName, false, f2, f1, f22, 2, f5);
            sndSystem.setPitch(s1, f4);
            if (f3 > 1.0f) {
                f3 = 1.0f;
            }
            sndSystem.setVolume(s1, f3 * ((Float)this.options.soundVolume.value).floatValue());
            sndSystem.play(s1);
        }
    }

    public void playSoundFX(String s2, float f2, float f1) {
        if (!loaded || ((Float)this.options.soundVolume.value).floatValue() == 0.0f || sndSystem == null) {
            return;
        }
        SoundPoolEntry soundpoolentry = this.soundPoolSounds.getRandomSoundFromSoundPool(s2);
        if (soundpoolentry != null) {
            this.field_587_e = (this.field_587_e + 1) % 256;
            String s1 = "sound_" + this.field_587_e;
            sndSystem.newSource(false, s1, soundpoolentry.soundUrl, soundpoolentry.soundName, false, 0.0f, 0.0f, 0.0f, 0, 0.0f);
            if (f2 > 1.0f) {
                f2 = 1.0f;
            }
            sndSystem.setPitch(s1, f1);
            sndSystem.setVolume(s1, (f2 *= 0.25f) * ((Float)this.options.soundVolume.value).floatValue());
            sndSystem.play(s1);
        }
    }

    public void playStreaming(String s2, float f2, float f1, float f22, float f3, float f4) {
        if (!loaded || ((Float)this.options.soundVolume.value).floatValue() == 0.0f || sndSystem == null) {
            return;
        }
        String s1 = "streaming";
        if (sndSystem.playing("streaming")) {
            sndSystem.stop("streaming");
        }
        if (s2 == null) {
            return;
        }
        SoundPoolEntry soundpoolentry = this.soundPoolStreaming.getRandomSoundFromSoundPool(s2);
        if (soundpoolentry != null && f3 > 0.0f) {
            if (sndSystem.playing("BgMusic")) {
                sndSystem.stop("BgMusic");
            }
            float f5 = 16.0f;
            sndSystem.newStreamingSource(true, "streaming", soundpoolentry.soundUrl, soundpoolentry.soundName, false, f2, f1, f22, 2, 64.0f);
            sndSystem.setVolume("streaming", 0.5f * ((Float)this.options.soundVolume.value).floatValue());
            sndSystem.play("streaming");
        }
    }

    private void tryToSetLibraryAndCodecs() {
        try {
            float f2 = ((Float)this.options.soundVolume.value).floatValue();
            float f1 = ((Float)this.options.musicVolume.value).floatValue();
            this.options.soundVolume.value = Float.valueOf(0.0f);
            this.options.musicVolume.value = Float.valueOf(0.0f);
            this.options.saveOptions();
            SoundSystemConfig.addLibrary(LibraryLWJGLOpenAL.class);
            SoundSystemConfig.setCodec("ogg", CodecJOrbis.class);
            SoundSystemConfig.setCodec("mus", CodecMus.class);
            SoundSystemConfig.setCodec("wav", CodecWav.class);
            sndSystem = new SoundSystem();
            this.options.soundVolume.value = Float.valueOf(f2);
            this.options.musicVolume.value = Float.valueOf(f1);
            this.options.saveOptions();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            System.err.println("error linking with the LibraryJavaSound plug-in");
        }
        loaded = true;
    }

    static {
        loaded = false;
    }
}

