/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.BlockBed;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.ChunkPosition;
import net.minecraft.src.EntityArmouredZombie;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntitySkeleton;
import net.minecraft.src.EntitySpider;
import net.minecraft.src.EntityZombie;
import net.minecraft.src.EnumCreatureType;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.PathEntity;
import net.minecraft.src.PathPoint;
import net.minecraft.src.Pathfinder;
import net.minecraft.src.SpawnListEntry;
import net.minecraft.src.World;

public final class SpawnerMobs {
    private static Set eligibleChunksForSpawning = new HashSet();
    protected static final Class[] nightSpawnEntities = new Class[]{EntitySpider.class, EntityZombie.class, EntitySkeleton.class, EntityArmouredZombie.class};

    protected static ChunkPosition getRandomSpawningPointInChunk(World world, int i2, int j2) {
        int k2 = i2 + world.rand.nextInt(16);
        int l2 = world.rand.nextInt(Minecraft.WORLD_HEIGHT_BLOCKS);
        int i1 = j2 + world.rand.nextInt(16);
        return new ChunkPosition(k2, l2, i1);
    }

    public static int performSpawning(World world, boolean var1, boolean var2) {
        int var3;
        if (!var1 && !var2) {
            return 0;
        }
        eligibleChunksForSpawning.clear();
        for (var3 = 0; var3 < world.players.size(); ++var3) {
            EntityPlayer var4 = world.players.get(var3);
            int var5 = MathHelper.floor_double(var4.posX / 16.0);
            int var6 = MathHelper.floor_double(var4.posZ / 16.0);
            int var7 = 8;
            for (int var8 = -var7; var8 <= var7; ++var8) {
                for (int var9 = -var7; var9 <= var7; ++var9) {
                    eligibleChunksForSpawning.add(new ChunkCoordIntPair(var8 + var5, var9 + var6));
                }
            }
        }
        var3 = 0;
        ChunkCoordinates var35 = world.getSpawnPoint();
        for (EnumCreatureType creatureType : EnumCreatureType.values()) {
            if (creatureType.getPeacefulCreature() && !var2 || !creatureType.getPeacefulCreature() && !var1 || world.countEntities(creatureType.getCreatureClass()) > creatureType.getMaxNumberOfCreature() * eligibleChunksForSpawning.size() / 256) continue;
            block6: for (ChunkCoordIntPair var10 : eligibleChunksForSpawning) {
                SpawnListEntry spawnListEntry2;
                BiomeGenBase var11 = world.getWorldChunkManager().getBiomeGenAtChunkCoord(var10);
                List<SpawnListEntry> creatureSpawnableList = var11.getSpawnableList(creatureType);
                if (creatureSpawnableList == null || creatureSpawnableList.isEmpty()) continue;
                int var13 = 0;
                for (SpawnListEntry spawnListEntry2 : creatureSpawnableList) {
                    var13 += spawnListEntry2.spawnRarityRate;
                }
                int calculatedSpawnChance = world.rand.nextInt(var13);
                spawnListEntry2 = creatureSpawnableList.get(0);
                for (SpawnListEntry var17 : creatureSpawnableList) {
                    if ((calculatedSpawnChance -= var17.spawnRarityRate) >= 0) continue;
                    spawnListEntry2 = var17;
                    break;
                }
                ChunkPosition var41 = SpawnerMobs.getRandomSpawningPointInChunk(world, var10.chunkXPos * 16, var10.chunkZPos * 16);
                int x2 = var41.x;
                int y2 = var41.y;
                int z2 = var41.z;
                if (world.isBlockNormalCube(x2, y2, z2) || world.getBlockMaterial(x2, y2, z2) != creatureType.getCreatureMaterial()) continue;
                int countSpawned = 0;
                for (int tryToSpawnX = 0; tryToSpawnX < 3; ++tryToSpawnX) {
                    int xi2 = x2;
                    int yi2 = y2;
                    int zi = z2;
                    int range = 6;
                    for (int tryToSpawnZ = 0; tryToSpawnZ < 4; ++tryToSpawnZ) {
                        EntityLiving mobToSpawn;
                        float var32;
                        float var31;
                        float var30;
                        float var33;
                        float zd;
                        float yd2;
                        float xd2;
                        if (!SpawnerMobs.canCreatureTypeSpawnAtLocation(creatureType, world, xi2 += world.rand.nextInt(range) - world.rand.nextInt(range), yi2 += world.rand.nextInt(2) - world.rand.nextInt(2), zi += world.rand.nextInt(range) - world.rand.nextInt(range)) || world.getClosestPlayer(xd2 = (float)xi2 + 0.5f, yd2 = (float)yi2, zd = (float)zi + 0.5f, 24.0) != null || !((var33 = (var30 = xd2 - (float)var35.x) * var30 + (var31 = yd2 - (float)var35.y) * var31 + (var32 = zd - (float)var35.z) * var32) >= 576.0f)) continue;
                        try {
                            mobToSpawn = (EntityLiving)spawnListEntry2.entityClass.getConstructor(World.class).newInstance(world);
                        }
                        catch (Exception var34) {
                            var34.printStackTrace();
                            return var3;
                        }
                        mobToSpawn.setLocationAndAngles(xd2, yd2, zd, world.rand.nextFloat() * 360.0f, 0.0f);
                        if (mobToSpawn.getCanSpawnHere()) {
                            mobToSpawn.entityInitOnSpawn();
                            world.entityJoinedWorld(mobToSpawn);
                            if (++countSpawned >= mobToSpawn.getMaxSpawnedInChunk()) continue block6;
                        }
                        var3 += countSpawned;
                    }
                }
            }
        }
        return var3;
    }

    private static boolean canCreatureTypeSpawnAtLocation(EnumCreatureType enumcreaturetype, World world, int i2, int j2, int k2) {
        if (enumcreaturetype.getCreatureMaterial() == Material.water) {
            return world.getBlockMaterial(i2, j2, k2).getIsLiquid() && !world.isBlockNormalCube(i2, j2 + 1, k2);
        }
        return world.isBlockNormalCube(i2, j2 - 1, k2) && !world.isBlockNormalCube(i2, j2, k2) && !world.getBlockMaterial(i2, j2, k2).getIsLiquid();
    }

    public static boolean performSleepSpawning(World world, List list) {
        boolean flag = false;
        Pathfinder pathfinder = new Pathfinder(world);
        for (EntityPlayer entityplayer : list) {
            Class[] aclass;
            if (!entityplayer.sleeping || (aclass = nightSpawnEntities) == null || aclass.length == 0) continue;
            boolean flag1 = false;
            for (int i2 = 0; i2 < 20 && !flag1; ++i2) {
                PathEntity pathentity;
                EntityLiving entityliving;
                int j1;
                int j2 = MathHelper.floor_double(entityplayer.posX) + world.rand.nextInt(32) - world.rand.nextInt(32);
                int k2 = MathHelper.floor_double(entityplayer.posZ) + world.rand.nextInt(32) - world.rand.nextInt(32);
                int l2 = MathHelper.floor_double(entityplayer.posY) + world.rand.nextInt(16) - world.rand.nextInt(16);
                if (l2 < 1) {
                    l2 = 1;
                } else if (l2 > Minecraft.WORLD_HEIGHT_BLOCKS) {
                    l2 = Minecraft.WORLD_HEIGHT_BLOCKS;
                }
                int i1 = world.rand.nextInt(aclass.length);
                for (j1 = l2; j1 > 2 && !world.isBlockNormalCube(j2, j1 - 1, k2); --j1) {
                }
                while (!SpawnerMobs.canCreatureTypeSpawnAtLocation(EnumCreatureType.monster, world, j2, j1, k2) && j1 < l2 + 16 && j1 < 128) {
                    ++j1;
                }
                if (j1 >= l2 + 16 || j1 >= Minecraft.WORLD_HEIGHT_BLOCKS) {
                    j1 = l2;
                    continue;
                }
                float f2 = (float)j2 + 0.5f;
                float f1 = j1;
                float f22 = (float)k2 + 0.5f;
                try {
                    entityliving = (EntityLiving)aclass[i1].getConstructor(World.class).newInstance(world);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    return flag;
                }
                entityliving.setLocationAndAngles(f2, f1, f22, world.rand.nextFloat() * 360.0f, 0.0f);
                if (!entityliving.getCanSpawnHere() || (pathentity = pathfinder.createEntityPathTo(entityliving, entityplayer, 32.0f)) == null || pathentity.pathLength <= 1) continue;
                PathPoint pathpoint = pathentity.func_22328_c();
                if (!(Math.abs((double)pathpoint.xCoord - entityplayer.posX) < 1.5) || !(Math.abs((double)pathpoint.zCoord - entityplayer.posZ) < 1.5) || !(Math.abs((double)pathpoint.yCoord - entityplayer.posY) < 1.5)) continue;
                ChunkCoordinates chunkcoordinates = BlockBed.getNearestEmptyChunkCoordinates(world, MathHelper.floor_double(entityplayer.posX), MathHelper.floor_double(entityplayer.posY), MathHelper.floor_double(entityplayer.posZ), 1);
                if (chunkcoordinates == null) {
                    chunkcoordinates = new ChunkCoordinates(j2, j1 + 1, k2);
                }
                entityliving.setLocationAndAngles((float)chunkcoordinates.x + 0.5f, chunkcoordinates.y, (float)chunkcoordinates.z + 0.5f, 0.0f, 0.0f);
                entityliving.entityInitOnSpawn();
                world.entityJoinedWorld(entityliving);
                entityplayer.wakeUpPlayer(true, false);
                world.playSoundEffectForPlayer(null, 2001, (int)entityplayer.posX, (int)entityplayer.posY - 1, (int)entityplayer.posZ, world.getBlockId((int)entityplayer.posX, (int)entityplayer.posY - 1, (int)entityplayer.posZ));
                entityliving.playLivingSound();
                flag = true;
                flag1 = true;
            }
        }
        return flag;
    }
}

