/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import b100.utils.FileUtils;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.src.Achievement;
import net.minecraft.src.J_InvalidSyntaxException;
import net.minecraft.src.J_JdomParser;
import net.minecraft.src.J_JsonNode;
import net.minecraft.src.J_JsonRootNode;
import net.minecraft.src.J_JsonStringNode;
import net.minecraft.src.MD5String;
import net.minecraft.src.Session;
import net.minecraft.src.StatBase;
import net.minecraft.src.StatList;
import net.minecraft.src.StatsSyncher;

public class StatFileWriter {
    private Map<StatBase, Integer> statMap1 = new HashMap<StatBase, Integer>();
    private Map<StatBase, Integer> statMap2 = new HashMap<StatBase, Integer>();
    private boolean boolean1 = false;
    private StatsSyncher statsSyncher;

    public StatFileWriter(Session session, File minecraftFolder) {
        File statsFolder = new File(minecraftFolder, "stats");
        FileUtils.createFolder(statsFolder);
        StatFileWriter.relocateStatFiles(minecraftFolder, statsFolder);
        this.statsSyncher = new StatsSyncher(session, this, statsFolder);
    }

    public void writeStat(StatBase statbase, int i2) {
        this.writeStatToMap(this.statMap2, statbase, i2);
        this.writeStatToMap(this.statMap1, statbase, i2);
        this.boolean1 = true;
    }

    private void writeStatToMap(Map<StatBase, Integer> map, StatBase statbase, int i2) {
        Integer integer = map.get(statbase);
        int j2 = integer != null ? integer : 0;
        map.put(statbase, j2 + i2);
    }

    public Map<StatBase, Integer> cloneMap() {
        return new HashMap<StatBase, Integer>(this.statMap2);
    }

    public void func_27179_a(Map map) {
        if (map == null) {
            return;
        }
        this.boolean1 = true;
        for (StatBase statbase : map.keySet()) {
            this.writeStatToMap(this.statMap2, statbase, (Integer)map.get(statbase));
            this.writeStatToMap(this.statMap1, statbase, (Integer)map.get(statbase));
        }
    }

    public void func_27180_b(Map map) {
        if (map == null) {
            return;
        }
        for (StatBase statbase : map.keySet()) {
            Integer integer = this.statMap2.get(statbase);
            int i2 = integer != null ? integer : 0;
            this.statMap1.put(statbase, (Integer)map.get(statbase) + i2);
        }
    }

    public void func_27187_c(Map map) {
        if (map == null) {
            return;
        }
        this.boolean1 = true;
        for (StatBase statbase : map.keySet()) {
            this.writeStatToMap(this.statMap2, statbase, (Integer)map.get(statbase));
        }
    }

    public static Map func_27177_a(String s2) {
        HashMap<StatBase, Integer> hashmap = new HashMap<StatBase, Integer>();
        try {
            String s1 = "local";
            StringBuilder stringbuilder = new StringBuilder();
            J_JsonRootNode j_jsonrootnode = new J_JdomParser().func_27367_a(s2);
            List list = j_jsonrootnode.func_27217_b(new Object[]{"stats-change"});
            for (J_JsonNode j_jsonnode : list) {
                Map map = j_jsonnode.func_27214_c();
                Map.Entry entry = map.entrySet().iterator().next();
                int i2 = Integer.parseInt(((J_JsonStringNode)entry.getKey()).func_27216_b());
                int j2 = Integer.parseInt(((J_JsonNode)entry.getValue()).func_27216_b());
                StatBase statbase = StatList.getStat(i2);
                if (statbase == null) {
                    System.out.println(i2 + " is not a valid stat");
                    continue;
                }
                stringbuilder.append(StatList.getStat((int)i2).statGuid).append(",");
                stringbuilder.append(j2).append(",");
                hashmap.put(statbase, j2);
            }
            MD5String md5string = new MD5String(s1);
            String s22 = md5string.getString(stringbuilder.toString());
            if (!s22.equals(j_jsonrootnode.func_27213_a(new Object[]{"checksum"}))) {
                System.out.println("CHECKSUM MISMATCH");
                return null;
            }
        }
        catch (J_InvalidSyntaxException j_invalidsyntaxexception) {
            j_invalidsyntaxexception.printStackTrace();
        }
        return hashmap;
    }

    public static String getStatFileContentString(String username, String localString, Map map) {
        StringBuilder string1 = new StringBuilder();
        StringBuilder string2 = new StringBuilder();
        boolean flag = true;
        string1.append("{\r\n");
        if (username != null && localString != null) {
            string1.append("  \"user\":{\r\n");
            string1.append("    \"name\":\"").append(username).append("\",\r\n");
            string1.append("    \"sessionid\":\"").append(localString).append("\"\r\n");
            string1.append("  },\r\n");
        }
        string1.append("  \"stats-change\":[");
        for (StatBase statbase : map.keySet()) {
            if (!flag) {
                string1.append("},");
            } else {
                flag = false;
            }
            string1.append("\r\n    {\"").append(statbase.statId).append("\":").append(map.get(statbase));
            string2.append(statbase.statGuid).append(",");
            string2.append(map.get(statbase)).append(",");
        }
        if (!flag) {
            string1.append("}");
        }
        MD5String md5string = new MD5String(localString);
        string1.append("\r\n  ],\r\n");
        string1.append("  \"checksum\":\"").append(md5string.getString(string2.toString())).append("\"\r\n");
        string1.append("}");
        return string1.toString();
    }

    public boolean hasAchievementUnlocked(Achievement achievement) {
        return this.statMap1.containsKey(achievement);
    }

    public boolean func_27181_b(Achievement achievement) {
        return achievement.parent == null || this.hasAchievementUnlocked(achievement.parent);
    }

    public int readStat(StatBase statbase) {
        Integer integer = this.statMap1.get(statbase);
        return integer != null ? integer : 0;
    }

    public void func_27175_b() {
    }

    public void syncStats() {
        this.statsSyncher.syncStatsFileWithMap(this.cloneMap());
    }

    public void func_27178_d() {
        if (this.boolean1 && this.statsSyncher.func_27420_b()) {
            this.statsSyncher.func_27424_a(this.cloneMap());
        }
        this.statsSyncher.func_27425_c();
    }

    public static void relocateStatFiles(File minecraftFolder, File statsFolder) {
        File[] files = minecraftFolder.listFiles();
        for (int i2 = 0; i2 < files.length; ++i2) {
            File file3;
            File file = files[i2];
            if (!file.getName().startsWith("stats_") || !file.getName().endsWith(".dat") || (file3 = new File(statsFolder, file.getName())).exists()) continue;
            System.out.println("Relocating " + file.getName());
            file.renameTo(file3);
        }
    }
}

