/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.src.AchievementList;
import net.minecraft.src.Block;
import net.minecraft.src.CraftingManager;
import net.minecraft.src.IRecipe;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.RecipesFurnace;
import net.minecraft.src.StatBase;
import net.minecraft.src.StatBasic;
import net.minecraft.src.StatItem;
import net.minecraft.src.StatStringTranslate;

public abstract class StatList {
    protected static Map<Integer, StatBase> statMap = new HashMap<Integer, StatBase>();
    public static List<StatBase> statList1 = new ArrayList<StatBase>();
    public static List<StatBase> statList2 = new ArrayList<StatBase>();
    public static List<StatBase> usedItemStatsList = new ArrayList<StatBase>();
    public static List<StatBase> statList3 = new ArrayList<StatBase>();
    public static StatBase startGameStat = new StatBasic(1000, StatStringTranslate.translateToLocal("stat.startGame")).setClientside().registerStat();
    public static StatBase createWorldStat = new StatBasic(1001, StatStringTranslate.translateToLocal("stat.createWorld")).setClientside().registerStat();
    public static StatBase loadWorldStat = new StatBasic(1002, StatStringTranslate.translateToLocal("stat.loadWorld")).setClientside().registerStat();
    public static StatBase joinMultiplayerStat = new StatBasic(1003, StatStringTranslate.translateToLocal("stat.joinMultiplayer")).setClientside().registerStat();
    public static StatBase leaveGameStat = new StatBasic(1004, StatStringTranslate.translateToLocal("stat.leaveGame")).setClientside().registerStat();
    public static StatBase minutesPlayedStat = new StatBasic(1100, StatStringTranslate.translateToLocal("stat.playOneMinute"), StatBase.statTypeTime).setClientside().registerStat();
    public static StatBase distanceWalkedStat = new StatBasic(2000, StatStringTranslate.translateToLocal("stat.walkOneCm"), StatBase.statTypeDistance).setClientside().registerStat();
    public static StatBase distanceSwumStat = new StatBasic(2001, StatStringTranslate.translateToLocal("stat.swimOneCm"), StatBase.statTypeDistance).setClientside().registerStat();
    public static StatBase distanceFallenStat = new StatBasic(2002, StatStringTranslate.translateToLocal("stat.fallOneCm"), StatBase.statTypeDistance).setClientside().registerStat();
    public static StatBase distanceClimbedStat = new StatBasic(2003, StatStringTranslate.translateToLocal("stat.climbOneCm"), StatBase.statTypeDistance).setClientside().registerStat();
    public static StatBase distanceFlownStat = new StatBasic(2004, StatStringTranslate.translateToLocal("stat.flyOneCm"), StatBase.statTypeDistance).setClientside().registerStat();
    public static StatBase distanceDoveStat = new StatBasic(2005, StatStringTranslate.translateToLocal("stat.diveOneCm"), StatBase.statTypeDistance).setClientside().registerStat();
    public static StatBase distanceByMinecartStat = new StatBasic(2006, StatStringTranslate.translateToLocal("stat.minecartOneCm"), StatBase.statTypeDistance).setClientside().registerStat();
    public static StatBase distanceByBoatStat = new StatBasic(2007, StatStringTranslate.translateToLocal("stat.boatOneCm"), StatBase.statTypeDistance).setClientside().registerStat();
    public static StatBase distanceByPigStat = new StatBasic(2008, StatStringTranslate.translateToLocal("stat.pigOneCm"), StatBase.statTypeDistance).setClientside().registerStat();
    public static StatBase jumpStat = new StatBasic(2010, StatStringTranslate.translateToLocal("stat.jump")).setClientside().registerStat();
    public static StatBase dropStat = new StatBasic(2011, StatStringTranslate.translateToLocal("stat.drop")).setClientside().registerStat();
    public static StatBase damageDealtStat = new StatBasic(2020, StatStringTranslate.translateToLocal("stat.damageDealt")).registerStat();
    public static StatBase damageTakenStat = new StatBasic(2021, StatStringTranslate.translateToLocal("stat.damageTaken")).registerStat();
    public static StatBase deathsStat = new StatBasic(2022, StatStringTranslate.translateToLocal("stat.deaths")).registerStat();
    public static StatBase mobKillsStat = new StatBasic(2023, StatStringTranslate.translateToLocal("stat.mobKills")).registerStat();
    public static StatBase playerKillsStat = new StatBasic(2024, StatStringTranslate.translateToLocal("stat.playerKills")).registerStat();
    public static StatBase fishCaughtStat = new StatBasic(2025, StatStringTranslate.translateToLocal("stat.fishCaught")).registerStat();
    public static StatBase[] mineBlockStatArray = StatList.func_25153_a("stat.mineBlock", 0x1000000);
    public static StatBase[] craftedItemStats;
    public static StatBase[] usedItemStats;
    public static StatBase[] breakItemStats;
    public static StatBase[] pickUpItemStats;
    private static boolean blocksInitialized;
    private static boolean itemsInitialized;

    public static void init() {
    }

    public static void onBlockInit() {
        usedItemStats = StatList.initUsedItemStats(usedItemStats, "stat.useItem", 0x1020000, 0, Block.blocksList.length);
        breakItemStats = StatList.initBreakItemStats(breakItemStats, "stat.breakItem", 0x1030000, 0, Block.blocksList.length);
        blocksInitialized = true;
        StatList.blocksAndItemsInitialized();
    }

    public static void onItemInit() {
        usedItemStats = StatList.initUsedItemStats(usedItemStats, "stat.useItem", 0x1020000, Block.blocksList.length, Item.itemsList.length);
        breakItemStats = StatList.initBreakItemStats(breakItemStats, "stat.breakItem", 0x1030000, Block.blocksList.length, Item.itemsList.length);
        itemsInitialized = true;
        StatList.blocksAndItemsInitialized();
    }

    public static void blocksAndItemsInitialized() {
        if (!blocksInitialized || !itemsInitialized) {
            return;
        }
        HashSet<Integer> hashset = new HashSet<Integer>();
        for (IRecipe irecipe : CraftingManager.getInstance().getRecipeList()) {
            hashset.add(irecipe.getRecipeOutput().itemID);
        }
        for (ItemStack itemstack : RecipesFurnace.smelting().getSmeltingList().values()) {
            hashset.add(itemstack.itemID);
        }
        craftedItemStats = new StatBase[Item.itemsList.length];
        pickUpItemStats = new StatBase[Item.itemsList.length];
        for (Integer integer : hashset) {
            if (Item.itemsList[integer] == null) continue;
            String s2 = StatStringTranslate.translateToLocalFormatted("stat.craftItem", new Object[]{Item.itemsList[integer].getStatName()});
            StatList.craftedItemStats[integer.intValue()] = new StatItem(0x1010000 + integer, s2, integer).registerStat();
        }
        for (int i2 = 0; i2 < Item.itemsList.length; ++i2) {
            StatList.pickUpItemStats[i2] = new StatItem(0x1040000 + i2, "", i2).registerStat();
        }
        StatList.replaceAllSimilarBlocks(craftedItemStats);
    }

    private static StatBase[] func_25153_a(String s2, int i2) {
        StatBase[] astatbase = new StatBase[Block.blocksList.length];
        for (int j2 = 0; j2 < Block.blocksList.length; ++j2) {
            if (Block.blocksList[j2] == null || !Block.blocksList[j2].getEnableStats()) continue;
            String s1 = StatStringTranslate.translateToLocalFormatted(s2, new Object[]{Block.blocksList[j2].translateBlockName(0)});
            astatbase[j2] = new StatItem(i2 + j2, s1, j2).registerStat();
            statList3.add((StatItem)astatbase[j2]);
        }
        StatList.replaceAllSimilarBlocks(astatbase);
        return astatbase;
    }

    private static StatBase[] initUsedItemStats(StatBase[] astatbase, String s2, int i2, int j2, int k2) {
        if (astatbase == null) {
            astatbase = new StatBase[Item.itemsList.length];
        }
        for (int l2 = j2; l2 < k2; ++l2) {
            if (Item.itemsList[l2] == null) continue;
            String s1 = StatStringTranslate.translateToLocalFormatted(s2, new Object[]{Item.itemsList[l2].getStatName()});
            astatbase[l2] = new StatItem(i2 + l2, s1, l2).registerStat();
            if (l2 < Block.blocksList.length) continue;
            usedItemStatsList.add((StatItem)astatbase[l2]);
        }
        StatList.replaceAllSimilarBlocks(astatbase);
        return astatbase;
    }

    private static StatBase[] initBreakItemStats(StatBase[] astatbase, String s2, int i2, int j2, int k2) {
        if (astatbase == null) {
            astatbase = new StatBase[Item.itemsList.length];
        }
        for (int l2 = j2; l2 < k2; ++l2) {
            if (Item.itemsList[l2] == null || !Item.itemsList[l2].isDamagable()) continue;
            String s1 = StatStringTranslate.translateToLocalFormatted(s2, new Object[]{Item.itemsList[l2].getStatName()});
            astatbase[l2] = new StatItem(i2 + l2, s1, l2).registerStat();
        }
        StatList.replaceAllSimilarBlocks(astatbase);
        return astatbase;
    }

    private static void replaceAllSimilarBlocks(StatBase[] astatbase) {
        StatList.replaceSimilarBlocks(astatbase, Block.fluidWaterStill.blockID, Block.fluidWaterFlowing.blockID);
        StatList.replaceSimilarBlocks(astatbase, Block.fluidLavaStill.blockID, Block.fluidLavaStill.blockID);
        StatList.replaceSimilarBlocks(astatbase, Block.pumpkinCarvedActive.blockID, Block.pumpkinCarvedIdle.blockID);
        StatList.replaceSimilarBlocks(astatbase, Block.furnaceStoneActive.blockID, Block.furnaceStoneIdle.blockID);
        StatList.replaceSimilarBlocks(astatbase, Block.oreRedstoneGlowingStone.blockID, Block.oreRedstoneStone.blockID);
        StatList.replaceSimilarBlocks(astatbase, Block.repeaterActive.blockID, Block.repeaterIdle.blockID);
        StatList.replaceSimilarBlocks(astatbase, Block.torchRedstoneActive.blockID, Block.torchRedstoneIdle.blockID);
        StatList.replaceSimilarBlocks(astatbase, Block.mushroomRed.blockID, Block.mushroomBrown.blockID);
        StatList.replaceSimilarBlocks(astatbase, Block.grass.blockID, Block.dirt.blockID);
        StatList.replaceSimilarBlocks(astatbase, Block.farmlandDirt.blockID, Block.dirt.blockID);
    }

    private static void replaceSimilarBlocks(StatBase[] astatbase, int i2, int j2) {
        if (astatbase[i2] != null && astatbase[j2] == null) {
            astatbase[j2] = astatbase[i2];
            return;
        }
        statList1.remove(astatbase[i2]);
        statList3.remove(astatbase[i2]);
        statList2.remove(astatbase[i2]);
        astatbase[i2] = astatbase[j2];
    }

    public static StatBase getStat(int i2) {
        return statMap.get(i2);
    }

    static {
        blocksInitialized = false;
        itemsInitialized = false;
        AchievementList.init();
    }
}

