/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.io.InputStream;
import java.util.Properties;

public class StringTranslate {
    private static StringTranslate instance = new StringTranslate();
    private Properties translateTable = new Properties();

    private StringTranslate() {
        try {
            InputStream stream = StringTranslate.class.getResourceAsStream("/lang/en_US.lang");
            this.translateTable.load(stream);
            stream.close();
            stream = StringTranslate.class.getResourceAsStream("/lang/stats_US.lang");
            this.translateTable.load(stream);
            stream.close();
        }
        catch (Exception ioexception) {
            ioexception.printStackTrace();
        }
        System.out.println(this.translateTable.size() + " Translation Keys");
    }

    public static StringTranslate getInstance() {
        return instance;
    }

    public String translateKey(String s2) {
        if (s2 == null) {
            return null;
        }
        String translated = this.translateTable.getProperty(s2);
        if (translated == null) {
            System.err.println("Missing translation: " + s2 + "\n at " + Thread.currentThread().getStackTrace()[2]);
            return s2;
        }
        return translated;
    }

    public String translateKeyFormat(String s2, Object[] aobj) {
        String s1 = this.translateTable.getProperty(s2, s2);
        return String.format(s1, aobj);
    }

    public String translateNamedKey(String s2) {
        return this.translateTable.getProperty(s2 + ".name", s2);
    }

    public String translateKeyDescription(String s2) {
        return this.translateTable.getProperty(s2 + ".desc", "");
    }
}

