/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.BlockPortal;
import net.minecraft.src.Dimension;
import net.minecraft.src.Entity;
import net.minecraft.src.MathHelper;
import net.minecraft.src.World;

public class Teleporter {
    private Random rand = new Random();

    public void func_4107_a(World world, Entity entity, Dimension oldDim, Dimension newDim) {
        if (this.func_4106_b(world, entity, oldDim, newDim)) {
            return;
        }
        this.func_4108_c(world, entity, oldDim, newDim);
        this.func_4106_b(world, entity, oldDim, newDim);
    }

    public boolean func_4106_b(World world, Entity entity, Dimension oldDim, Dimension newDim) {
        int c2 = 128;
        double d2 = -1.0;
        int i2 = 0;
        int j2 = 0;
        int k2 = 0;
        int l2 = MathHelper.floor_double(entity.posX);
        int i1 = MathHelper.floor_double(entity.posZ);
        int targetPortalId = newDim.homeDim == null ? oldDim.portalBlockId : newDim.portalBlockId;
        for (int j1 = l2 - c2; j1 <= l2 + c2; ++j1) {
            double d1 = (double)j1 + 0.5 - entity.posX;
            for (int j22 = i1 - c2; j22 <= i1 + c2; ++j22) {
                double d3 = (double)j22 + 0.5 - entity.posZ;
                for (int k22 = Minecraft.WORLD_HEIGHT_BLOCKS - 1; k22 >= 0; --k22) {
                    if (world.getBlockId(j1, k22, j22) != targetPortalId) continue;
                    while (world.getBlockId(j1, k22 - 1, j22) == targetPortalId) {
                        --k22;
                    }
                    double d5 = (double)k22 + 0.5 - entity.posY;
                    double d7 = d1 * d1 + d5 * d5 + d3 * d3;
                    if (!(d2 < 0.0) && !(d7 < d2)) continue;
                    d2 = d7;
                    i2 = j1;
                    j2 = k22;
                    k2 = j22;
                }
            }
        }
        if (d2 >= 0.0) {
            int k1 = i2;
            int l1 = j2;
            int i22 = k2;
            double d22 = (double)k1 + 0.5;
            double d4 = (double)l1 + 0.5;
            double d6 = (double)i22 + 0.5;
            if (world.getBlockId(k1 - 1, l1, i22) == targetPortalId) {
                d22 -= 0.5;
            }
            if (world.getBlockId(k1 + 1, l1, i22) == targetPortalId) {
                d22 += 0.5;
            }
            if (world.getBlockId(k1, l1, i22 - 1) == targetPortalId) {
                d6 -= 0.5;
            }
            if (world.getBlockId(k1, l1, i22 + 1) == targetPortalId) {
                d6 += 0.5;
            }
            entity.setLocationAndAngles(d22, d4, d6, entity.rotationYaw, 0.0f);
            entity.motionZ = 0.0;
            entity.motionY = 0.0;
            entity.motionX = 0.0;
            return true;
        }
        return false;
    }

    public boolean func_4108_c(World world, Entity entity, Dimension oldDim, Dimension newDim) {
        int z2;
        int y2;
        int x2;
        int targetPortalId;
        int targetPortalMaterialId;
        int portalSearchRadius = 16;
        double d2 = -1.0;
        int entityX = MathHelper.floor_double(entity.posX);
        int entityY = MathHelper.floor_double(entity.posY);
        int entityZ = MathHelper.floor_double(entity.posZ);
        int l2 = entityX;
        int i1 = entityY;
        int j1 = entityZ;
        int k1 = 0;
        int l1 = this.rand.nextInt(4);
        if (newDim.homeDim == null) {
            targetPortalMaterialId = ((BlockPortal)Block.blocksList[oldDim.portalBlockId]).portalMaterialId;
            targetPortalId = oldDim.portalBlockId;
        } else {
            targetPortalMaterialId = ((BlockPortal)Block.blocksList[newDim.portalBlockId]).portalMaterialId;
            targetPortalId = newDim.portalBlockId;
        }
        for (int dx2 = entityX - portalSearchRadius; dx2 <= entityX + portalSearchRadius; ++dx2) {
            double d1 = (double)dx2 + 0.5 - entity.posX;
            for (int dz2 = entityZ - portalSearchRadius; dz2 <= entityZ + portalSearchRadius; ++dz2) {
                double d3 = (double)dz2 + 0.5 - entity.posZ;
                block2: for (int dy2 = Minecraft.WORLD_HEIGHT_BLOCKS - 1; dy2 >= 0; --dy2) {
                    if (!world.isAirBlock(dx2, dy2, dz2)) continue;
                    while (dy2 > 0 && world.isAirBlock(dx2, dy2 - 1, dz2)) {
                        --dy2;
                    }
                    for (int k5 = l1; k5 < l1 + 4; ++k5) {
                        int l6 = k5 % 2;
                        int i8 = 1 - l6;
                        if (k5 % 4 >= 2) {
                            l6 = -l6;
                            i8 = -i8;
                        }
                        for (int j9 = 0; j9 < 3; ++j9) {
                            for (int k10 = 0; k10 < 4; ++k10) {
                                for (int l11 = -1; l11 < 4; ++l11) {
                                    int j12 = dx2 + (k10 - 1) * l6 + j9 * i8;
                                    int l12 = dy2 + l11;
                                    int j13 = dz2 + (k10 - 1) * i8 - j9 * l6;
                                    if (l11 < 0 && !world.getBlockMaterial(j12, l12, j13).isSolid() || l11 >= 0 && !world.isAirBlock(j12, l12, j13)) continue block2;
                                }
                            }
                        }
                        double d5 = (double)dy2 + 0.5 - entity.posY;
                        double d7 = d1 * d1 + d5 * d5 + d3 * d3;
                        if (!(d2 < 0.0) && !(d7 < d2)) continue;
                        d2 = d7;
                        l2 = dx2;
                        i1 = dy2;
                        j1 = dz2;
                        k1 = k5 % 4;
                    }
                }
            }
        }
        if (d2 < 0.0) {
            for (int j2 = entityX - portalSearchRadius; j2 <= entityX + portalSearchRadius; ++j2) {
                double d22 = (double)j2 + 0.5 - entity.posX;
                for (int k3 = entityZ - portalSearchRadius; k3 <= entityZ + portalSearchRadius; ++k3) {
                    double d4 = (double)k3 + 0.5 - entity.posZ;
                    block10: for (int l4 = Minecraft.WORLD_HEIGHT_BLOCKS - 1; l4 >= 0; --l4) {
                        if (!world.isAirBlock(j2, l4, k3)) continue;
                        while (world.isAirBlock(j2, l4 - 1, k3) && l4 > 0) {
                            --l4;
                        }
                        for (int l5 = l1; l5 < l1 + 2; ++l5) {
                            int i7 = l5 % 2;
                            int j8 = 1 - i7;
                            for (int k9 = 0; k9 < 4; ++k9) {
                                for (int l10 = -1; l10 < 4; ++l10) {
                                    int i12 = j2 + (k9 - 1) * i7;
                                    int k12 = l4 + l10;
                                    int i13 = k3 + (k9 - 1) * j8;
                                    if (l10 < 0 && !world.getBlockMaterial(i12, k12, i13).isSolid() || l10 >= 0 && !world.isAirBlock(i12, k12, i13)) continue block10;
                                }
                            }
                            double d6 = (double)l4 + 0.5 - entity.posY;
                            double d8 = d22 * d22 + d6 * d6 + d4 * d4;
                            if (!(d2 < 0.0) && !(d8 < d2)) continue;
                            d2 = d8;
                            l2 = j2;
                            i1 = l4;
                            j1 = k3;
                            k1 = l5 % 2;
                        }
                    }
                }
            }
        }
        int k2 = k1;
        int l22 = l2;
        int i3 = i1;
        int l3 = j1;
        int i4 = k2 % 2;
        int j4 = 1 - i4;
        if (k2 % 4 >= 2) {
            i4 = -i4;
            j4 = -j4;
        }
        if (d2 < 0.0) {
            if (i1 < 198) {
                i1 = 198;
            }
            if (i1 > 246) {
                i1 = 246;
            }
            i3 = i1;
            for (int i5 = -1; i5 <= 1; ++i5) {
                for (int i6 = 1; i6 < 3; ++i6) {
                    for (int j7 = -1; j7 < 3; ++j7) {
                        x2 = l22 + (i6 - 1) * i4 + i5 * j4;
                        y2 = i3 + j7;
                        z2 = l3 + (i6 - 1) * j4 - i5 * i4;
                        boolean flag = j7 < 0;
                        world.setBlockWithNotify(x2, y2, z2, flag ? targetPortalMaterialId : 0);
                    }
                }
            }
        }
        for (int j5 = 0; j5 < 4; ++j5) {
            world.editingBlocks = true;
            for (int j6 = 0; j6 < 4; ++j6) {
                for (int k7 = -1; k7 < 4; ++k7) {
                    x2 = l22 + (j6 - 1) * i4;
                    y2 = i3 + k7;
                    z2 = l3 + (j6 - 1) * j4;
                    boolean flag1 = j6 == 0 || j6 == 3 || k7 == -1 || k7 == 3;
                    world.setBlockWithNotify(x2, y2, z2, flag1 ? targetPortalMaterialId : 0);
                }
            }
            ((BlockPortal)Block.blocksList[targetPortalId]).tryToCreatePortal(world, l22, i3, l3);
            world.editingBlocks = false;
            for (int k6 = 0; k6 < 4; ++k6) {
                for (int l7 = -1; l7 < 4; ++l7) {
                    int i9 = l22 + (k6 - 1) * i4;
                    int j10 = i3 + l7;
                    int k11 = l3 + (k6 - 1) * j4;
                    world.notifyBlocksOfNeighborChange(i9, j10, k11, world.getBlockId(i9, j10, k11));
                }
            }
        }
        return true;
    }
}

