/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.src.TexturePackBase;
import org.lwjgl.opengl.GL11;

public class TexturePackCustom
extends TexturePackBase {
    private ZipFile texturePackZipFile;
    private int texturePackName = -1;
    private BufferedImage texturePackThumbnail;
    private File texturePackFile;

    public TexturePackCustom(File file) {
        this.texturePackFileName = file.getName();
        this.texturePackFile = file;
    }

    private String truncateString(String s2) {
        if (s2 != null && s2.length() > 34) {
            s2 = s2.substring(0, 34);
        }
        return s2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void func_6485_a(Minecraft minecraft) throws IOException {
        if (this.texturePackFile.isFile()) {
            ZipFile zipfile = null;
            InputStream inputstream = null;
            try {
                zipfile = new ZipFile(this.texturePackFile);
                try {
                    inputstream = zipfile.getInputStream(zipfile.getEntry("pack.txt"));
                    BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputstream));
                    this.firstDescriptionLine = this.truncateString(bufferedreader.readLine());
                    this.secondDescriptionLine = this.truncateString(bufferedreader.readLine());
                    bufferedreader.close();
                    inputstream.close();
                }
                catch (Exception bufferedreader) {
                    // empty catch block
                }
                try {
                    inputstream = zipfile.getInputStream(zipfile.getEntry("pack.png"));
                    this.texturePackThumbnail = ImageIO.read(inputstream);
                    inputstream.close();
                }
                catch (Exception bufferedreader) {
                    // empty catch block
                }
                zipfile.close();
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
            }
            finally {
                try {
                    inputstream.close();
                }
                catch (Exception exception) {}
                try {
                    zipfile.close();
                }
                catch (Exception exception) {}
            }
        } else if (this.texturePackFile.isDirectory()) {
            InputStream inputstream = null;
            try {
                inputstream = new FileInputStream(new File(this.texturePackFile, "pack.txt"));
                BufferedReader bufferedreader = new BufferedReader(new InputStreamReader(inputstream));
                this.firstDescriptionLine = this.truncateString(bufferedreader.readLine());
                this.secondDescriptionLine = this.truncateString(bufferedreader.readLine());
                bufferedreader.close();
                inputstream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                inputstream = new FileInputStream(new File(this.texturePackFile, "pack.png"));
                this.texturePackThumbnail = ImageIO.read(inputstream);
                inputstream.close();
            }
            catch (Exception exception) {
            }
            finally {
                try {
                    inputstream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public void func_6484_b(Minecraft minecraft) {
        if (this.texturePackThumbnail != null) {
            minecraft.renderEngine.deleteTexture(this.texturePackName);
        }
        this.closeTexturePackFile();
    }

    @Override
    public void bindThumbnailTexture(Minecraft minecraft) {
        if (this.texturePackThumbnail != null && this.texturePackName < 0) {
            this.texturePackName = minecraft.renderEngine.allocateAndSetupTexture(this.texturePackThumbnail);
        }
        if (this.texturePackThumbnail != null) {
            minecraft.renderEngine.bindTexture(this.texturePackName);
        } else {
            GL11.glBindTexture((int)3553, (int)minecraft.renderEngine.getTexture("/gui/unknown_pack.png"));
        }
    }

    @Override
    public void func_6482_a() {
        try {
            this.texturePackZipFile = new ZipFile(this.texturePackFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void closeTexturePackFile() {
        try {
            this.texturePackZipFile.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.texturePackZipFile = null;
    }

    @Override
    public InputStream getResourceAsStream(String s2) {
        if (this.texturePackFile.isFile()) {
            try {
                ZipEntry zipentry = this.texturePackZipFile.getEntry(s2.substring(1));
                if (zipentry != null) {
                    return this.texturePackZipFile.getInputStream(zipentry);
                }
            }
            catch (Exception zipentry) {
                // empty catch block
            }
            return TexturePackBase.class.getResourceAsStream(s2);
        }
        try {
            File file = new File(this.texturePackFile, s2.substring(1));
            if (file.exists()) {
                return new FileInputStream(file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return TexturePackBase.class.getResourceAsStream(s2);
    }

    @Override
    public boolean hasFile(String file) {
        if (this.texturePackFile.isFile()) {
            ZipFile zipfile = null;
            boolean h2 = false;
            try {
                zipfile = new ZipFile(this.texturePackFile);
                h2 = zipfile.getEntry(file.substring(1)) != null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                zipfile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            return h2;
        }
        return new File(this.texturePackFile, file).exists();
    }
}

