/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.src.TexturePackBase;
import org.lwjgl.opengl.GL11;

public class TexturePackDefault
extends TexturePackBase {
    private int texturePackName = -1;
    private BufferedImage texturePackThumbnail;

    public TexturePackDefault() {
        this.texturePackFileName = "Default";
        this.firstDescriptionLine = "The default look of Minecraft";
        try {
            this.texturePackThumbnail = ImageIO.read(TexturePackDefault.class.getResource("/pack.png"));
        }
        catch (IOException ioexception) {
            ioexception.printStackTrace();
        }
    }

    @Override
    public void func_6484_b(Minecraft minecraft) {
        if (this.texturePackThumbnail != null) {
            minecraft.renderEngine.deleteTexture(this.texturePackName);
        }
    }

    @Override
    public void bindThumbnailTexture(Minecraft minecraft) {
        if (this.texturePackThumbnail != null && this.texturePackName < 0) {
            this.texturePackName = minecraft.renderEngine.allocateAndSetupTexture(this.texturePackThumbnail);
        }
        if (this.texturePackThumbnail != null) {
            minecraft.renderEngine.bindTexture(this.texturePackName);
        } else {
            GL11.glBindTexture((int)3553, (int)minecraft.renderEngine.getTexture("/gui/unknown_pack.png"));
        }
    }

    @Override
    public boolean hasFile(String file) {
        try {
            boolean a2;
            InputStream stream = TexturePackDefault.class.getResourceAsStream(file);
            boolean bl2 = a2 = stream != null;
            if (stream != null) {
                stream.close();
            }
            return a2;
        }
        catch (Exception e2) {
            return false;
        }
    }
}

