/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.PositionTextureVertex;
import net.minecraft.src.Tessellator;
import net.minecraft.src.Vec3D;

public class TexturedQuad {
    public PositionTextureVertex[] vertexPositions;
    public int nVertices = 0;
    private boolean invertNormal = false;

    public TexturedQuad(PositionTextureVertex[] apositiontexturevertex) {
        this.vertexPositions = apositiontexturevertex;
        this.nVertices = apositiontexturevertex.length;
    }

    public TexturedQuad(PositionTextureVertex[] apositiontexturevertex, int i2, int j2, int k2, int l2) {
        this(apositiontexturevertex);
        float f2 = 0.0015625f;
        float f1 = 0.003125f;
        apositiontexturevertex[0] = apositiontexturevertex[0].setTexturePosition((float)k2 / 64.0f - f2, (float)j2 / 32.0f + f1);
        apositiontexturevertex[1] = apositiontexturevertex[1].setTexturePosition((float)i2 / 64.0f + f2, (float)j2 / 32.0f + f1);
        apositiontexturevertex[2] = apositiontexturevertex[2].setTexturePosition((float)i2 / 64.0f + f2, (float)l2 / 32.0f - f1);
        apositiontexturevertex[3] = apositiontexturevertex[3].setTexturePosition((float)k2 / 64.0f - f2, (float)l2 / 32.0f - f1);
    }

    public void flipFace() {
        PositionTextureVertex[] apositiontexturevertex = new PositionTextureVertex[this.vertexPositions.length];
        for (int i2 = 0; i2 < this.vertexPositions.length; ++i2) {
            apositiontexturevertex[i2] = this.vertexPositions[this.vertexPositions.length - i2 - 1];
        }
        this.vertexPositions = apositiontexturevertex;
    }

    public void draw(Tessellator tessellator, float f2) {
        Vec3D vec3d = this.vertexPositions[1].vector3D.subtract(this.vertexPositions[0].vector3D);
        Vec3D vec3d1 = this.vertexPositions[1].vector3D.subtract(this.vertexPositions[2].vector3D);
        Vec3D vec3d2 = vec3d1.crossProduct(vec3d).normalize();
        tessellator.startDrawingQuads();
        if (this.invertNormal) {
            tessellator.setNormal(-((float)vec3d2.xCoord), -((float)vec3d2.yCoord), -((float)vec3d2.zCoord));
        } else {
            tessellator.setNormal((float)vec3d2.xCoord, (float)vec3d2.yCoord, (float)vec3d2.zCoord);
        }
        for (int i2 = 0; i2 < 4; ++i2) {
            PositionTextureVertex positiontexturevertex = this.vertexPositions[i2];
            tessellator.addVertexWithUV((float)positiontexturevertex.vector3D.xCoord * f2, (float)positiontexturevertex.vector3D.yCoord * f2, (float)positiontexturevertex.vector3D.zCoord * f2, positiontexturevertex.texturePositionX, positiontexturevertex.texturePositionY);
        }
        tessellator.draw();
    }
}

