/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import b100.json.JsonParser;
import b100.json.element.JsonElement;
import b100.json.element.JsonObject;
import b100.utils.FileUtils;
import b100.utils.StreamUtils;
import b100.xml.XmlFile;
import b100.xml.XmlParser;
import b100.xml.element.XmlContentTag;
import b100.xml.element.XmlTag;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;

public class ThreadDownloadResources
extends Thread {
    public static String[] extractFiles = new String[]{"sound/ui/ui_back.ogg", "sound/ui/ui_click.ogg", "sound/ui/ui_focus.ogg", "sound/ui/ui_scroll.ogg", "sound/ui/crafting_fail.ogg", "sound/ui/crafting_made.ogg"};
    public static String resourceDomain = "http://resourceproxy.pymcl.net/MinecraftResources/";
    public final Minecraft mc;
    public File resourcesFolder;
    public volatile boolean downloading = false;
    public volatile int downloadProgress;
    public volatile int toDownload;

    public ThreadDownloadResources(File file, Minecraft minecraft) {
        super("Resource Download");
        this.mc = minecraft;
        this.setDaemon(true);
        this.resourcesFolder = new File(file, "resources/");
        if (!this.resourcesFolder.exists() && !this.resourcesFolder.mkdirs()) {
            throw new RuntimeException("The working directory could not be created: " + this.resourcesFolder);
        }
    }

    @Override
    public void run() {
        try {
            for (int i2 = 0; i2 < extractFiles.length; ++i2) {
                File file = new File(this.resourcesFolder, "newsound/random/" + extractFiles[i2]);
                if (file.exists()) continue;
                StreamUtils.transferDataAndClose(ThreadDownloadResources.class.getResourceAsStream("/" + extractFiles[i2]), new FileOutputStream(FileUtils.createNewFile(file)));
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
        try {
            if (((Boolean)this.mc.gameSettings.downloadSoundfiles.value).booleanValue()) {
                System.out.println("Downloading sounds...");
                try {
                    this.downloadResources();
                }
                catch (Exception e3) {
                    this.downloading = false;
                    System.err.println("Error downloading sounds...");
                    e3.printStackTrace();
                }
            }
        }
        catch (Exception e4) {
            e4.printStackTrace();
        }
        this.load();
    }

    public void reloadResources() {
        this.load();
    }

    public void load() {
        List<File> files;
        if (((Boolean)this.mc.gameSettings.loadAllSounds.value).booleanValue()) {
            files = FileUtils.getAllFiles(this.resourcesFolder);
        } else {
            files = new ArrayList<File>();
            for (JsonElement element : ((JsonObject)new JsonParser().parseStream(ThreadDownloadResources.class.getResourceAsStream("/sounds.json"))).getArray("sounds")) {
                files.add(new File(this.resourcesFolder, element.getAsString().value));
            }
        }
        int pathLength = this.resourcesFolder.getAbsolutePath().length() + 1;
        int installCount = 0;
        for (File file : files) {
            String string = file.getAbsolutePath().substring(pathLength).replace("\\", "/");
            if (string.indexOf("/") == -1) continue;
            try {
                this.mc.installResource(string, file);
            }
            catch (Exception e2) {
                System.err.println("Could not install resource: " + string + " " + e2.getClass().getName() + ": " + e2.getMessage());
            }
            ++installCount;
        }
        System.out.println("Installed " + installCount + " Sound Files!");
    }

    public void downloadResources() {
        XmlFile file = (XmlFile)new XmlParser().parseWebsite(resourceDomain);
        XmlContentTag content = file.getRootElement().getAsContentTag();
        ArrayList<SoundEntry> entries = new ArrayList<SoundEntry>();
        for (XmlTag tag : (List)content.content()) {
            if (!tag.name().equals("Contents")) continue;
            String name = (String)tag.getAsContentTag().get("Key").getAsStringTag().content();
            long size = tag.getAsContentTag().get("Size").getAsStringTag().getLong();
            File soundFile = new File(this.resourcesFolder, name);
            if (soundFile.isFile() && (((Boolean)this.mc.gameSettings.allowSoundOverrides.value).booleanValue() || soundFile.length() == size)) continue;
            entries.add(new SoundEntry(soundFile, name, size));
        }
        if (entries.size() == 0) {
            return;
        }
        this.downloading = true;
        this.toDownload = entries.size();
        for (SoundEntry soundEntry : entries) {
            try {
                this.downloadSoundFile(soundEntry.name, soundEntry.file);
                ++this.downloadProgress;
            }
            catch (Exception e2) {
                throw new RuntimeException("Error downloading sound file: " + soundEntry.name, e2);
            }
        }
        this.downloading = false;
    }

    private void downloadSoundFile(String name, File file) throws Exception {
        String url = resourceDomain + name;
        url = url.replace(" ", "%20");
        System.out.println("Downloading File: " + url);
        StreamUtils.transferDataAndClose(new BufferedInputStream(new URL(url).openStream()), new BufferedOutputStream(new FileOutputStream(FileUtils.createNewFile(file))));
    }

    private static class SoundEntry {
        private File file;
        private String name;
        private long size;

        public SoundEntry(File file, String name, long size) {
            this.file = file;
            this.name = name;
            this.size = size;
        }
    }
}

