/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.IInventory;
import net.minecraft.src.ItemStack;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NBTTagList;
import net.minecraft.src.TileEntity;

public class TileEntityDispenser
extends TileEntity
implements IInventory {
    private ItemStack[] dispenserContents = new ItemStack[9];
    private Random dispenserRandom = new Random();

    @Override
    public int getSizeInventory() {
        return 9;
    }

    @Override
    public ItemStack getStackInSlot(int i2) {
        return this.dispenserContents[i2];
    }

    @Override
    public ItemStack decrStackSize(int i2, int j2) {
        if (this.dispenserContents[i2] != null) {
            if (this.dispenserContents[i2].stackSize <= j2) {
                ItemStack itemstack = this.dispenserContents[i2];
                this.dispenserContents[i2] = null;
                this.onInventoryChanged();
                return itemstack;
            }
            ItemStack itemstack1 = this.dispenserContents[i2].splitStack(j2);
            if (this.dispenserContents[i2].stackSize == 0) {
                this.dispenserContents[i2] = null;
            }
            this.onInventoryChanged();
            return itemstack1;
        }
        return null;
    }

    public ItemStack getRandomStackFromInventory() {
        int i2 = -1;
        int j2 = 1;
        for (int k2 = 0; k2 < this.dispenserContents.length; ++k2) {
            if (this.dispenserContents[k2] == null || this.dispenserRandom.nextInt(j2++) != 0) continue;
            i2 = k2;
        }
        if (i2 >= 0) {
            return this.decrStackSize(i2, 1);
        }
        return null;
    }

    @Override
    public void setInventorySlotContents(int i2, ItemStack itemstack) {
        this.dispenserContents[i2] = itemstack;
        if (itemstack != null && itemstack.stackSize > this.getInventoryStackLimit()) {
            itemstack.stackSize = this.getInventoryStackLimit();
        }
        this.onInventoryChanged();
    }

    @Override
    public String getInvName() {
        return "Trap";
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        NBTTagList nbttaglist = nbttagcompound.getTagList("Items");
        this.dispenserContents = new ItemStack[this.getSizeInventory()];
        for (int i2 = 0; i2 < nbttaglist.tagCount(); ++i2) {
            NBTTagCompound nbttagcompound1 = (NBTTagCompound)nbttaglist.tagAt(i2);
            int j2 = nbttagcompound1.getByte("Slot") & 0xFF;
            if (j2 < 0 || j2 >= this.dispenserContents.length) continue;
            this.dispenserContents[j2] = new ItemStack(nbttagcompound1);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i2 = 0; i2 < this.dispenserContents.length; ++i2) {
            if (this.dispenserContents[i2] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.setByte("Slot", (byte)i2);
            this.dispenserContents[i2].writeToNBT(nbttagcompound1);
            nbttaglist.setTag(nbttagcompound1);
        }
        nbttagcompound.setTag("Items", nbttaglist);
    }

    @Override
    public int getInventoryStackLimit() {
        return 64;
    }

    @Override
    public boolean canInteractWith(EntityPlayer entityplayer) {
        if (this.worldObj.getBlockTileEntity(this.xCoord, this.yCoord, this.zCoord) != this) {
            return false;
        }
        return entityplayer.getDistanceSq((double)this.xCoord + 0.5, (double)this.yCoord + 0.5, (double)this.zCoord + 0.5) <= 64.0;
    }
}

