/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.BlockPistonMoving;
import net.minecraft.src.Entity;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.PistonModel;
import net.minecraft.src.TileEntity;

public class TileEntityPiston
extends TileEntity {
    private int storedBlockID;
    private int storedMetadata;
    private int field_31025_c;
    private boolean field_31024_i;
    private boolean field_31023_j;
    private float field_31022_k;
    private float field_31020_l;
    private static List field_31018_m = new ArrayList();

    public TileEntityPiston() {
    }

    public TileEntityPiston(int i2, int j2, int k2, boolean flag, boolean flag1) {
        this.storedBlockID = i2;
        this.storedMetadata = j2;
        this.field_31025_c = k2;
        this.field_31024_i = flag;
        this.field_31023_j = flag1;
    }

    public int getStoredBlockID() {
        return this.storedBlockID;
    }

    @Override
    public int getBlockMetadata() {
        return this.storedMetadata;
    }

    public boolean func_31015_b() {
        return this.field_31024_i;
    }

    public int func_31009_d() {
        return this.field_31025_c;
    }

    public boolean func_31012_k() {
        return this.field_31023_j;
    }

    public float func_31008_a(float f2) {
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        return this.field_31020_l + (this.field_31022_k - this.field_31020_l) * f2;
    }

    public float func_31017_b(float f2) {
        if (this.field_31024_i) {
            return (this.func_31008_a(f2) - 1.0f) * (float)PistonModel.xOffset[this.field_31025_c];
        }
        return (1.0f - this.func_31008_a(f2)) * (float)PistonModel.xOffset[this.field_31025_c];
    }

    public float func_31014_c(float f2) {
        if (this.field_31024_i) {
            return (this.func_31008_a(f2) - 1.0f) * (float)PistonModel.yOffset[this.field_31025_c];
        }
        return (1.0f - this.func_31008_a(f2)) * (float)PistonModel.yOffset[this.field_31025_c];
    }

    public float func_31013_d(float f2) {
        if (this.field_31024_i) {
            return (this.func_31008_a(f2) - 1.0f) * (float)PistonModel.zOffset[this.field_31025_c];
        }
        return (1.0f - this.func_31008_a(f2)) * (float)PistonModel.zOffset[this.field_31025_c];
    }

    private void func_31010_a(float f2, float f1) {
        List<Entity> list;
        f2 = !this.field_31024_i ? (f2 -= 1.0f) : 1.0f - f2;
        AxisAlignedBB axisalignedbb = ((BlockPistonMoving)Block.pistonMoving).func_31035_a(this.worldObj, this.xCoord, this.yCoord, this.zCoord, this.storedBlockID, f2, this.field_31025_c);
        if (axisalignedbb != null && !(list = this.worldObj.getEntitiesWithinAABBExcludingEntity(null, axisalignedbb)).isEmpty()) {
            field_31018_m.addAll(list);
            Entity entity = null;
            Iterator iterator = field_31018_m.iterator();
            do {
                if ((entity = (Entity)iterator.next()) == null || entity.noClip) continue;
                entity.moveEntity(f1 * (float)PistonModel.xOffset[this.field_31025_c], f1 * (float)PistonModel.yOffset[this.field_31025_c], f1 * (float)PistonModel.zOffset[this.field_31025_c]);
            } while (iterator.hasNext());
            field_31018_m.clear();
        }
    }

    public void clearPistonTileEntity() {
        if (this.field_31020_l < 1.0f) {
            this.field_31022_k = 1.0f;
            this.field_31020_l = 1.0f;
            this.worldObj.removeBlockTileEntity(this.xCoord, this.yCoord, this.zCoord);
            this.invalidate();
            if (this.worldObj.getBlockId(this.xCoord, this.yCoord, this.zCoord) == Block.pistonMoving.blockID) {
                this.worldObj.setBlockAndMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, this.storedBlockID, this.storedMetadata);
            }
        }
    }

    @Override
    public void updateEntity() {
        this.field_31020_l = this.field_31022_k;
        if (this.field_31020_l >= 1.0f) {
            this.func_31010_a(1.0f, 0.25f);
            this.worldObj.removeBlockTileEntity(this.xCoord, this.yCoord, this.zCoord);
            this.invalidate();
            if (this.worldObj.getBlockId(this.xCoord, this.yCoord, this.zCoord) == Block.pistonMoving.blockID) {
                this.worldObj.setBlockAndMetadataWithNotify(this.xCoord, this.yCoord, this.zCoord, this.storedBlockID, this.storedMetadata);
            }
            return;
        }
        this.field_31022_k += 0.5f;
        if (this.field_31022_k >= 1.0f) {
            this.field_31022_k = 1.0f;
        }
        if (this.field_31024_i) {
            this.func_31010_a(this.field_31022_k, this.field_31022_k - this.field_31020_l + 0.0625f);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.storedBlockID = nbttagcompound.getInteger("blockId");
        this.storedMetadata = nbttagcompound.getInteger("blockData");
        this.field_31025_c = nbttagcompound.getInteger("facing");
        this.field_31020_l = this.field_31022_k = nbttagcompound.getFloat("progress");
        this.field_31024_i = nbttagcompound.getBoolean("extending");
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.setInteger("blockId", this.storedBlockID);
        nbttagcompound.setInteger("blockData", this.storedMetadata);
        nbttagcompound.setInteger("facing", this.field_31025_c);
        nbttagcompound.setFloat("progress", this.field_31020_l);
        nbttagcompound.setBoolean("extending", this.field_31024_i);
    }
}

