/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.Weather;
import net.minecraft.src.World;

public class WeatherRain
extends Weather {
    public WeatherRain(int id2) {
        super(id2);
    }

    @Override
    public float[] modifyFogColor(float r2, float g2, float b2, float intensity) {
        float f6 = 1.0f - intensity * 0.5f;
        float f8 = 1.0f - intensity * 0.4f;
        return new float[]{r2 *= f6, g2 *= f6, b2 *= f8};
    }

    @Override
    public void doEnvironmentUpdate(World world, Random rand, int x2, int z2) {
        if (world.getCurrentSeason() != null && !world.getCurrentSeason().letWeatherCleanUpSnow) {
            return;
        }
        if (rand.nextInt(2) == 0) {
            int y2 = world.getHeightValue(x2, z2);
            int blockId = world.getBlockId(x2, y2, z2);
            int blockIdBelow = world.getBlockId(x2, y2 - 1, z2);
            if (world.getWorldChunkManager().getBiomeGenAt(x2, z2).hasSurfaceSnow()) {
                int meta;
                if (blockId == Block.layerSnow.blockID && (meta = world.getBlockMetadata(x2, y2, z2)) != 0) {
                    world.setBlockMetadata(x2, y2, z2, meta - 1);
                    world.markBlockNeedsUpdate(x2, y2, z2);
                }
            } else if (blockId == Block.layerSnow.blockID) {
                int meta = world.getBlockMetadata(x2, y2, z2);
                if (meta != 0) {
                    world.setBlockMetadata(x2, y2, z2, meta - 1);
                    world.markBlockNeedsUpdate(x2, y2, z2);
                } else {
                    world.setBlockWithNotify(x2, y2, z2, 0);
                }
            } else if (blockIdBelow == Block.ice.blockID) {
                world.setBlockWithNotify(x2, y2 - 1, z2, Block.fluidWaterStill.blockID);
            }
        }
    }
}

