/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.BlockLayerSnow;
import net.minecraft.src.EnumLightType;
import net.minecraft.src.Weather;
import net.minecraft.src.World;

public class WeatherSnow
extends Weather {
    public WeatherSnow(int id2) {
        super(id2);
    }

    @Override
    public void doEnvironmentUpdate(World world, Random rand, int x2, int z2) {
        int probability = (int)(64.0f * (1.0f / world.weatherPower));
        if (world.currentSeason != null && world.currentSeason.hasDeeperSnow) {
            probability /= 2;
        }
        if (rand.nextInt(probability) == 0) {
            int y2 = world.getHeightValue(x2, z2);
            int blockId = world.getBlockId(x2, y2, z2);
            int blockIdBelow = world.getBlockId(x2, y2 - 1, z2);
            BiomeGenBase biome = world.getWorldChunkManager().getBiomeGenAt(x2, z2);
            for (int i2 = 0; i2 < biome.blockedWeathers.length; ++i2) {
                if (biome.blockedWeathers[i2] != this) continue;
                return;
            }
            if (world.weatherPower > 0.6f && y2 >= 0 && y2 < Minecraft.WORLD_HEIGHT_BLOCKS && world.getSavedLightValue(EnumLightType.Block, x2, y2, z2) < 10) {
                if (blockId == 0 && blockIdBelow != 0 && Block.layerSnow.canPlaceBlockAt(world, x2, y2, z2) && blockIdBelow != Block.ice.blockID) {
                    world.setBlockWithNotify(x2, y2, z2, Block.layerSnow.blockID);
                } else if (world.weatherPower > 0.5f && blockId == Block.layerSnow.blockID && world.getCurrentSeason() != null && world.getCurrentSeason().hasDeeperSnow) {
                    ((BlockLayerSnow)Block.layerSnow).accumulate(world, x2, y2, z2);
                } else if (blockIdBelow == Block.fluidWaterStill.blockID && world.getBlockMetadata(x2, y2 - 1, z2) == 0) {
                    world.setBlockWithNotify(x2, y2 - 1, z2, Block.ice.blockID);
                }
            }
        }
    }
}

