/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.EntityLightningBolt;
import net.minecraft.src.WeatherRain;
import net.minecraft.src.World;

public class WeatherStorm
extends WeatherRain {
    public WeatherStorm(int id2) {
        super(id2);
    }

    @Override
    public float[] modifyFogColor(float r2, float g2, float b2, float intensity) {
        float[] out = super.modifyFogColor(r2, g2, b2, intensity);
        float f9 = 1.0f - intensity * 0.5f;
        out[0] = out[0] * f9;
        out[1] = out[1] * f9;
        out[2] = out[2] * f9;
        return out;
    }

    @Override
    public void doEnvironmentUpdate(World world, Random rand, int x2, int z2) {
        int y2;
        super.doEnvironmentUpdate(world, rand, x2, z2);
        if (rand.nextInt((int)(100000.0f * (1.0f / world.weatherPower))) == 0 && world.canBlockBeRainedOn(x2, y2 = world.getHeightValue(x2, z2), z2)) {
            world.addWeatherEffect(new EntityLightningBolt(world, x2, y2, z2));
        }
    }
}

