/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class WeightedRandomBag<T> {
    private final List<Entry> entries = new ArrayList<Entry>();
    private double accumulatedWeight;
    private final Random rand = new Random();

    public void addEntry(T object, double weight) {
        this.accumulatedWeight += weight;
        Entry e2 = new Entry();
        e2.object = object;
        e2.accumulatedWeight = this.accumulatedWeight;
        this.entries.add(e2);
    }

    public T getRandom() {
        double r2 = this.rand.nextDouble() * this.accumulatedWeight;
        for (Entry entry : this.entries) {
            if (!(entry.accumulatedWeight >= r2)) continue;
            return entry.object;
        }
        return null;
    }

    private class Entry {
        double accumulatedWeight;
        T object;

        private Entry() {
        }
    }
}

