/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.BlockFluid;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkCache;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.ChunkProvider;
import net.minecraft.src.ChunkProviderFlat;
import net.minecraft.src.ChunkProviderGenerateOverworld;
import net.minecraft.src.ChunkProviderHell;
import net.minecraft.src.ChunkProviderLoadOrGenerate;
import net.minecraft.src.ChunkProviderServer;
import net.minecraft.src.Dimension;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityItem;
import net.minecraft.src.EntityLiving;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EnumLightType;
import net.minecraft.src.Explosion;
import net.minecraft.src.ExplosionCannonball;
import net.minecraft.src.IBlockAccess;
import net.minecraft.src.IChunkLoader;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.IProgressUpdate;
import net.minecraft.src.ISaveHandler;
import net.minecraft.src.IWorldAccess;
import net.minecraft.src.ItemStack;
import net.minecraft.src.MapDataBase;
import net.minecraft.src.MapStorage;
import net.minecraft.src.Material;
import net.minecraft.src.MathHelper;
import net.minecraft.src.MetadataChunkBlock;
import net.minecraft.src.MovingObjectPosition;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.NextTickListEntry;
import net.minecraft.src.Packet3Chat;
import net.minecraft.src.PathEntity;
import net.minecraft.src.Pathfinder;
import net.minecraft.src.Season;
import net.minecraft.src.SpawnerMobs;
import net.minecraft.src.TileEntity;
import net.minecraft.src.Vec3D;
import net.minecraft.src.Weather;
import net.minecraft.src.WorldChunkManager;
import net.minecraft.src.WorldInfo;
import net.minecraft.src.WorldType;
import net.minecraft.src.command.ChatColor;

public class World
implements IBlockAccess {
    public static boolean AUTOSAVE = true;
    private List<MetadataChunkBlock> lightingToUpdate = new ArrayList<MetadataChunkBlock>();
    public List<Entity> loadedEntityList = new ArrayList<Entity>();
    private List<Entity> unloadedEntityList = new ArrayList<Entity>();
    private TreeSet<NextTickListEntry> scheduledTickTreeSet = new TreeSet();
    private Set<NextTickListEntry> scheduledTickSet = new HashSet<NextTickListEntry>();
    public List<TileEntity> loadedTileEntityList = new ArrayList<TileEntity>();
    private List<TileEntity> field_30900_E = new ArrayList<TileEntity>();
    public List<EntityPlayer> players = new ArrayList<EntityPlayer>();
    public List<Entity> weatherEffects = new ArrayList<Entity>();
    private ArrayList<AxisAlignedBB> collidingBoundingBoxes = new ArrayList();
    protected List<IWorldAccess> worldAccesses = new ArrayList<IWorldAccess>();
    private Set<ChunkCoordIntPair> positionsToUpdate = new HashSet<ChunkCoordIntPair>();
    private List<Entity> entityBuffer = new ArrayList<Entity>();
    public boolean scheduledUpdatesAreImmediate = false;
    private long dimensionColor = 0xFFFFFFL;
    public int skylightSubtracted = 0;
    protected int updateLCG = new Random().nextInt();
    public int lightningFlicker = 0;
    public boolean editingBlocks = false;
    private long lockTimestamp = System.currentTimeMillis();
    protected int autosavePeriod = 40;
    public int difficultySetting;
    public Random rand = new Random();
    public boolean isNewWorld = false;
    public final Dimension dimension;
    protected IChunkProvider chunkProvider;
    protected final ISaveHandler saveHandler;
    protected WorldInfo worldInfo;
    public boolean findingSpawnPoint;
    private boolean enoughPlayersSleeping;
    public MapStorage mapStorage;
    private boolean field_31055_L;
    private int lightingUpdatesCounter = 0;
    private boolean spawnHostileMobs = true;
    private boolean spawnPeacefulMobs = true;
    public boolean mobGriefing = true;
    static int lightingUpdatesScheduled = 0;
    private int soundCounter = this.rand.nextInt(12000);
    public boolean isMultiplayerAndNotHost = false;
    public int sleepPercent = 100;
    protected Season lastSeason = null;
    protected Season currentSeason = null;
    protected Season nextSeason = null;
    protected float seasonProgress = 0.0f;
    protected int dayInSeason = 0;
    public Weather currentWeather = null;
    public Weather newWeather = null;
    public long weatherDuration = net.minecraft.shared.Minecraft.DAY_LENGTH_TICKS;
    public float weatherIntensity = 1.0f;
    public float weatherPower = 1.0f;

    public World(ISaveHandler saveHandler, String name, long seed, Dimension dimension) {
        this.saveHandler = saveHandler;
        this.mapStorage = new MapStorage(saveHandler);
        this.worldInfo = saveHandler.loadWorldInfo();
        boolean bl2 = this.isNewWorld = this.worldInfo == null;
        this.dimension = dimension != null ? dimension : (this.worldInfo != null ? Dimension.dimensionList[this.worldInfo.getDimension()] : Dimension.dimensionList[0]);
        if (this.worldInfo != null) {
            this.dimension.worldType = WorldType.worldTypes[this.worldInfo.getWorldType(this.dimension.dimId)];
        }
        boolean flag = false;
        if (this.worldInfo == null) {
            this.worldInfo = new WorldInfo(seed, name);
            flag = true;
        } else {
            this.worldInfo.setWorldName(name);
            this.currentWeather = Weather.weatherList[this.worldInfo.getWeatherId()];
            if (this.worldInfo.getNewWeatherId() != -1) {
                this.newWeather = Weather.weatherList[this.worldInfo.getNewWeatherId()];
            }
            this.weatherDuration = this.worldInfo.getWeatherDuration();
            this.weatherIntensity = this.worldInfo.getWeatherIntensity();
            this.weatherPower = this.worldInfo.getWeatherPower();
        }
        this.worldInfo.setWorldType(this.dimension.dimId, this.dimension.worldType.id);
        this.dimension.worldType.worldProvider.registerWorld(this);
        this.chunkProvider = this.getChunkProvider();
        if (flag) {
            this.getInitialSpawnLocation();
        }
        this.updateCurrentSeason();
        this.calculateInitialSkylight();
    }

    public World(World world, Dimension dimension) {
        this.lockTimestamp = world.lockTimestamp;
        this.saveHandler = world.saveHandler;
        this.worldInfo = new WorldInfo(world.worldInfo);
        this.mapStorage = new MapStorage(this.saveHandler);
        this.dimension = dimension;
        this.worldInfo.setWorldTypes(world.getWorldInfo().getWorldTypes());
        dimension.worldType.worldProvider.registerWorld(this);
        this.chunkProvider = this.getChunkProvider();
        this.updateCurrentSeason();
        this.calculateInitialSkylight();
    }

    public World(ISaveHandler isavehandler, String s2, Dimension dimension, long l2) {
        this.saveHandler = isavehandler;
        this.worldInfo = new WorldInfo(l2, s2);
        this.dimension = dimension;
        this.mapStorage = new MapStorage(isavehandler);
        this.worldInfo.setWorldType(this.dimension.dimId, this.dimension.worldType.id);
        dimension.worldType.worldProvider.registerWorld(this);
        this.chunkProvider = this.getChunkProvider();
        this.updateCurrentSeason();
        this.calculateInitialSkylight();
    }

    @Override
    public WorldChunkManager getWorldChunkManager() {
        return this.dimension.worldType.worldProvider.worldChunkMgr;
    }

    protected IChunkProvider getChunkProvider() {
        IChunkLoader ichunkloader = this.saveHandler.getChunkLoader(this.dimension);
        if (Minecraft.isChunkLoadingDynamic()) {
            return new ChunkProvider(this, ichunkloader, this.dimension.worldType.worldProvider.getChunkProvider());
        }
        return new ChunkProviderLoadOrGenerate(this, ichunkloader, this.dimension.worldType.worldProvider.getChunkProvider());
    }

    protected void getInitialSpawnLocation() {
        IChunkProvider cplog;
        this.findingSpawnPoint = true;
        int i2 = 0;
        int oceanHeight = 0;
        if (this.chunkProvider instanceof ChunkProviderServer) {
            ChunkProviderServer cps = (ChunkProviderServer)this.chunkProvider;
            oceanHeight = cps.chunkProvider instanceof ChunkProviderFlat ? 7 : (cps.chunkProvider instanceof ChunkProviderGenerateOverworld ? ((ChunkProviderGenerateOverworld)cps.chunkProvider).oceanHeight : (cps.chunkProvider instanceof ChunkProviderHell ? 160 : 64));
        } else if (Minecraft.isChunkLoadingDynamic()) {
            cplog = (ChunkProvider)this.chunkProvider;
            oceanHeight = cplog.chunkProvider instanceof ChunkProviderFlat ? 7 : (cplog.chunkProvider instanceof ChunkProviderGenerateOverworld ? ((ChunkProviderGenerateOverworld)cplog.chunkProvider).oceanHeight : (cplog.chunkProvider instanceof ChunkProviderHell ? 160 : 64));
        } else {
            cplog = (ChunkProviderLoadOrGenerate)this.chunkProvider;
            oceanHeight = ((ChunkProviderLoadOrGenerate)cplog).chunkProvider instanceof ChunkProviderFlat ? 7 : (((ChunkProviderLoadOrGenerate)cplog).chunkProvider instanceof ChunkProviderGenerateOverworld ? ((ChunkProviderGenerateOverworld)((ChunkProviderLoadOrGenerate)cplog).chunkProvider).oceanHeight : (((ChunkProviderLoadOrGenerate)cplog).chunkProvider instanceof ChunkProviderHell ? 160 : 64));
        }
        this.worldInfo.setSpawnY(oceanHeight);
        int j2 = 0;
        while (!this.dimension.worldType.worldProvider.canCoordinateBeSpawn(i2, j2)) {
            i2 += this.rand.nextInt(64) - this.rand.nextInt(64);
            j2 += this.rand.nextInt(64) - this.rand.nextInt(64);
        }
        this.worldInfo.setSpawn(i2, oceanHeight, j2);
        this.findingSpawnPoint = false;
    }

    public void setSpawnLocation() {
        if (this.worldInfo.getSpawnY() <= 0) {
            if (this.chunkProvider instanceof ChunkProviderFlat) {
                this.worldInfo.setSpawnY(7);
            } else if (this.chunkProvider instanceof ChunkProviderGenerateOverworld) {
                this.worldInfo.setSpawnY(((ChunkProviderGenerateOverworld)this.chunkProvider).oceanHeight);
            } else {
                this.worldInfo.setSpawnY(64);
            }
        }
        int i2 = this.worldInfo.getSpawnX();
        int j2 = this.worldInfo.getSpawnZ();
        while (this.getFirstUncoveredBlock(i2, j2) == 0) {
            i2 += this.rand.nextInt(8) - this.rand.nextInt(8);
            j2 += this.rand.nextInt(8) - this.rand.nextInt(8);
        }
        this.worldInfo.setSpawnX(i2);
        this.worldInfo.setSpawnZ(j2);
    }

    public int getFirstUncoveredBlock(int i2, int j2) {
        int k2 = this.worldInfo.getSpawnY() - 1;
        while (!this.isAirBlock(i2, k2 + 1, j2)) {
            ++k2;
        }
        return this.getBlockId(i2, k2, j2);
    }

    public void emptyMethod1() {
    }

    public void spawnPlayerWithLoadedChunks(EntityPlayer entityplayer) {
        try {
            NBTTagCompound nbttagcompound = this.worldInfo.getPlayerNBTTagCompound();
            if (nbttagcompound != null) {
                entityplayer.readFromNBT(nbttagcompound);
                this.worldInfo.setPlayerNBTTagCompound(null);
            }
            if (this.chunkProvider instanceof ChunkProviderLoadOrGenerate) {
                ChunkProviderLoadOrGenerate chunkproviderloadorgenerate = (ChunkProviderLoadOrGenerate)this.chunkProvider;
                int i2 = MathHelper.floor_float((int)entityplayer.posX) >> 4;
                int j2 = MathHelper.floor_float((int)entityplayer.posZ) >> 4;
                chunkproviderloadorgenerate.setCurrentChunkOver(i2, j2);
            }
            this.entityJoinedWorld(entityplayer);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void saveWorld(boolean flag, IProgressUpdate iprogressupdate) {
        if (!this.chunkProvider.canSave()) {
            return;
        }
        if (iprogressupdate != null) {
            iprogressupdate.func_594_b("Saving level");
        }
        this.saveLevel();
        if (iprogressupdate != null) {
            iprogressupdate.displayLoadingString("Saving chunks");
        }
        this.chunkProvider.saveChunks(flag, iprogressupdate);
    }

    private void saveLevel() {
        this.checkSessionLock();
        this.saveHandler.saveWorldInfoAndPlayer(this.worldInfo, this.players);
        this.mapStorage.saveAllData();
    }

    public boolean func_650_a(int i2) {
        if (!this.chunkProvider.canSave()) {
            return true;
        }
        if (i2 == 0) {
            this.saveLevel();
        }
        return this.chunkProvider.saveChunks(false, null);
    }

    public Season getCurrentSeason() {
        return this.currentSeason;
    }

    public Season getLastSeason() {
        return this.lastSeason;
    }

    public Season getNextSeason() {
        return this.nextSeason;
    }

    public float getSeasonProgress() {
        return this.seasonProgress;
    }

    public Weather getCurrentWeather() {
        return this.currentWeather;
    }

    protected void updateCurrentSeason() {
        int seasonCycleLength = 0;
        if (this.dimension.worldType.seasons == null || this.dimension.worldType.seasons.length == 0) {
            return;
        }
        for (int i2 = 0; i2 < this.dimension.worldType.seasons.length; ++i2) {
            seasonCycleLength += this.dimension.worldType.seasons[i2].lengthTicks;
        }
        int currTimeInCycle = (int)(this.worldInfo.getWorldTime() % (long)seasonCycleLength);
        int acc = 0;
        for (int i3 = 0; i3 < this.dimension.worldType.seasons.length; ++i3) {
            if (currTimeInCycle > (acc += this.dimension.worldType.seasons[i3].lengthTicks)) continue;
            this.seasonProgress = (float)(currTimeInCycle - (acc - this.dimension.worldType.seasons[i3].lengthTicks)) / (float)this.dimension.worldType.seasons[i3].lengthTicks;
            this.lastSeason = this.dimension.worldType.seasons[Math.floorMod(i3 - 1, this.dimension.worldType.seasons.length)];
            this.currentSeason = this.dimension.worldType.seasons[i3];
            this.nextSeason = this.dimension.worldType.seasons[Math.floorMod(i3 + 1, this.dimension.worldType.seasons.length)];
            this.dayInSeason = (this.currentSeason.lengthTicks - (acc - currTimeInCycle)) / net.minecraft.shared.Minecraft.DAY_LENGTH_TICKS;
            break;
        }
    }

    @Override
    public int getBlockId(int x2, int y2, int z2) {
        if (x2 < -32000000 || z2 < -32000000 || x2 >= 32000000 || z2 > 32000000) {
            return 0;
        }
        if (y2 < 0) {
            return 0;
        }
        if (y2 >= net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS) {
            return 0;
        }
        return this.getChunkFromChunkCoords(x2 >> 4, z2 >> 4).getBlockID(x2 & 0xF, y2, z2 & 0xF);
    }

    public double getBlockTemperature(int x2, int z2) {
        if (x2 < -32000000 || z2 < -32000000 || x2 >= 32000000 || z2 > 32000000) {
            return 0.0;
        }
        return this.getChunkFromChunkCoords(x2 >> 4, z2 >> 4).getBlockTemperature(x2 & 0xF, z2 & 0xF);
    }

    public double getBlockHumidity(int x2, int z2) {
        if (x2 < -32000000 || z2 < -32000000 || x2 >= 32000000 || z2 > 32000000) {
            return 0.0;
        }
        return this.getChunkFromChunkCoords(x2 >> 4, z2 >> 4).getBlockHumidity(x2 & 0xF, z2 & 0xF);
    }

    public BiomeGenBase getBlockBiome(int x2, int z2) {
        if (x2 < -32000000 || z2 < -32000000 || x2 >= 32000000 || z2 > 32000000) {
            return BiomeGenBase.plains;
        }
        return this.getChunkFromChunkCoords(x2 >> 4, z2 >> 4).getBlockBiome(x2 & 0xF, z2 & 0xF);
    }

    public boolean getBlockLitInteriorSurface(int i2, int j2, int k2) {
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return true;
        }
        if (j2 < 0) {
            return true;
        }
        if (j2 >= net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS) {
            return true;
        }
        return Block.getIsLitInteriorSurface(this, i2, j2, k2);
    }

    public boolean isAirBlock(int x2, int y2, int z2) {
        return this.getBlockId(x2, y2, z2) == 0;
    }

    public boolean blockExists(int x2, int y2, int z2) {
        if (y2 < 0 || y2 >= net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS) {
            return false;
        }
        return this.chunkExists(x2 >> 4, z2 >> 4);
    }

    public boolean doChunksNearChunkExist(int x2, int y2, int z2, int range) {
        return this.checkChunksExist(x2 - range, y2 - range, z2 - range, x2 + range, y2 + range, z2 + range);
    }

    public boolean checkChunksExist(int x1, int y1, int z1, int x2, int y2, int z2) {
        if (y2 < 0 || y1 >= net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS) {
            return false;
        }
        x1 >>= 4;
        y1 >>= 4;
        z1 >>= 4;
        x2 >>= 4;
        y2 >>= 4;
        z2 >>= 4;
        for (int k1 = x1; k1 <= x2; ++k1) {
            for (int l1 = z1; l1 <= z2; ++l1) {
                if (this.chunkExists(k1, l1)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean chunkExists(int x2, int z2) {
        return this.chunkProvider.chunkExists(x2, z2);
    }

    public Chunk getChunkFromBlockCoords(int x2, int z2) {
        return this.getChunkFromChunkCoords(x2 >> 4, z2 >> 4);
    }

    public Chunk getChunkFromChunkCoords(int x2, int z2) {
        return this.chunkProvider.provideChunk(x2, z2);
    }

    public boolean setBlockAndMetadata(int x2, int y2, int z2, int id2, int meta) {
        if (x2 < -32000000 || z2 < -32000000 || x2 >= 32000000 || z2 > 32000000) {
            return false;
        }
        if (y2 < 0) {
            return false;
        }
        if (y2 >= net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(x2 >> 4, z2 >> 4);
        return chunk.setBlockIDWithMetadata(x2 & 0xF, y2, z2 & 0xF, id2, meta);
    }

    public boolean setBlockRaw(int x2, int y2, int z2, int id2) {
        if (x2 < -32000000 || z2 < -32000000 || x2 >= 32000000 || z2 > 32000000) {
            return false;
        }
        if (y2 < 0) {
            return false;
        }
        if (y2 >= net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(x2 >> 4, z2 >> 4);
        return chunk.setBlockIDRaw(x2 & 0xF, y2, z2 & 0xF, id2);
    }

    public boolean setBlock(int x2, int y2, int z2, int id2) {
        if (x2 < -32000000 || z2 < -32000000 || x2 >= 32000000 || z2 > 32000000) {
            return false;
        }
        if (y2 < 0) {
            return false;
        }
        if (y2 >= net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(x2 >> 4, z2 >> 4);
        return chunk.setBlockID(x2 & 0xF, y2, z2 & 0xF, id2);
    }

    public boolean setBlockTemperature(int x2, int z2, double temperature) {
        if (x2 < -32000000 || z2 < -32000000 || x2 >= 32000000 || z2 > 32000000) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(x2 >> 4, z2 >> 4);
        return chunk.setBlockTemperature(x2 & 0xF, z2 & 0xF, temperature);
    }

    public boolean setBlockHumidity(int x2, int z2, double humidity) {
        if (x2 < -32000000 || z2 < -32000000 || x2 >= 32000000 || z2 > 32000000) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(x2 >> 4, z2 >> 4);
        return chunk.setBlockHumidity(x2 & 0xF, z2 & 0xF, humidity);
    }

    public boolean setBlockBiome(int x2, int z2, BiomeGenBase biome) {
        if (x2 < -32000000 || z2 < -32000000 || x2 >= 32000000 || z2 > 32000000) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(x2 >> 4, z2 >> 4);
        return chunk.setBlockBiome(x2 & 0xF, z2 & 0xF, biome);
    }

    @Override
    public Material getBlockMaterial(int x2, int y2, int z2) {
        int l2 = this.getBlockId(x2, y2, z2);
        if (l2 == 0) {
            return Material.air;
        }
        return Block.blocksList[l2].blockMaterial;
    }

    @Override
    public int getBlockMetadata(int x2, int y2, int z2) {
        if (x2 < -32000000 || z2 < -32000000 || x2 >= 32000000 || z2 > 32000000) {
            return 0;
        }
        if (y2 < 0) {
            return 0;
        }
        if (y2 >= net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(x2 >> 4, z2 >> 4);
        return chunk.getBlockMetadata(x2 &= 0xF, y2, z2 &= 0xF);
    }

    public void setBlockMetadataWithNotify(int x2, int y2, int z2, int meta) {
        if (this.setBlockMetadata(x2, y2, z2, meta)) {
            int i1 = this.getBlockId(x2, y2, z2);
            if (Block.neighborNotifyOnMetadataChangeDisabled[i1 & 0x3FFF]) {
                this.notifyBlockChange(x2, y2, z2, i1);
            } else {
                this.notifyBlocksOfNeighborChange(x2, y2, z2, i1);
            }
        }
    }

    public boolean setBlockMetadata(int x2, int y2, int z2, int meta) {
        if (x2 < -32000000 || z2 < -32000000 || x2 >= 32000000 || z2 > 32000000) {
            return false;
        }
        if (y2 < 0) {
            return false;
        }
        if (y2 >= net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(x2 >> 4, z2 >> 4);
        chunk.setBlockMetadata(x2 &= 0xF, y2, z2 &= 0xF, meta);
        return true;
    }

    public boolean setBlockRawWithNotify(int x2, int y2, int z2, int id2) {
        if (this.setBlockRaw(x2, y2, z2, id2)) {
            this.notifyBlockChange(x2, y2, z2, id2);
            return true;
        }
        return false;
    }

    public boolean setBlockWithNotify(int x2, int y2, int z2, int id2) {
        if (this.setBlock(x2, y2, z2, id2)) {
            this.notifyBlockChange(x2, y2, z2, id2);
            return true;
        }
        return false;
    }

    public boolean setBlockAndMetadataWithNotify(int x2, int y2, int z2, int id2, int meta) {
        if (this.setBlockAndMetadata(x2, y2, z2, id2, meta)) {
            this.notifyBlockChange(x2, y2, z2, id2);
            return true;
        }
        return false;
    }

    public void markBlockNeedsUpdate(int x2, int y2, int z2) {
        for (int l2 = 0; l2 < this.worldAccesses.size(); ++l2) {
            this.worldAccesses.get(l2).markBlockAndNeighborsNeedsUpdate(x2, y2, z2);
        }
    }

    protected void notifyBlockChange(int x2, int y2, int z2, int id2) {
        this.markBlockNeedsUpdate(x2, y2, z2);
        this.notifyBlocksOfNeighborChange(x2, y2, z2, id2);
    }

    public void markBlocksDirtyVertical(int x2, int z2, int y1, int y2) {
        if (y1 > y2) {
            int t2 = y2;
            y2 = y1;
            y1 = t2;
        }
        this.markBlocksDirty(x2, y1, z2, x2, y2, z2);
    }

    public void markBlockAsNeedsUpdate(int x2, int y2, int z2) {
        for (int l2 = 0; l2 < this.worldAccesses.size(); ++l2) {
            this.worldAccesses.get(l2).markBlockRangeNeedsUpdate(x2, y2, z2, x2, y2, z2);
        }
    }

    public void markBlocksDirty(int i2, int j2, int k2, int l2, int i1, int j1) {
        for (int k1 = 0; k1 < this.worldAccesses.size(); ++k1) {
            this.worldAccesses.get(k1).markBlockRangeNeedsUpdate(i2, j2, k2, l2, i1, j1);
        }
    }

    public void notifyBlocksOfNeighborChange(int i2, int j2, int k2, int l2) {
        this.notifyBlockOfNeighborChange(i2 - 1, j2, k2, l2);
        this.notifyBlockOfNeighborChange(i2 + 1, j2, k2, l2);
        this.notifyBlockOfNeighborChange(i2, j2 - 1, k2, l2);
        this.notifyBlockOfNeighborChange(i2, j2 + 1, k2, l2);
        this.notifyBlockOfNeighborChange(i2, j2, k2 - 1, l2);
        this.notifyBlockOfNeighborChange(i2, j2, k2 + 1, l2);
    }

    private void notifyBlockOfNeighborChange(int i2, int j2, int k2, int l2) {
        if (this.editingBlocks || this.isMultiplayerAndNotHost) {
            return;
        }
        Block block = Block.blocksList[this.getBlockId(i2, j2, k2)];
        if (block != null) {
            block.onNeighborBlockChange(this, i2, j2, k2, l2);
        }
    }

    public boolean canBlockSeeTheSky(int i2, int j2, int k2) {
        return this.getChunkFromChunkCoords(i2 >> 4, k2 >> 4).canBlockSeeTheSky(i2 & 0xF, j2, k2 & 0xF);
    }

    public int getFullBlockLightValue(int i2, int j2, int k2) {
        if (j2 < 0) {
            return 0;
        }
        if (j2 >= net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS) {
            j2 = net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS - 1;
        }
        return this.getChunkFromChunkCoords(i2 >> 4, k2 >> 4).getBlockLightValue(i2 & 0xF, j2, k2 & 0xF, 0);
    }

    public int getBlockLightValue(int i2, int j2, int k2) {
        return this.getBlockLightValue_do(i2, j2, k2, true);
    }

    public int getBlockLightValue_do(int i2, int j2, int k2, boolean flag) {
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return 15;
        }
        if (flag && this.getBlockLitInteriorSurface(i2, j2, k2)) {
            int i1 = this.getBlockLightValue_do(i2, j2 + 1, k2, false);
            int j1 = this.getBlockLightValue_do(i2 + 1, j2, k2, false);
            int k1 = this.getBlockLightValue_do(i2 - 1, j2, k2, false);
            int l1 = this.getBlockLightValue_do(i2, j2, k2 + 1, false);
            int i22 = this.getBlockLightValue_do(i2, j2, k2 - 1, false);
            if (j1 > i1) {
                i1 = j1;
            }
            if (k1 > i1) {
                i1 = k1;
            }
            if (l1 > i1) {
                i1 = l1;
            }
            if (i22 > i1) {
                i1 = i22;
            }
            return i1;
        }
        if (j2 < 0) {
            return 0;
        }
        if (j2 >= net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS) {
            j2 = net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS - 1;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i2 >> 4, k2 >> 4);
        return chunk.getBlockLightValue(i2 &= 0xF, j2, k2 &= 0xF, this.skylightSubtracted);
    }

    public boolean canExistingBlockSeeTheSky(int i2, int j2, int k2) {
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return false;
        }
        if (j2 < 0) {
            return false;
        }
        if (j2 >= net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS) {
            return true;
        }
        if (!this.chunkExists(i2 >> 4, k2 >> 4)) {
            return false;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i2 >> 4, k2 >> 4);
        return chunk.canBlockSeeTheSky(i2 &= 0xF, j2, k2 &= 0xF);
    }

    public int getHeightValue(int i2, int j2) {
        if (i2 < -32000000 || j2 < -32000000 || i2 >= 32000000 || j2 > 32000000) {
            return 0;
        }
        if (!this.chunkExists(i2 >> 4, j2 >> 4)) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i2 >> 4, j2 >> 4);
        return chunk.getHeightValue(i2 & 0xF, j2 & 0xF);
    }

    public void neighborLightPropagationChanged(EnumLightType enumskyblock, int i2, int j2, int k2, int l2) {
        int i1;
        if (this.dimension.worldType.worldProvider.hasNoSky && enumskyblock == EnumLightType.Sky) {
            return;
        }
        if (!this.blockExists(i2, j2, k2)) {
            return;
        }
        if (enumskyblock == EnumLightType.Sky) {
            if (this.canExistingBlockSeeTheSky(i2, j2, k2)) {
                l2 = 15;
            }
        } else if (enumskyblock == EnumLightType.Block && Block.lightValue[i1 = this.getBlockId(i2, j2, k2)] > l2) {
            l2 = Block.lightValue[i1];
        }
        if (this.getSavedLightValue(enumskyblock, i2, j2, k2) != l2) {
            this.scheduleLightingUpdate(enumskyblock, i2, j2, k2, i2, j2, k2);
        }
    }

    public int getSavedLightValue(EnumLightType enumskyblock, int i2, int j2, int k2) {
        if (j2 < 0) {
            j2 = 0;
        }
        if (j2 >= net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS) {
            j2 = net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS - 1;
        }
        if (j2 < 0 || j2 >= net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS || i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return enumskyblock.field_1722_c;
        }
        int l2 = i2 >> 4;
        int i1 = k2 >> 4;
        if (!this.chunkExists(l2, i1)) {
            return 0;
        }
        Chunk chunk = this.getChunkFromChunkCoords(l2, i1);
        return chunk.getSavedLightValue(enumskyblock, i2 & 0xF, j2, k2 & 0xF);
    }

    public void setLightValue(EnumLightType enumskyblock, int i2, int j2, int k2, int l2) {
        if (i2 < -32000000 || k2 < -32000000 || i2 >= 32000000 || k2 > 32000000) {
            return;
        }
        if (j2 < 0) {
            return;
        }
        if (j2 >= net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS) {
            return;
        }
        if (!this.chunkExists(i2 >> 4, k2 >> 4)) {
            return;
        }
        Chunk chunk = this.getChunkFromChunkCoords(i2 >> 4, k2 >> 4);
        chunk.setLightValue(enumskyblock, i2 & 0xF, j2, k2 & 0xF, l2);
        for (int i1 = 0; i1 < this.worldAccesses.size(); ++i1) {
            this.worldAccesses.get(i1).markBlockAndNeighborsNeedsUpdate(i2, j2, k2);
        }
    }

    @Override
    public float getBrightness(int i2, int j2, int k2, int l2) {
        int i1 = this.getBlockLightValue(i2, j2, k2);
        if (i1 < l2) {
            i1 = l2;
        }
        return this.dimension.worldType.worldProvider.lightBrightnessTable[i1];
    }

    @Override
    public float getLightBrightness(int i2, int j2, int k2) {
        return this.dimension.worldType.worldProvider.lightBrightnessTable[this.getBlockLightValue(i2, j2, k2)];
    }

    public boolean isDaytime() {
        return this.skylightSubtracted < 4;
    }

    public MovingObjectPosition rayTraceBlocks(Vec3D vec3d, Vec3D vec3d1) {
        return this.func_28105_a(vec3d, vec3d1, false, false);
    }

    public MovingObjectPosition rayTraceBlocks_do(Vec3D vec3d, Vec3D vec3d1, boolean flag) {
        return this.func_28105_a(vec3d, vec3d1, flag, false);
    }

    public MovingObjectPosition func_28105_a(Vec3D vec3d, Vec3D vec3d1, boolean flag, boolean flag1) {
        MovingObjectPosition movingobjectposition;
        if (Double.isNaN(vec3d.xCoord) || Double.isNaN(vec3d.yCoord) || Double.isNaN(vec3d.zCoord)) {
            return null;
        }
        if (Double.isNaN(vec3d1.xCoord) || Double.isNaN(vec3d1.yCoord) || Double.isNaN(vec3d1.zCoord)) {
            return null;
        }
        int i2 = MathHelper.floor_double(vec3d1.xCoord);
        int j2 = MathHelper.floor_double(vec3d1.yCoord);
        int k2 = MathHelper.floor_double(vec3d1.zCoord);
        int l2 = MathHelper.floor_double(vec3d.xCoord);
        int i1 = MathHelper.floor_double(vec3d.yCoord);
        int j1 = MathHelper.floor_double(vec3d.zCoord);
        int k1 = this.getBlockId(l2, i1, j1);
        int i22 = this.getBlockMetadata(l2, i1, j1);
        Block block = Block.blocksList[k1];
        if ((!flag1 || block == null || block.getCollisionBoundingBoxFromPool(this, l2, i1, j1) != null) && k1 > 0 && block.canCollideCheck(i22, flag) && (movingobjectposition = block.collisionRayTrace(this, l2, i1, j1, vec3d, vec3d1)) != null) {
            return movingobjectposition;
        }
        int l1 = 200;
        while (l1-- >= 0) {
            MovingObjectPosition movingobjectposition1;
            if (Double.isNaN(vec3d.xCoord) || Double.isNaN(vec3d.yCoord) || Double.isNaN(vec3d.zCoord)) {
                return null;
            }
            if (l2 == i2 && i1 == j2 && j1 == k2) {
                return null;
            }
            boolean flag2 = true;
            boolean flag3 = true;
            boolean flag4 = true;
            double d2 = 999.0;
            double d1 = 999.0;
            double d22 = 999.0;
            if (i2 > l2) {
                d2 = (double)l2 + 1.0;
            } else if (i2 < l2) {
                d2 = (double)l2 + 0.0;
            } else {
                flag2 = false;
            }
            if (j2 > i1) {
                d1 = (double)i1 + 1.0;
            } else if (j2 < i1) {
                d1 = (double)i1 + 0.0;
            } else {
                flag3 = false;
            }
            if (k2 > j1) {
                d22 = (double)j1 + 1.0;
            } else if (k2 < j1) {
                d22 = (double)j1 + 0.0;
            } else {
                flag4 = false;
            }
            double d3 = 999.0;
            double d4 = 999.0;
            double d5 = 999.0;
            double d6 = vec3d1.xCoord - vec3d.xCoord;
            double d7 = vec3d1.yCoord - vec3d.yCoord;
            double d8 = vec3d1.zCoord - vec3d.zCoord;
            if (flag2) {
                d3 = (d2 - vec3d.xCoord) / d6;
            }
            if (flag3) {
                d4 = (d1 - vec3d.yCoord) / d7;
            }
            if (flag4) {
                d5 = (d22 - vec3d.zCoord) / d8;
            }
            int byte0 = 0;
            if (d3 < d4 && d3 < d5) {
                byte0 = i2 > l2 ? 4 : 5;
                vec3d.xCoord = d2;
                vec3d.yCoord += d7 * d3;
                vec3d.zCoord += d8 * d3;
            } else if (d4 < d5) {
                byte0 = j2 > i1 ? 0 : 1;
                vec3d.xCoord += d6 * d4;
                vec3d.yCoord = d1;
                vec3d.zCoord += d8 * d4;
            } else {
                byte0 = k2 > j1 ? 2 : 3;
                vec3d.xCoord += d6 * d5;
                vec3d.yCoord += d7 * d5;
                vec3d.zCoord = d22;
            }
            Vec3D vec3d2 = Vec3D.createVector(vec3d.xCoord, vec3d.yCoord, vec3d.zCoord);
            vec3d2.xCoord = MathHelper.floor_double(vec3d.xCoord);
            l2 = (int)vec3d2.xCoord;
            if (byte0 == 5) {
                --l2;
                vec3d2.xCoord += 1.0;
            }
            vec3d2.yCoord = MathHelper.floor_double(vec3d.yCoord);
            i1 = (int)vec3d2.yCoord;
            if (byte0 == 1) {
                --i1;
                vec3d2.yCoord += 1.0;
            }
            vec3d2.zCoord = MathHelper.floor_double(vec3d.zCoord);
            j1 = (int)vec3d2.zCoord;
            if (byte0 == 3) {
                --j1;
                vec3d2.zCoord += 1.0;
            }
            int j22 = this.getBlockId(l2, i1, j1);
            int k22 = this.getBlockMetadata(l2, i1, j1);
            Block block1 = Block.blocksList[j22];
            if (flag1 && block1 != null && block1.getCollisionBoundingBoxFromPool(this, l2, i1, j1) == null || j22 <= 0 || !block1.canCollideCheck(k22, flag) || (movingobjectposition1 = block1.collisionRayTrace(this, l2, i1, j1, vec3d, vec3d1)) == null) continue;
            return movingobjectposition1;
        }
        return null;
    }

    public void playSoundAtEntity(Entity entity, String s2, float f2, float f1) {
        for (int i2 = 0; i2 < this.worldAccesses.size(); ++i2) {
            this.worldAccesses.get(i2).playSound(s2, entity.posX, entity.posY - (double)entity.yOffset, entity.posZ, f2, f1);
        }
    }

    public void playSoundEffect(double d2, double d1, double d22, String s2, float f2, float f1) {
        for (int i2 = 0; i2 < this.worldAccesses.size(); ++i2) {
            this.worldAccesses.get(i2).playSound(s2, d2, d1, d22, f2, f1);
        }
    }

    public void playRecord(String s2, int i2, int j2, int k2) {
        for (int l2 = 0; l2 < this.worldAccesses.size(); ++l2) {
            this.worldAccesses.get(l2).playRecord(s2, i2, j2, k2);
        }
    }

    public void spawnParticle(String s2, double d2, double d1, double d22, double d3, double d4, double d5) {
        for (int i2 = 0; i2 < this.worldAccesses.size(); ++i2) {
            this.worldAccesses.get(i2).spawnParticle(s2, d2, d1, d22, d3, d4, d5);
        }
    }

    public boolean addWeatherEffect(Entity entity) {
        this.weatherEffects.add(entity);
        return true;
    }

    public boolean entityJoinedWorld(Entity entity) {
        int i2 = MathHelper.floor_double(entity.posX / 16.0);
        int j2 = MathHelper.floor_double(entity.posZ / 16.0);
        boolean flag = false;
        if (entity instanceof EntityPlayer) {
            flag = true;
        }
        if (flag || this.chunkExists(i2, j2)) {
            if (entity instanceof EntityPlayer) {
                EntityPlayer entityplayer = (EntityPlayer)entity;
                this.players.add(entityplayer);
                this.updateEnoughPlayersSleepingFlag(null);
            }
            this.getChunkFromChunkCoords(i2, j2).addEntity(entity);
            this.loadedEntityList.add(entity);
            this.obtainEntitySkin(entity);
            return true;
        }
        return false;
    }

    protected void obtainEntitySkin(Entity entity) {
        for (int i2 = 0; i2 < this.worldAccesses.size(); ++i2) {
            this.worldAccesses.get(i2).trackEntity(entity);
        }
    }

    protected void releaseEntitySkin(Entity entity) {
        for (int i2 = 0; i2 < this.worldAccesses.size(); ++i2) {
            this.worldAccesses.get(i2).untrackEntity(entity);
        }
    }

    public void setEntityDead(Entity entity) {
        if (entity.riddenByEntity != null) {
            entity.riddenByEntity.mountEntity(null);
        }
        if (entity.ridingEntity != null) {
            entity.mountEntity(null);
        }
        entity.setEntityDead();
        if (entity instanceof EntityPlayer) {
            this.players.remove((EntityPlayer)entity);
            this.updateEnoughPlayersSleepingFlag(null);
        }
    }

    public void removePlayer(Entity entity) {
        entity.setEntityDead();
        if (entity instanceof EntityPlayer) {
            this.players.remove((EntityPlayer)entity);
            this.updateEnoughPlayersSleepingFlag(null);
        }
        int i2 = entity.chunkCoordX;
        int j2 = entity.chunkCoordZ;
        if (entity.addedToChunk && this.chunkExists(i2, j2)) {
            this.getChunkFromChunkCoords(i2, j2).removeEntity(entity);
        }
        this.loadedEntityList.remove(entity);
        this.releaseEntitySkin(entity);
    }

    public void addWorldAccess(IWorldAccess iworldaccess) {
        this.worldAccesses.add(iworldaccess);
    }

    public void removeWorldAccess(IWorldAccess iworldaccess) {
        this.worldAccesses.remove(iworldaccess);
    }

    public List<AxisAlignedBB> getCollidingBoundingBoxes(Entity entity, AxisAlignedBB axisalignedbb) {
        this.collidingBoundingBoxes.clear();
        int i2 = MathHelper.floor_double(axisalignedbb.minX);
        int j2 = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k2 = MathHelper.floor_double(axisalignedbb.minY);
        int l2 = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        for (int k1 = i2; k1 < j2; ++k1) {
            for (int l1 = i1; l1 < j1; ++l1) {
                if (!this.blockExists(k1, 64, l1)) continue;
                for (int i22 = k2 - 1; i22 < l2; ++i22) {
                    Block block = Block.blocksList[this.getBlockId(k1, i22, l1)];
                    if (block == null || entity instanceof EntityItem && (block.blockID == Block.mesh.blockID || block.blockID == Block.spikes.blockID || block.blockID == Block.mobspawner.blockID)) continue;
                    block.getCollidingBoundingBoxes(this, k1, i22, l1, axisalignedbb, this.collidingBoundingBoxes);
                }
            }
        }
        double d2 = 0.25;
        List<Entity> list = this.getEntitiesWithinAABBExcludingEntity(entity, axisalignedbb.expand(d2, d2, d2));
        for (int j22 = 0; j22 < list.size(); ++j22) {
            AxisAlignedBB axisalignedbb1 = list.get(j22).getBoundingBox();
            if (axisalignedbb1 != null && axisalignedbb1.intersectsWith(axisalignedbb)) {
                this.collidingBoundingBoxes.add(axisalignedbb1);
            }
            if ((axisalignedbb1 = entity.getCollisionBox(list.get(j22))) == null || !axisalignedbb1.intersectsWith(axisalignedbb)) continue;
            this.collidingBoundingBoxes.add(axisalignedbb1);
        }
        return this.collidingBoundingBoxes;
    }

    public List<AxisAlignedBB> getCollidingSolidBlockBoundingBoxes(Entity entity, AxisAlignedBB axisalignedbb) {
        this.collidingBoundingBoxes.clear();
        int i2 = MathHelper.floor_double(axisalignedbb.minX);
        int j2 = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k2 = MathHelper.floor_double(axisalignedbb.minY);
        int l2 = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        for (int k1 = i2; k1 < j2; ++k1) {
            for (int l1 = i1; l1 < j1; ++l1) {
                if (!this.blockExists(k1, 64, l1)) continue;
                for (int i22 = k2 - 1; i22 < l2; ++i22) {
                    Block block = Block.blocksList[this.getBlockId(k1, i22, l1)];
                    if (block == null || !block.isOpaqueCube() || entity instanceof EntityItem && (block.blockID == Block.mesh.blockID || block.blockID == Block.spikes.blockID || block.blockID == Block.mobspawner.blockID)) continue;
                    block.getCollidingBoundingBoxes(this, k1, i22, l1, axisalignedbb, this.collidingBoundingBoxes);
                }
            }
        }
        double d2 = 0.25;
        List<Entity> list = this.getEntitiesWithinAABBExcludingEntity(entity, axisalignedbb.expand(d2, d2, d2));
        for (int j22 = 0; j22 < list.size(); ++j22) {
            AxisAlignedBB axisalignedbb1 = list.get(j22).getBoundingBox();
            if (axisalignedbb1 != null && axisalignedbb1.intersectsWith(axisalignedbb)) {
                this.collidingBoundingBoxes.add(axisalignedbb1);
            }
            if ((axisalignedbb1 = entity.getCollisionBox(list.get(j22))) == null || !axisalignedbb1.intersectsWith(axisalignedbb)) continue;
            this.collidingBoundingBoxes.add(axisalignedbb1);
        }
        return this.collidingBoundingBoxes;
    }

    public int calculateSkylightSubtracted(float f2) {
        float f1 = this.getCelestialAngle(f2);
        float f22 = 1.0f - (MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f);
        if (f22 < 0.0f) {
            f22 = 0.0f;
        }
        if (f22 > 1.0f) {
            f22 = 1.0f;
        }
        float weatherOffset = 0.0f;
        if (this.currentWeather != null) {
            weatherOffset = (float)this.currentWeather.subtractLightLevel * this.weatherIntensity * this.weatherPower;
        }
        return (int)(f22 * (11.0f - weatherOffset) + weatherOffset);
    }

    public Vec3D getSkyColor(Entity entity, float f2) {
        float f7;
        float f1 = this.getCelestialAngle(f2);
        float f22 = MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f22 < 0.0f) {
            f22 = 0.0f;
        }
        if (f22 > 1.0f) {
            f22 = 1.0f;
        }
        int x2 = MathHelper.floor_double(entity.posX);
        int y2 = MathHelper.floor_double(entity.posZ);
        float f3 = (float)this.getWorldChunkManager().getTemperature(x2, y2);
        int k2 = this.getWorldChunkManager().getBiomeGenAt(x2, y2).getSkyColorByTemp(f3);
        float f4 = (float)(k2 >> 16 & 0xFF) / 255.0f;
        float f5 = (float)(k2 >> 8 & 0xFF) / 255.0f;
        float f6 = (float)(k2 & 0xFF) / 255.0f;
        f4 *= f22;
        f5 *= f22;
        f6 *= f22;
        float f8 = f7 = this.currentWeather != null && this.currentWeather.isPrecipitation ? this.weatherIntensity * this.weatherPower : 0.0f;
        if (f7 > 0.0f) {
            float f82 = (f4 * 0.3f + f5 * 0.59f + f6 * 0.11f) * 0.6f;
            float f10 = 1.0f - f7 * 0.75f;
            f4 = f4 * f10 + f82 * (1.0f - f10);
            f5 = f5 * f10 + f82 * (1.0f - f10);
            f6 = f6 * f10 + f82 * (1.0f - f10);
        }
        if (this.lightningFlicker > 0) {
            float f12 = (float)this.lightningFlicker - f2;
            if (f12 > 1.0f) {
                f12 = 1.0f;
            }
            f4 = f4 * (1.0f - (f12 *= 0.45f)) + 0.8f * f12;
            f5 = f5 * (1.0f - f12) + 0.8f * f12;
            f6 = f6 * (1.0f - f12) + 1.0f * f12;
        }
        return Vec3D.createVector(f4, f5, f6);
    }

    public float getCelestialAngle(float f2) {
        return this.dimension.worldType.worldProvider.calculateCelestialAngle(this.worldInfo.getWorldTime(), f2);
    }

    public Vec3D getDimensionColor(float time) {
        float f6;
        float f1 = this.getCelestialAngle(time);
        float f2 = MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f2 > 1.0f) {
            f2 = 1.0f;
        }
        float f3 = (float)(this.dimensionColor >> 16 & 0xFFL) / 255.0f;
        float f4 = (float)(this.dimensionColor >> 8 & 0xFFL) / 255.0f;
        float f5 = (float)(this.dimensionColor & 0xFFL) / 255.0f;
        float f7 = f6 = this.currentWeather != null && this.currentWeather.isPrecipitation ? this.weatherIntensity * this.weatherPower : 0.0f;
        if (f6 > 0.0f) {
            float f72 = (f3 * 0.3f + f4 * 0.59f + f5 * 0.11f) * 0.6f;
            float f9 = 1.0f - f6 * 0.95f;
            f3 = f3 * f9 + f72 * (1.0f - f9);
            f4 = f4 * f9 + f72 * (1.0f - f9);
            f5 = f5 * f9 + f72 * (1.0f - f9);
        }
        return Vec3D.createVector(f3 *= f2 * 0.9f + 0.1f, f4 *= f2 * 0.9f + 0.1f, f5 *= f2 * 0.85f + 0.15f);
    }

    public Vec3D getFogColor(float f2) {
        float f1 = this.getCelestialAngle(f2);
        return this.dimension.worldType.worldProvider.func_4096_a(f1, f2);
    }

    public int findTopSolidBlock(int i2, int j2) {
        Chunk chunk = this.getChunkFromBlockCoords(i2, j2);
        i2 &= 0xF;
        j2 &= 0xF;
        for (int k2 = net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS - 1; k2 > 0; --k2) {
            Material material;
            int l2 = chunk.getBlockID(i2, k2, j2);
            Material material2 = material = l2 != 0 ? Block.blocksList[l2].blockMaterial : Material.air;
            if (!material.getIsSolid() && !material.getIsLiquid()) {
                continue;
            }
            return k2 + 1;
        }
        return -1;
    }

    public int findTopSolidNonLiquidBlock(int i2, int j2) {
        Chunk chunk = this.getChunkFromBlockCoords(i2, j2);
        i2 &= 0xF;
        j2 &= 0xF;
        for (int k2 = net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS - 1; k2 > 0; --k2) {
            Material material;
            int l2 = chunk.getBlockID(i2, k2, j2);
            Material material2 = material = l2 != 0 ? Block.blocksList[l2].blockMaterial : Material.air;
            if (!material.getIsSolid()) {
                continue;
            }
            return k2 + 1;
        }
        return -1;
    }

    public float getStarBrightness(float f2) {
        float f1 = this.getCelestialAngle(f2);
        float f22 = 1.0f - (MathHelper.cos(f1 * 3.141593f * 2.0f) * 2.0f + 0.75f);
        if (f22 < 0.0f) {
            f22 = 0.0f;
        }
        if (f22 > 1.0f) {
            f22 = 1.0f;
        }
        return f22 * f22 * 0.5f;
    }

    public void scheduleBlockUpdate(int i2, int j2, int k2, int l2, int i1) {
        NextTickListEntry nextticklistentry = new NextTickListEntry(i2, j2, k2, l2);
        int byte0 = 8;
        if (this.scheduledUpdatesAreImmediate) {
            int j1;
            if (this.checkChunksExist(nextticklistentry.xCoord - byte0, nextticklistentry.yCoord - byte0, nextticklistentry.zCoord - byte0, nextticklistentry.xCoord + byte0, nextticklistentry.yCoord + byte0, nextticklistentry.zCoord + byte0) && (j1 = this.getBlockId(nextticklistentry.xCoord, nextticklistentry.yCoord, nextticklistentry.zCoord)) == nextticklistentry.blockID && j1 > 0) {
                Block.blocksList[j1].updateTick(this, nextticklistentry.xCoord, nextticklistentry.yCoord, nextticklistentry.zCoord, this.rand);
            }
            return;
        }
        if (this.checkChunksExist(i2 - byte0, j2 - byte0, k2 - byte0, i2 + byte0, j2 + byte0, k2 + byte0)) {
            if (l2 > 0) {
                nextticklistentry.setScheduledTime((long)i1 + this.worldInfo.getWorldTime());
            }
            if (!this.scheduledTickSet.contains(nextticklistentry)) {
                this.scheduledTickSet.add(nextticklistentry);
                this.scheduledTickTreeSet.add(nextticklistentry);
            }
        }
    }

    public void updateEntities() {
        for (int i2 = 0; i2 < this.weatherEffects.size(); ++i2) {
            Entity entity = this.weatherEffects.get(i2);
            entity.onUpdate();
            if (!entity.isDead) continue;
            this.weatherEffects.remove(i2--);
        }
        this.loadedEntityList.removeAll(this.unloadedEntityList);
        for (int j2 = 0; j2 < this.unloadedEntityList.size(); ++j2) {
            Entity entity1 = this.unloadedEntityList.get(j2);
            int i1 = entity1.chunkCoordX;
            int k1 = entity1.chunkCoordZ;
            if (!entity1.addedToChunk || !this.chunkExists(i1, k1)) continue;
            this.getChunkFromChunkCoords(i1, k1).removeEntity(entity1);
        }
        for (int k2 = 0; k2 < this.unloadedEntityList.size(); ++k2) {
            this.releaseEntitySkin(this.unloadedEntityList.get(k2));
        }
        this.unloadedEntityList.clear();
        for (int l2 = 0; l2 < this.loadedEntityList.size(); ++l2) {
            Entity entity2 = this.loadedEntityList.get(l2);
            if (entity2.ridingEntity != null) {
                if (!entity2.ridingEntity.isDead && entity2.ridingEntity.riddenByEntity == entity2) continue;
                entity2.ridingEntity.riddenByEntity = null;
                entity2.ridingEntity = null;
            }
            if (!entity2.isDead) {
                this.updateEntity(entity2);
            }
            if (!entity2.isDead) continue;
            int j1 = entity2.chunkCoordX;
            int l1 = entity2.chunkCoordZ;
            if (entity2.addedToChunk && this.chunkExists(j1, l1)) {
                this.getChunkFromChunkCoords(j1, l1).removeEntity(entity2);
            }
            this.loadedEntityList.remove(l2--);
            this.releaseEntitySkin(entity2);
        }
        this.field_31055_L = true;
        Iterator<TileEntity> iterator = this.loadedTileEntityList.iterator();
        while (iterator.hasNext()) {
            TileEntity tileentity = iterator.next();
            if (!tileentity.isInvalid()) {
                tileentity.updateEntity();
            }
            if (!tileentity.isInvalid()) continue;
            iterator.remove();
            Chunk chunk = this.getChunkFromChunkCoords(tileentity.xCoord >> 4, tileentity.zCoord >> 4);
            if (chunk == null) continue;
            chunk.removeChunkBlockTileEntity(tileentity.xCoord & 0xF, tileentity.yCoord, tileentity.zCoord & 0xF);
        }
        this.field_31055_L = false;
        if (!this.field_30900_E.isEmpty()) {
            for (TileEntity tileentity1 : this.field_30900_E) {
                Chunk chunk1;
                if (tileentity1.isInvalid()) continue;
                if (!this.loadedTileEntityList.contains(tileentity1)) {
                    this.loadedTileEntityList.add(tileentity1);
                }
                if ((chunk1 = this.getChunkFromChunkCoords(tileentity1.xCoord >> 4, tileentity1.zCoord >> 4)) != null) {
                    chunk1.setChunkBlockTileEntity(tileentity1.xCoord & 0xF, tileentity1.yCoord, tileentity1.zCoord & 0xF, tileentity1);
                }
                this.markBlockNeedsUpdate(tileentity1.xCoord, tileentity1.yCoord, tileentity1.zCoord);
            }
            this.field_30900_E.clear();
        }
    }

    public void func_31054_a(Collection collection) {
        if (this.field_31055_L) {
            this.field_30900_E.addAll(collection);
        } else {
            this.loadedTileEntityList.addAll(collection);
        }
    }

    public void updateEntity(Entity entity) {
        this.updateEntityWithOptionalForce(entity, true);
    }

    public void updateEntityWithOptionalForce(Entity entity, boolean flag) {
        int i2 = MathHelper.floor_double(entity.posX);
        int j2 = MathHelper.floor_double(entity.posZ);
        int byte0 = 32;
        if (flag && !this.checkChunksExist(i2 - byte0, 0, j2 - byte0, i2 + byte0, net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS, j2 + byte0)) {
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).tryToDespawn();
            }
            return;
        }
        entity.lastTickPosX = entity.posX;
        entity.lastTickPosY = entity.posY;
        entity.lastTickPosZ = entity.posZ;
        entity.prevRotationYaw = entity.rotationYaw;
        entity.prevRotationPitch = entity.rotationPitch;
        if (flag && entity.addedToChunk) {
            if (entity.ridingEntity != null) {
                entity.updateRidden();
            } else {
                entity.onUpdate();
            }
        }
        if (Double.isNaN(entity.posX) || Double.isInfinite(entity.posX)) {
            entity.posX = entity.lastTickPosX;
        }
        if (Double.isNaN(entity.posY) || Double.isInfinite(entity.posY)) {
            entity.posY = entity.lastTickPosY;
        }
        if (Double.isNaN(entity.posZ) || Double.isInfinite(entity.posZ)) {
            entity.posZ = entity.lastTickPosZ;
        }
        if (Double.isNaN(entity.rotationPitch) || Double.isInfinite(entity.rotationPitch)) {
            entity.rotationPitch = entity.prevRotationPitch;
        }
        if (Double.isNaN(entity.rotationYaw) || Double.isInfinite(entity.rotationYaw)) {
            entity.rotationYaw = entity.prevRotationYaw;
        }
        int k2 = MathHelper.floor_double(entity.posX / 16.0);
        int l2 = MathHelper.floor_double(entity.posY / 16.0);
        int i1 = MathHelper.floor_double(entity.posZ / 16.0);
        if (!entity.addedToChunk || entity.chunkCoordX != k2 || entity.chunkCoordY != l2 || entity.chunkCoordZ != i1) {
            if (entity.addedToChunk && this.chunkExists(entity.chunkCoordX, entity.chunkCoordZ)) {
                this.getChunkFromChunkCoords(entity.chunkCoordX, entity.chunkCoordZ).removeEntityAtIndex(entity, entity.chunkCoordY);
            }
            if (this.chunkExists(k2, i1)) {
                entity.addedToChunk = true;
                this.getChunkFromChunkCoords(k2, i1).addEntity(entity);
            } else {
                entity.addedToChunk = false;
            }
        }
        if (flag && entity.addedToChunk && entity.riddenByEntity != null) {
            if (entity.riddenByEntity.isDead || entity.riddenByEntity.ridingEntity != entity) {
                entity.riddenByEntity.ridingEntity = null;
                entity.riddenByEntity = null;
            } else {
                this.updateEntity(entity.riddenByEntity);
            }
        }
    }

    public boolean checkIfAABBIsClear(AxisAlignedBB axisalignedbb) {
        if (axisalignedbb == null) {
            return true;
        }
        List<Entity> list = this.getEntitiesWithinAABBExcludingEntity(null, axisalignedbb);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Entity entity = list.get(i2);
            if (entity.isDead || !entity.preventEntitySpawning) continue;
            return false;
        }
        return true;
    }

    public boolean getIsAnyBlock(AxisAlignedBB axisalignedbb) {
        int i2 = MathHelper.floor_double(axisalignedbb.minX);
        int j2 = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k2 = MathHelper.floor_double(axisalignedbb.minY);
        int l2 = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        if (axisalignedbb.minX < 0.0) {
            --i2;
        }
        if (axisalignedbb.minY < 0.0) {
            --k2;
        }
        if (axisalignedbb.minZ < 0.0) {
            --i1;
        }
        for (int k1 = i2; k1 < j2; ++k1) {
            for (int l1 = k2; l1 < l2; ++l1) {
                for (int i22 = i1; i22 < j1; ++i22) {
                    Block block = Block.blocksList[this.getBlockId(k1, l1, i22)];
                    if (block == null) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean getIsAnyLiquid(AxisAlignedBB axisalignedbb) {
        int i2 = MathHelper.floor_double(axisalignedbb.minX);
        int j2 = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k2 = MathHelper.floor_double(axisalignedbb.minY);
        int l2 = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        if (axisalignedbb.minX < 0.0) {
            --i2;
        }
        if (axisalignedbb.minY < 0.0) {
            --k2;
        }
        if (axisalignedbb.minZ < 0.0) {
            --i1;
        }
        for (int k1 = i2; k1 < j2; ++k1) {
            for (int l1 = k2; l1 < l2; ++l1) {
                for (int i22 = i1; i22 < j1; ++i22) {
                    Block block = Block.blocksList[this.getBlockId(k1, l1, i22)];
                    if (block == null || !block.blockMaterial.getIsLiquid()) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isBoundingBoxBurning(AxisAlignedBB axisalignedbb) {
        int j1;
        int i2 = MathHelper.floor_double(axisalignedbb.minX);
        int j2 = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k2 = MathHelper.floor_double(axisalignedbb.minY);
        int l2 = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        if (this.checkChunksExist(i2, k2, i1, j2, l2, j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0))) {
            for (int k1 = i2; k1 < j2; ++k1) {
                for (int l1 = k2; l1 < l2; ++l1) {
                    for (int i22 = i1; i22 < j1; ++i22) {
                        int j22 = this.getBlockId(k1, l1, i22);
                        if (j22 != Block.fire.blockID && j22 != Block.fluidLavaFlowing.blockID && j22 != Block.fluidLavaStill.blockID && j22 != Block.netherrackIgneous.blockID) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public boolean handleMaterialAcceleration(AxisAlignedBB axisalignedbb, Material material, Entity entity) {
        int j1;
        int i2 = MathHelper.floor_double(axisalignedbb.minX);
        int j2 = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k2 = MathHelper.floor_double(axisalignedbb.minY);
        int l2 = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        if (!this.checkChunksExist(i2, k2, i1, j2, l2, j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0))) {
            return false;
        }
        boolean flag = false;
        Vec3D vec3d = Vec3D.createVector(0.0, 0.0, 0.0);
        for (int k1 = i2; k1 < j2; ++k1) {
            for (int l1 = k2; l1 < l2; ++l1) {
                for (int i22 = i1; i22 < j1; ++i22) {
                    double d1;
                    Block block = Block.blocksList[this.getBlockId(k1, l1, i22)];
                    if (block == null || block.blockMaterial != material || !((double)l2 >= (d1 = (double)((float)(l1 + 1) - BlockFluid.getPercentAir(this.getBlockMetadata(k1, l1, i22)))))) continue;
                    flag = true;
                    block.velocityToAddToEntity(this, k1, l1, i22, entity, vec3d);
                }
            }
        }
        if (vec3d.lengthVector() > 0.0) {
            vec3d = vec3d.normalize();
            double d2 = 0.014;
            entity.motionX += vec3d.xCoord * d2;
            entity.motionY += vec3d.yCoord * d2;
            entity.motionZ += vec3d.zCoord * d2;
        }
        return flag;
    }

    public boolean isMaterialInBB(AxisAlignedBB axisalignedbb, Material material) {
        int i2 = MathHelper.floor_double(axisalignedbb.minX);
        int j2 = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k2 = MathHelper.floor_double(axisalignedbb.minY);
        int l2 = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        for (int k1 = i2; k1 < j2; ++k1) {
            for (int l1 = k2; l1 < l2; ++l1) {
                for (int i22 = i1; i22 < j1; ++i22) {
                    Block block = Block.blocksList[this.getBlockId(k1, l1, i22)];
                    if (block == null || block.blockMaterial != material) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public boolean isAABBInMaterial(AxisAlignedBB axisalignedbb, Material material) {
        int i2 = MathHelper.floor_double(axisalignedbb.minX);
        int j2 = MathHelper.floor_double(axisalignedbb.maxX + 1.0);
        int k2 = MathHelper.floor_double(axisalignedbb.minY);
        int l2 = MathHelper.floor_double(axisalignedbb.maxY + 1.0);
        int i1 = MathHelper.floor_double(axisalignedbb.minZ);
        int j1 = MathHelper.floor_double(axisalignedbb.maxZ + 1.0);
        for (int k1 = i2; k1 < j2; ++k1) {
            for (int l1 = k2; l1 < l2; ++l1) {
                for (int i22 = i1; i22 < j1; ++i22) {
                    Block block = Block.blocksList[this.getBlockId(k1, l1, i22)];
                    if (block == null || block.blockMaterial != material) continue;
                    int j22 = this.getBlockMetadata(k1, l1, i22);
                    double d2 = l1 + 1;
                    if (j22 < 8) {
                        d2 = (double)(l1 + 1) - (double)j22 / 8.0;
                    }
                    if (!(d2 >= axisalignedbb.minY)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public Explosion createExplosion(Entity entity, double d2, double d1, double d22, float f2) {
        return this.newExplosion(entity, d2, d1, d22, f2, false, false);
    }

    public Explosion newExplosion(Entity entity, double d2, double d1, double d22, float f2, boolean flag, boolean isCannonBall) {
        Explosion explosion = !isCannonBall ? new Explosion(this, entity, d2, d1, d22, f2) : new ExplosionCannonball(this, entity, d2, d1, d22, f2);
        explosion.isFlaming = flag;
        explosion.doExplosionA();
        explosion.doExplosionB(true);
        return explosion;
    }

    public float func_675_a(Vec3D vec3d, AxisAlignedBB axisalignedbb) {
        double d2 = 1.0 / ((axisalignedbb.maxX - axisalignedbb.minX) * 2.0 + 1.0);
        double d1 = 1.0 / ((axisalignedbb.maxY - axisalignedbb.minY) * 2.0 + 1.0);
        double d22 = 1.0 / ((axisalignedbb.maxZ - axisalignedbb.minZ) * 2.0 + 1.0);
        int i2 = 0;
        int j2 = 0;
        float f2 = 0.0f;
        while (f2 <= 1.0f) {
            float f1 = 0.0f;
            while (f1 <= 1.0f) {
                float f22 = 0.0f;
                while (f22 <= 1.0f) {
                    double d3 = axisalignedbb.minX + (axisalignedbb.maxX - axisalignedbb.minX) * (double)f2;
                    double d4 = axisalignedbb.minY + (axisalignedbb.maxY - axisalignedbb.minY) * (double)f1;
                    double d5 = axisalignedbb.minZ + (axisalignedbb.maxZ - axisalignedbb.minZ) * (double)f22;
                    if (this.rayTraceBlocks(Vec3D.createVector(d3, d4, d5), vec3d) == null) {
                        ++i2;
                    }
                    ++j2;
                    f22 = (float)((double)f22 + d22);
                }
                f1 = (float)((double)f1 + d1);
            }
            f2 = (float)((double)f2 + d2);
        }
        return (float)i2 / (float)j2;
    }

    public void onBlockHit(EntityPlayer entityplayer, int x2, int y2, int z2, int side) {
        if (side == 0) {
            --y2;
        }
        if (side == 1) {
            ++y2;
        }
        if (side == 2) {
            --z2;
        }
        if (side == 3) {
            ++z2;
        }
        if (side == 4) {
            --x2;
        }
        if (side == 5) {
            ++x2;
        }
        if (this.getBlockId(x2, y2, z2) == Block.fire.blockID) {
            this.playSoundEffectForPlayer(entityplayer, 1004, x2, y2, z2, 0);
            this.setBlockWithNotify(x2, y2, z2, 0);
        }
    }

    public Entity func_4085_a(Class class1) {
        return null;
    }

    public String func_687_d() {
        return "All: " + this.loadedEntityList.size();
    }

    public String func_21119_g() {
        return this.chunkProvider.makeString();
    }

    @Override
    public TileEntity getBlockTileEntity(int i2, int j2, int k2) {
        Chunk chunk = this.getChunkFromChunkCoords(i2 >> 4, k2 >> 4);
        if (chunk != null) {
            return chunk.getChunkBlockTileEntity(i2 & 0xF, j2, k2 & 0xF);
        }
        return null;
    }

    public void setBlockTileEntity(int i2, int j2, int k2, TileEntity tileentity) {
        if (!tileentity.isInvalid()) {
            if (this.field_31055_L) {
                tileentity.xCoord = i2;
                tileentity.yCoord = j2;
                tileentity.zCoord = k2;
                this.field_30900_E.add(tileentity);
            } else {
                this.loadedTileEntityList.add(tileentity);
                Chunk chunk = this.getChunkFromChunkCoords(i2 >> 4, k2 >> 4);
                if (chunk != null) {
                    chunk.setChunkBlockTileEntity(i2 & 0xF, j2, k2 & 0xF, tileentity);
                }
            }
        }
    }

    public void removeBlockTileEntity(int i2, int j2, int k2) {
        TileEntity tileentity = this.getBlockTileEntity(i2, j2, k2);
        if (tileentity != null && this.field_31055_L) {
            tileentity.invalidate();
        } else {
            Chunk chunk;
            if (tileentity != null) {
                this.loadedTileEntityList.remove(tileentity);
            }
            if ((chunk = this.getChunkFromChunkCoords(i2 >> 4, k2 >> 4)) != null) {
                chunk.removeChunkBlockTileEntity(i2 & 0xF, j2, k2 & 0xF);
            }
        }
    }

    @Override
    public boolean isBlockOpaqueCube(int i2, int j2, int k2) {
        Block block = Block.blocksList[this.getBlockId(i2, j2, k2)];
        if (block == null) {
            return false;
        }
        return block.isOpaqueCube();
    }

    public boolean canPlaceOnSurfaceOfBlock(int x2, int y2, int z2) {
        Block block = Block.blocksList[this.getBlockId(x2, y2, z2)];
        if (block == null) {
            return false;
        }
        return block.canPlaceOnSurfaceOnCondition(this, x2, y2, z2);
    }

    @Override
    public boolean isBlockNormalCube(int i2, int j2, int k2) {
        Block block = Block.blocksList[this.getBlockId(i2, j2, k2)];
        if (block == null) {
            return false;
        }
        return block.blockMaterial.getIsTranslucent() && block.renderAsNormalBlockOnCondition(this, i2, j2, k2);
    }

    public void saveWorldIndirectly(IProgressUpdate iprogressupdate) {
        this.saveWorld(true, iprogressupdate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updatingLighting() {
        if (this.lightingUpdatesCounter >= 50) {
            return false;
        }
        ++this.lightingUpdatesCounter;
        try {
            boolean flag1;
            int i2 = 500;
            while (this.lightingToUpdate.size() > 0) {
                if (--i2 <= 0) {
                    boolean flag;
                    boolean bl2 = flag = true;
                    return bl2;
                }
                this.lightingToUpdate.remove(this.lightingToUpdate.size() - 1).func_4127_a(this);
            }
            boolean bl3 = flag1 = false;
            return bl3;
        }
        finally {
            --this.lightingUpdatesCounter;
        }
    }

    public void scheduleLightingUpdate(EnumLightType enumskyblock, int i2, int j2, int k2, int l2, int i1, int j1) {
        this.scheduleLightingUpdate_do(enumskyblock, i2, j2, k2, l2, i1, j1, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void scheduleLightingUpdate_do(EnumLightType enumskyblock, int i2, int j2, int k2, int l2, int i1, int j1, boolean flag) {
        if (this.dimension.worldType.worldProvider.hasNoSky && enumskyblock == EnumLightType.Sky) {
            return;
        }
        ++lightingUpdatesScheduled;
        try {
            if (lightingUpdatesScheduled == 50) {
                return;
            }
            int k1 = (l2 + i2) / 2;
            int l1 = (j1 + k2) / 2;
            if (!this.blockExists(k1, 64, l1)) {
                return;
            }
            if (this.getChunkFromBlockCoords(k1, l1).func_21167_h()) {
                return;
            }
            int i22 = this.lightingToUpdate.size();
            if (flag) {
                int j22 = 5;
                if (j22 > i22) {
                    j22 = i22;
                }
                for (int l22 = 0; l22 < j22; ++l22) {
                    MetadataChunkBlock metadatachunkblock = this.lightingToUpdate.get(this.lightingToUpdate.size() - l22 - 1);
                    if (metadatachunkblock.field_1299_a != enumskyblock || !metadatachunkblock.func_866_a(i2, j2, k2, l2, i1, j1)) continue;
                    return;
                }
            }
            this.lightingToUpdate.add(new MetadataChunkBlock(enumskyblock, i2, j2, k2, l2, i1, j1));
            int k22 = 1000000;
            if (this.lightingToUpdate.size() > 1000000) {
                System.out.println("More than " + k22 + " updates, aborting lighting updates");
                this.lightingToUpdate.clear();
            }
        }
        finally {
            --lightingUpdatesScheduled;
        }
    }

    public void calculateInitialSkylight() {
        int i2 = this.calculateSkylightSubtracted(1.0f);
        if (i2 != this.skylightSubtracted) {
            this.skylightSubtracted = i2;
        }
    }

    public void setAllowedMobSpawns(boolean flag, boolean flag1) {
        this.spawnHostileMobs = flag;
        this.spawnPeacefulMobs = flag1;
    }

    public void doLightingUpdate() {
        int i2 = this.calculateSkylightSubtracted(1.0f);
        if (i2 != this.skylightSubtracted) {
            this.skylightSubtracted = i2;
            for (int j2 = 0; j2 < this.worldAccesses.size(); ++j2) {
                this.worldAccesses.get(j2).updateAllRenderers();
            }
        }
    }

    public void doSeasonUpdate() {
        int oldDayInSeason = this.dayInSeason;
        Season oldSeason = this.currentSeason;
        this.updateCurrentSeason();
        if (oldDayInSeason != this.dayInSeason || oldSeason != this.currentSeason) {
            for (int j2 = 0; j2 < this.worldAccesses.size(); ++j2) {
                this.worldAccesses.get(j2).updateAllRenderers();
            }
        }
    }

    public void tick() {
        this.updateWeather();
        if (this.areEnoughPlayersFullyAsleep()) {
            boolean flag = false;
            if (this.spawnHostileMobs && this.difficultySetting >= 1 && this.getPlayersRequiredToSkipNight() <= 1) {
                flag = SpawnerMobs.performSleepSpawning(this, this.players);
            }
            if (!flag) {
                if (MinecraftServer.getInstance() != null && this.players.size() > 1 && this.getPlayersRequiredToSkipNight() <= 1) {
                    EntityPlayer player = null;
                    for (EntityPlayer player2 : this.players) {
                        if (!player2.isPlayerFullyAsleep()) continue;
                        player = player2;
                    }
                    if (player != null) {
                        MinecraftServer.getInstance().configManager.sendPacketToAllPlayersInDimension(new Packet3Chat(ChatColor.yellow + player.username + ChatColor.orange + " went to sleep. Sweet dreams!"), this.dimension.dimId);
                    }
                }
                long l2 = this.worldInfo.getWorldTime() + (long)net.minecraft.shared.Minecraft.DAY_LENGTH_TICKS;
                this.worldInfo.setWorldTime(l2 - l2 % (long)net.minecraft.shared.Minecraft.DAY_LENGTH_TICKS);
                this.wakeUpAllPlayers();
            }
        }
        SpawnerMobs.performSpawning(this, this.spawnHostileMobs, this.spawnPeacefulMobs);
        this.chunkProvider.unload100OldestChunks();
        this.doLightingUpdate();
        long l1 = this.worldInfo.getWorldTime() + 1L;
        if (l1 % (long)this.autosavePeriod == 0L && AUTOSAVE) {
            this.saveWorld(false, null);
        }
        this.worldInfo.setWorldTime(l1);
        this.TickUpdates(false);
        this.updateBlocksAndPlayCaveSounds();
        this.doSeasonUpdate();
    }

    protected boolean updateWeather() {
        if (this.dimension.worldType.worldProvider.hasNoSky) {
            return false;
        }
        if (this.getCurrentSeason() == null) {
            return false;
        }
        if (this.currentWeather == null) {
            this.currentWeather = this.dimension.worldType.defaultWeather;
        }
        if (this.newWeather == null && this.weatherIntensity <= 1.0f) {
            this.weatherIntensity += 0.002f;
            if (this.weatherIntensity > 1.0f) {
                this.weatherIntensity = 1.0f;
            }
        } else if (this.newWeather != null && this.weatherIntensity >= 0.0f) {
            this.weatherIntensity -= 0.002f;
            if (this.weatherIntensity <= 0.0f) {
                this.weatherIntensity = 0.0f;
                this.currentWeather = this.newWeather;
                this.weatherPower = new Random().nextFloat() * 0.5f + 0.5f;
                this.newWeather = null;
            }
        }
        --this.weatherDuration;
        if (this.weatherDuration <= 0L) {
            if (this.currentWeather != this.dimension.worldType.defaultWeather) {
                this.newWeather = this.dimension.worldType.defaultWeather;
            } else {
                Season season = this.getCurrentSeason();
                boolean foundWeather = false;
                float acc = 0.0f;
                float val = this.rand.nextFloat();
                for (int i2 = 0; i2 < season.allowedWeathers.size(); ++i2) {
                    if (!(val < (acc += season.weatherProbability.get(season.allowedWeathers.get(i2)).floatValue()))) continue;
                    this.newWeather = season.allowedWeathers.get(i2);
                    foundWeather = true;
                    break;
                }
                if (!foundWeather) {
                    this.newWeather = this.dimension.worldType.defaultWeather;
                }
            }
            this.weatherDuration = this.getRandomWeatherDuration();
        }
        this.worldInfo.setWeatherId(this.currentWeather.weatherId);
        if (this.newWeather != null) {
            this.worldInfo.setNewWeatherId(this.newWeather.weatherId);
        } else {
            this.worldInfo.setNewWeatherId(-1);
        }
        this.worldInfo.setWeatherDuration(this.weatherDuration);
        this.worldInfo.setWeatherIntensity(this.weatherIntensity);
        this.worldInfo.setWeatherPower(this.weatherPower);
        return true;
    }

    public long getRandomWeatherDuration() {
        return (long)(this.rand.nextFloat() * ((float)net.minecraft.shared.Minecraft.DAY_LENGTH_TICKS * 1.5f) + (float)net.minecraft.shared.Minecraft.DAY_LENGTH_TICKS * 0.25f);
    }

    protected void updateBlocksAndPlayCaveSounds() {
        this.positionsToUpdate.clear();
        for (int i2 = 0; i2 < this.players.size(); ++i2) {
            EntityPlayer entityplayer = this.players.get(i2);
            int j2 = MathHelper.floor_double(entityplayer.posX / 16.0);
            int l2 = MathHelper.floor_double(entityplayer.posZ / 16.0);
            int byte0 = 9;
            for (int j1 = -byte0; j1 <= byte0; ++j1) {
                for (int k2 = -byte0; k2 <= byte0; ++k2) {
                    this.positionsToUpdate.add(new ChunkCoordIntPair(j1 + j2, k2 + l2));
                }
            }
        }
        if (this.soundCounter > 0) {
            --this.soundCounter;
        }
        for (ChunkCoordIntPair chunkcoordintpair : this.positionsToUpdate) {
            EntityPlayer entityplayer1;
            int l4;
            int l5;
            int k2 = chunkcoordintpair.chunkXPos * 16;
            int i1 = chunkcoordintpair.chunkZPos * 16;
            Chunk chunk = this.getChunkFromChunkCoords(chunkcoordintpair.chunkXPos, chunkcoordintpair.chunkZPos);
            this.updateLCG = this.updateLCG * 3 + 1013904223;
            int k1 = this.updateLCG >> 2;
            int l2 = k1 & 0xF;
            int l3 = k1 >> 8 & 0xF;
            if (this.soundCounter == 0 && (l5 = chunk.getBlockID(l2, l4 = k1 >> 16 & 0x7F, l3)) == 0 && this.getFullBlockLightValue(l2 += k2, l4, l3 += i1) <= this.rand.nextInt(8) && this.getSavedLightValue(EnumLightType.Sky, l2, l4, l3) <= 0 && (entityplayer1 = this.getClosestPlayer((double)l2 + 0.5, (double)l4 + 0.5, (double)l3 + 0.5, 8.0)) != null && entityplayer1.getDistanceSq((double)l2 + 0.5, (double)l4 + 0.5, (double)l3 + 0.5) > 4.0) {
                this.playSoundEffect((double)l2 + 0.5, (double)l4 + 0.5, (double)l3 + 0.5, "ambient.cave.cave", 0.7f, 0.8f + this.rand.nextFloat() * 0.2f);
                this.soundCounter = this.rand.nextInt(12000) + 6000;
            }
            if (this.currentWeather != null) {
                this.updateLCG = this.updateLCG * 3 + 1013904223;
                int l1 = this.updateLCG >> 2;
                int x2 = k2 + (l1 & 0xF);
                int z2 = i1 + (l1 >> 8 & 0xF);
                this.currentWeather.doEnvironmentUpdate(this, this.rand, x2, z2);
            }
            for (int j2 = 0; j2 < 80; ++j2) {
                this.updateLCG = this.updateLCG * 3 + 1013904223;
                int k3 = this.updateLCG >> 2;
                int k4 = k3 & 0xF;
                int k5 = k3 >> 8 & 0xF;
                int j6 = k3 >> 16 & 0xFF;
                int l6 = chunk.blocks[k4 << net.minecraft.shared.Minecraft.WORLD_HEIGHT_BITS + 4 | k5 << net.minecraft.shared.Minecraft.WORLD_HEIGHT_BITS | j6] & 0x3FFF;
                if (!Block.tickOnLoad[l6]) continue;
                Block.blocksList[l6].updateTick(this, k4 + k2, j6, k5 + i1, this.rand);
            }
        }
    }

    public boolean TickUpdates(boolean flag) {
        int i2 = this.scheduledTickTreeSet.size();
        if (i2 != this.scheduledTickSet.size()) {
            throw new IllegalStateException("TickNextTick list out of sync");
        }
        if (i2 > 1000) {
            i2 = 1000;
        }
        for (int j2 = 0; j2 < i2; ++j2) {
            int k2;
            NextTickListEntry nextticklistentry = this.scheduledTickTreeSet.first();
            if (!flag && nextticklistentry.scheduledTime > this.worldInfo.getWorldTime()) break;
            this.scheduledTickTreeSet.remove(nextticklistentry);
            this.scheduledTickSet.remove(nextticklistentry);
            int byte0 = 8;
            if (!this.checkChunksExist(nextticklistentry.xCoord - byte0, nextticklistentry.yCoord - byte0, nextticklistentry.zCoord - byte0, nextticklistentry.xCoord + byte0, nextticklistentry.yCoord + byte0, nextticklistentry.zCoord + byte0) || (k2 = this.getBlockId(nextticklistentry.xCoord, nextticklistentry.yCoord, nextticklistentry.zCoord)) != nextticklistentry.blockID || k2 <= 0) continue;
            Block.blocksList[k2].updateTick(this, nextticklistentry.xCoord, nextticklistentry.yCoord, nextticklistentry.zCoord, this.rand);
        }
        return this.scheduledTickTreeSet.size() != 0;
    }

    public void randomDisplayUpdates(int i2, int j2, int k2) {
        int byte0 = 16;
        Random random = new Random();
        for (int l2 = 0; l2 < 1000; ++l2) {
            int k1;
            int j1;
            int i1 = i2 + this.rand.nextInt(byte0) - this.rand.nextInt(byte0);
            int l1 = this.getBlockId(i1, j1 = j2 + this.rand.nextInt(byte0) - this.rand.nextInt(byte0), k1 = k2 + this.rand.nextInt(byte0) - this.rand.nextInt(byte0));
            if (l1 <= 0) continue;
            Block.blocksList[l1].randomDisplayTick(this, i1, j1, k1, random);
        }
    }

    public List<Entity> getEntitiesWithinAABBExcludingEntity(Entity entity, AxisAlignedBB axisalignedbb) {
        this.entityBuffer.clear();
        int i2 = MathHelper.floor_double((axisalignedbb.minX - 2.0) / 16.0);
        int j2 = MathHelper.floor_double((axisalignedbb.maxX + 2.0) / 16.0);
        int k2 = MathHelper.floor_double((axisalignedbb.minZ - 2.0) / 16.0);
        int l2 = MathHelper.floor_double((axisalignedbb.maxZ + 2.0) / 16.0);
        for (int i1 = i2; i1 <= j2; ++i1) {
            for (int j1 = k2; j1 <= l2; ++j1) {
                if (!this.chunkExists(i1, j1)) continue;
                this.getChunkFromChunkCoords(i1, j1).getEntitiesWithinAABBForEntity(entity, axisalignedbb, this.entityBuffer);
            }
        }
        return this.entityBuffer;
    }

    public List<Entity> getEntitiesWithinAABB(Class class1, AxisAlignedBB axisalignedbb) {
        int i2 = MathHelper.floor_double((axisalignedbb.minX - 2.0) / 16.0);
        int j2 = MathHelper.floor_double((axisalignedbb.maxX + 2.0) / 16.0);
        int k2 = MathHelper.floor_double((axisalignedbb.minZ - 2.0) / 16.0);
        int l2 = MathHelper.floor_double((axisalignedbb.maxZ + 2.0) / 16.0);
        ArrayList<Entity> arraylist = new ArrayList<Entity>();
        for (int i1 = i2; i1 <= j2; ++i1) {
            for (int j1 = k2; j1 <= l2; ++j1) {
                if (!this.chunkExists(i1, j1)) continue;
                this.getChunkFromChunkCoords(i1, j1).getEntitiesOfTypeWithinAAAB(class1, axisalignedbb, arraylist);
            }
        }
        return arraylist;
    }

    public List<Entity> getLoadedEntityList() {
        return this.loadedEntityList;
    }

    public void updateTileEntityChunkAndSendToPlayer(int i2, int j2, int k2, TileEntity tileentity) {
        if (this.blockExists(i2, j2, k2)) {
            this.getChunkFromBlockCoords(i2, k2).setChunkModified();
        }
        for (int l2 = 0; l2 < this.worldAccesses.size(); ++l2) {
            this.worldAccesses.get(l2).sendTileEntityToPlayer(i2, j2, k2, tileentity);
        }
    }

    public int countEntities(Class class1) {
        int i2 = 0;
        for (int j2 = 0; j2 < this.loadedEntityList.size(); ++j2) {
            Entity entity = this.loadedEntityList.get(j2);
            if (!class1.isAssignableFrom(entity.getClass())) continue;
            ++i2;
        }
        return i2;
    }

    public void addLoadedEntities(List list) {
        this.loadedEntityList.addAll(list);
        for (int i2 = 0; i2 < list.size(); ++i2) {
            this.obtainEntitySkin((Entity)list.get(i2));
        }
    }

    public void unloadEntities(List list) {
        this.unloadedEntityList.addAll(list);
    }

    public void dropOldChunks() {
        while (this.chunkProvider.unload100OldestChunks()) {
        }
    }

    public boolean canBlockBePlacedAt(int i2, int j2, int k2, int l2, boolean flag, int i1) {
        int j1 = this.getBlockId(j2, k2, l2);
        Block block = Block.blocksList[j1];
        Block block1 = Block.blocksList[i2];
        AxisAlignedBB axisalignedbb = block1.getCollisionBoundingBoxFromPool(this, j2, k2, l2);
        if (flag) {
            axisalignedbb = null;
        }
        if (axisalignedbb != null && !this.checkIfAABBIsClear(axisalignedbb)) {
            return false;
        }
        if (block != null && block.placeOverwrites) {
            block = null;
        }
        return i2 > 0 && block == null && block1.canPlaceBlockOnSide(this, j2, k2, l2, i1);
    }

    public PathEntity getPathToEntity(Entity entity, Entity entity1, float f2) {
        int i2 = MathHelper.floor_double(entity.posX);
        int j2 = MathHelper.floor_double(entity.posY);
        int k2 = MathHelper.floor_double(entity.posZ);
        int l2 = (int)(f2 + 16.0f);
        int i1 = i2 - l2;
        int j1 = j2 - l2;
        int k1 = k2 - l2;
        int l1 = i2 + l2;
        int i22 = j2 + l2;
        int j22 = k2 + l2;
        ChunkCache chunkcache = new ChunkCache(this, i1, j1, k1, l1, i22, j22);
        return new Pathfinder(chunkcache).createEntityPathTo(entity, entity1, f2);
    }

    public PathEntity getEntityPathToXYZ(Entity entity, int i2, int j2, int k2, float f2) {
        int l2 = MathHelper.floor_double(entity.posX);
        int i1 = MathHelper.floor_double(entity.posY);
        int j1 = MathHelper.floor_double(entity.posZ);
        int k1 = (int)(f2 + 8.0f);
        int l1 = l2 - k1;
        int i22 = i1 - k1;
        int j22 = j1 - k1;
        int k22 = l2 + k1;
        int l22 = i1 + k1;
        int i3 = j1 + k1;
        ChunkCache chunkcache = new ChunkCache(this, l1, i22, j22, k22, l22, i3);
        return new Pathfinder(chunkcache).createEntityPathTo(entity, i2, j2, k2, f2);
    }

    public boolean isBlockProvidingPowerTo(int i2, int j2, int k2, int l2) {
        int i1 = this.getBlockId(i2, j2, k2);
        if (i1 == 0) {
            return false;
        }
        return Block.blocksList[i1].isIndirectlyPoweringTo(this, i2, j2, k2, l2);
    }

    public boolean isBlockGettingPowered(int i2, int j2, int k2) {
        if (this.isBlockProvidingPowerTo(i2, j2 - 1, k2, 0)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(i2, j2 + 1, k2, 1)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(i2, j2, k2 - 1, 2)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(i2, j2, k2 + 1, 3)) {
            return true;
        }
        if (this.isBlockProvidingPowerTo(i2 - 1, j2, k2, 4)) {
            return true;
        }
        return this.isBlockProvidingPowerTo(i2 + 1, j2, k2, 5);
    }

    public boolean isBlockIndirectlyProvidingPowerTo(int i2, int j2, int k2, int l2) {
        int i1 = this.getBlockId(i2, j2, k2);
        if (this.isBlockNormalCube(i2, j2, k2) && i1 != Block.blockRedstone.blockID) {
            return this.isBlockGettingPowered(i2, j2, k2);
        }
        if (i1 == 0) {
            return false;
        }
        return Block.blocksList[i1].isPoweringTo(this, i2, j2, k2, l2);
    }

    public boolean isBlockIndirectlyGettingPowered(int i2, int j2, int k2) {
        if (this.isBlockIndirectlyProvidingPowerTo(i2, j2 - 1, k2, 0)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i2, j2 + 1, k2, 1)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i2, j2, k2 - 1, 2)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i2, j2, k2 + 1, 3)) {
            return true;
        }
        if (this.isBlockIndirectlyProvidingPowerTo(i2 - 1, j2, k2, 4)) {
            return true;
        }
        return this.isBlockIndirectlyProvidingPowerTo(i2 + 1, j2, k2, 5);
    }

    public EntityPlayer getClosestPlayerToEntity(Entity entity, double d2) {
        return this.getClosestPlayer(entity.posX, entity.posY, entity.posZ, d2);
    }

    public EntityPlayer getClosestPlayer(double d2, double d1, double d22, double d3) {
        double d4 = -1.0;
        EntityPlayer entityplayer = null;
        for (int i2 = 0; i2 < this.players.size(); ++i2) {
            EntityPlayer entityplayer1 = this.players.get(i2);
            double d5 = entityplayer1.getDistanceSq(d2, d1, d22);
            if (!(d3 < 0.0) && !(d5 < d3 * d3) || d4 != -1.0 && !(d5 < d4)) continue;
            d4 = d5;
            entityplayer = entityplayer1;
        }
        return entityplayer;
    }

    public EntityPlayer getPlayerEntityByName(String s2) {
        for (int i2 = 0; i2 < this.players.size(); ++i2) {
            if (!s2.equals(this.players.get((int)i2).username)) continue;
            return this.players.get(i2);
        }
        return null;
    }

    public void setChunkData(int x2, int y2, int z2, int width, int height, int length, byte[] abyte0) {
        int minChunkX = x2 >> 4;
        int minChunkZ = z2 >> 4;
        int maxChunkX = x2 + width - 1 >> 4;
        int maxChunkZ = z2 + length - 1 >> 4;
        int startIndex = 0;
        int minY = y2;
        int maxY = y2 + height;
        if (minY < 0) {
            minY = 0;
        }
        if (maxY > net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS) {
            maxY = net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS;
        }
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            int minX = x2 - chunkX * 16;
            int maxX = x2 + width - chunkX * 16;
            if (minX < 0) {
                minX = 0;
            }
            if (maxX > 16) {
                maxX = 16;
            }
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                int minZ = z2 - chunkZ * 16;
                int maxZ = z2 + length - chunkZ * 16;
                if (minZ < 0) {
                    minZ = 0;
                }
                if (maxZ > 16) {
                    maxZ = 16;
                }
                startIndex = this.getChunkFromChunkCoords(chunkX, chunkZ).setChunkData(abyte0, minX, minY, minZ, maxX, maxY, maxZ, startIndex);
                this.markBlocksDirty(chunkX * 16 + minX, minY, chunkZ * 16 + minZ, chunkX * 16 + maxX, maxY, chunkZ * 16 + maxZ);
            }
        }
    }

    public byte[] getChunkData(int x2, int y2, int z2, int width, int height, int length) {
        byte[] abyte0 = new byte[width * height * length * 8 / 2];
        int minChunkX = x2 >> 4;
        int minChunkZ = z2 >> 4;
        int maxChunkX = x2 + width - 1 >> 4;
        int maxChunkZ = z2 + length - 1 >> 4;
        int startIndex = 0;
        int minY = y2;
        int maxY = y2 + height;
        if (minY < 0) {
            minY = 0;
        }
        if (maxY > net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS) {
            maxY = net.minecraft.shared.Minecraft.WORLD_HEIGHT_BLOCKS;
        }
        for (int chunkX = minChunkX; chunkX <= maxChunkX; ++chunkX) {
            int minX = x2 - chunkX * 16;
            int maxX = x2 + width - chunkX * 16;
            if (minX < 0) {
                minX = 0;
            }
            if (maxX > 16) {
                maxX = 16;
            }
            for (int chunkZ = minChunkZ; chunkZ <= maxChunkZ; ++chunkZ) {
                int minZ = z2 - chunkZ * 16;
                int maxZ = z2 + length - chunkZ * 16;
                if (minZ < 0) {
                    minZ = 0;
                }
                if (maxZ > 16) {
                    maxZ = 16;
                }
                startIndex = this.getChunkFromChunkCoords(chunkX, chunkZ).getChunkData(abyte0, minX, minY, minZ, maxX, maxY, maxZ, startIndex);
            }
        }
        return abyte0;
    }

    public void sendQuittingDisconnectingPacket() {
    }

    public void checkSessionLock() {
        this.saveHandler.checkSessionLock();
    }

    public void setWorldTime(long l2) {
        this.worldInfo.setWorldTime(l2);
    }

    public void setWorldTimeUpdateTicks(long l2) {
        long l1 = l2 - this.worldInfo.getWorldTime();
        for (NextTickListEntry nextticklistentry : this.scheduledTickSet) {
            nextticklistentry.scheduledTime += l1;
        }
        this.setWorldTime(l2);
    }

    public long getRandomSeed() {
        return this.worldInfo.getRandomSeed();
    }

    public long getWorldTime() {
        return this.worldInfo.getWorldTime();
    }

    public ChunkCoordinates getSpawnPoint() {
        return new ChunkCoordinates(this.worldInfo.getSpawnX(), this.worldInfo.getSpawnY(), this.worldInfo.getSpawnZ());
    }

    public void setSpawnPoint(ChunkCoordinates chunkcoordinates) {
        this.worldInfo.setSpawn(chunkcoordinates.x, chunkcoordinates.y, chunkcoordinates.z);
    }

    public void joinEntityInSurroundings(Entity entity) {
        int i2 = MathHelper.floor_double(entity.posX / 16.0);
        int j2 = MathHelper.floor_double(entity.posZ / 16.0);
        int byte0 = 2;
        for (int k2 = i2 - byte0; k2 <= i2 + byte0; ++k2) {
            for (int l2 = j2 - byte0; l2 <= j2 + byte0; ++l2) {
                this.getChunkFromChunkCoords(k2, l2);
            }
        }
        if (!this.loadedEntityList.contains(entity)) {
            this.loadedEntityList.add(entity);
        }
    }

    public boolean canMineBlock(EntityPlayer entityplayer, int i2, int j2, int k2) {
        return true;
    }

    public void sendTrackedEntityStatusUpdatePacket(Entity entityId, byte entityStatus) {
    }

    public void sendTrackedEntityStatusUpdatePacket(Entity entityId, byte entityStatus, float attackedAtYaw) {
    }

    public void updateEntityList() {
        this.loadedEntityList.removeAll(this.unloadedEntityList);
        for (int i2 = 0; i2 < this.unloadedEntityList.size(); ++i2) {
            Entity entity = this.unloadedEntityList.get(i2);
            int l2 = entity.chunkCoordX;
            int j1 = entity.chunkCoordZ;
            if (!entity.addedToChunk || !this.chunkExists(l2, j1)) continue;
            this.getChunkFromChunkCoords(l2, j1).removeEntity(entity);
        }
        for (int j2 = 0; j2 < this.unloadedEntityList.size(); ++j2) {
            this.releaseEntitySkin(this.unloadedEntityList.get(j2));
        }
        this.unloadedEntityList.clear();
        for (int k2 = 0; k2 < this.loadedEntityList.size(); ++k2) {
            Entity entity1 = this.loadedEntityList.get(k2);
            if (entity1.ridingEntity != null) {
                if (!entity1.ridingEntity.isDead && entity1.ridingEntity.riddenByEntity == entity1) continue;
                entity1.ridingEntity.riddenByEntity = null;
                entity1.ridingEntity = null;
            }
            if (!entity1.isDead) continue;
            int i1 = entity1.chunkCoordX;
            int k1 = entity1.chunkCoordZ;
            if (entity1.addedToChunk && this.chunkExists(i1, k1)) {
                this.getChunkFromChunkCoords(i1, k1).removeEntity(entity1);
            }
            this.loadedEntityList.remove(k2--);
            this.releaseEntitySkin(entity1);
        }
    }

    public IChunkProvider getIChunkProvider() {
        return this.chunkProvider;
    }

    public void playNoteAt(int x2, int y2, int z2, int instrument, int pitch) {
        int j1 = this.getBlockId(x2, y2, z2);
        if (j1 > 0) {
            Block.blocksList[j1].playBlock(this, x2, y2, z2, instrument, pitch);
        }
    }

    public ISaveHandler getSaveHandler() {
        return this.saveHandler;
    }

    public WorldInfo getWorldInfo() {
        return this.worldInfo;
    }

    public void updateEnoughPlayersSleepingFlag(EntityPlayer player) {
        this.enoughPlayersSleeping = false;
        if (this.players.size() > 0) {
            int playersSleeping = 0;
            int req = this.getPlayersRequiredToSkipNight();
            for (EntityPlayer p2 : this.players) {
                if (!p2.sleeping) continue;
                ++playersSleeping;
            }
            if (playersSleeping >= req) {
                this.enoughPlayersSleeping = true;
            }
            if (MinecraftServer.getInstance() != null && player != null && this.players.size() > 1 && req > 1) {
                int moreReq = req - playersSleeping;
                if (player.sleeping) {
                    MinecraftServer.getInstance().configManager.sendPacketToAllPlayersInDimension(new Packet3Chat(ChatColor.yellow + player.username + ChatColor.orange + " went to bed."), this.dimension.dimId);
                } else {
                    MinecraftServer.getInstance().configManager.sendPacketToAllPlayersInDimension(new Packet3Chat(ChatColor.yellow + player.username + ChatColor.orange + " has left their bed."), this.dimension.dimId);
                }
                if (moreReq > 0) {
                    if (moreReq > 1) {
                        MinecraftServer.getInstance().configManager.sendPacketToAllPlayersInDimension(new Packet3Chat(ChatColor.lightGray + "" + moreReq + " more players are required to sleep to skip to daytime"), this.dimension.dimId);
                    } else {
                        MinecraftServer.getInstance().configManager.sendPacketToAllPlayersInDimension(new Packet3Chat(ChatColor.lightGray + "1 more player is required to sleep to skip to daytime"), this.dimension.dimId);
                    }
                }
            }
        }
    }

    public int getPlayersRequiredToSkipNight() {
        return (int)((double)this.players.size() * ((double)this.sleepPercent / 100.0));
    }

    protected void wakeUpAllPlayers() {
        this.enoughPlayersSleeping = false;
        for (EntityPlayer entityplayer : this.players) {
            if (!entityplayer.isPlayerSleeping()) continue;
            entityplayer.wakeUpPlayer(false, false);
        }
        if (this.currentWeather != null && this.currentWeather.spawnRainParticles) {
            this.newWeather = Weather.weatherClear;
        }
    }

    public boolean areEnoughPlayersFullyAsleep() {
        if (this.enoughPlayersSleeping && !this.isMultiplayerAndNotHost) {
            int fullyAsleep = 0;
            for (EntityPlayer player : this.players) {
                if (!player.isPlayerFullyAsleep()) continue;
                ++fullyAsleep;
            }
            return fullyAsleep >= this.getPlayersRequiredToSkipNight() && fullyAsleep > 0;
        }
        return false;
    }

    public boolean canBlockBeRainedOn(int i2, int j2, int k2) {
        if (this.currentWeather == null) {
            return false;
        }
        if (!this.currentWeather.isPrecipitation) {
            return false;
        }
        if (!this.canBlockSeeTheSky(i2, j2, k2)) {
            return false;
        }
        if (this.getHeightValue(i2, k2) > j2) {
            return false;
        }
        BiomeGenBase biomegenbase = this.getWorldChunkManager().getBiomeGenAt(i2, k2);
        for (int q2 = 0; q2 < biomegenbase.blockedWeathers.length; ++q2) {
            if (biomegenbase.blockedWeathers[q2] != this.currentWeather) continue;
            return false;
        }
        return true;
    }

    public void setItemData(String s2, MapDataBase mapdatabase) {
        this.mapStorage.setData(s2, mapdatabase);
    }

    public MapDataBase loadItemData(Class class1, String s2) {
        return this.mapStorage.loadData(class1, s2);
    }

    public int getUniqueDataId(String s2) {
        return this.mapStorage.getUniqueDataId(s2);
    }

    public void playSoundEffect(int id2, int x2, int y2, int z2, int data) {
        this.playSoundEffectForPlayer(null, id2, x2, y2, z2, data);
    }

    public void playSoundEffectForPlayer(EntityPlayer entityplayer, int i2, int j2, int k2, int l2, int i1) {
        for (int j1 = 0; j1 < this.worldAccesses.size(); ++j1) {
            this.worldAccesses.get(j1).playSoundEffectForPlayer(entityplayer, i2, j2, k2, l2, i1);
        }
    }

    public WorldType getWorldType() {
        return WorldType.get(this.worldInfo.getWorldType(this.dimension.dimId));
    }

    public void dropItem(int x2, int y2, int z2, ItemStack itemStack) {
        float f2 = 0.7f;
        double x1 = (double)(this.rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
        double y1 = (double)(this.rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
        double z1 = (double)(this.rand.nextFloat() * f2) + (double)(1.0f - f2) * 0.5;
        EntityItem entityitem = new EntityItem(this, (double)x2 + x1, (double)y2 + y1, (double)z2 + z1, itemStack);
        entityitem.delayBeforeCanPickup = 10;
        this.entityJoinedWorld(entityitem);
    }
}

