/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.ChunkCoordIntPair;
import net.minecraft.src.NoiseGeneratorOctaves2;
import net.minecraft.src.World;

public class WorldChunkManager {
    protected NoiseGeneratorOctaves2 field_4194_e;
    protected NoiseGeneratorOctaves2 field_4193_f;
    protected NoiseGeneratorOctaves2 field_4192_g;
    public double[] temperature;
    public double[] humidity;
    public double[] biomeTemperature;
    public double[] biomeHumidity;
    public double[] fuzziness;
    public BiomeGenBase[] field_4195_d;
    protected World worldObj;

    protected WorldChunkManager() {
    }

    public WorldChunkManager(World world) {
        this.worldObj = world;
        this.field_4194_e = new NoiseGeneratorOctaves2(new Random(world.getRandomSeed() * 9871L), 4);
        this.field_4193_f = new NoiseGeneratorOctaves2(new Random(world.getRandomSeed() * 39811L), 4);
        this.field_4192_g = new NoiseGeneratorOctaves2(new Random(world.getRandomSeed() * 543321L), 2);
    }

    public BiomeGenBase getBiomeGenAtChunkCoord(ChunkCoordIntPair chunkcoordintpair) {
        return this.getBiomeGenAt(chunkcoordintpair.chunkXPos << 4, chunkcoordintpair.chunkZPos << 4);
    }

    public BiomeGenBase getBiomeGenAt(int i2, int j2) {
        BiomeGenBase b2 = this.worldObj.getBlockBiome(i2, j2);
        if (b2 == null) {
            b2 = this.func_4069_a(i2, j2, 1, 1)[0];
            this.worldObj.setBlockBiome(i2, j2, b2);
        }
        return b2;
    }

    public double getTemperature(int i2, int j2) {
        double t2 = this.worldObj.getBlockTemperature(i2, j2);
        if (t2 == Double.NEGATIVE_INFINITY) {
            this.func_4069_a(i2, j2, 1, 1);
            t2 = this.temperature[0];
            this.worldObj.setBlockTemperature(i2, j2, t2);
        }
        return t2;
    }

    public double getHumidity(int i2, int j2) {
        double h2 = this.worldObj.getBlockHumidity(i2, j2);
        if (h2 == Double.NEGATIVE_INFINITY) {
            this.func_4069_a(i2, j2, 1, 1);
            h2 = this.humidity[0];
            this.worldObj.setBlockHumidity(i2, j2, h2);
        }
        return h2;
    }

    public BiomeGenBase[] func_4069_a(int i2, int j2, int k2, int l2) {
        this.field_4195_d = this.loadBlockGeneratorData(this.field_4195_d, i2, j2, k2, l2);
        return this.field_4195_d;
    }

    public double[] getTemperatures(double[] ad2, int i2, int j2, int k2, int l2) {
        if (ad2 == null || ad2.length < k2 * l2) {
            ad2 = new double[k2 * l2];
        }
        int i1 = 0;
        for (int x2 = 0; x2 < k2; ++x2) {
            for (int z2 = 0; z2 < l2; ++z2) {
                ad2[i1++] = this.getTemperature(i2 + x2, j2 + z2);
            }
        }
        return ad2;
    }

    public BiomeGenBase[] updateBlockGeneratorDataFromHeight(BiomeGenBase[] abiomegenbase, int[] heights, int oceanHeight, int maxTerrainHeight, int x2, int y2, int width, int length) {
        if (abiomegenbase == null || abiomegenbase.length < width * length) {
            abiomegenbase = new BiomeGenBase[width * length];
        }
        this.temperature = this.field_4194_e.func_4112_a(this.temperature, x2, y2, width, width, 0.025, 0.025, 0.25);
        this.humidity = this.field_4193_f.func_4112_a(this.humidity, x2, y2, width, width, 0.05, 0.05, 0.3);
        this.biomeTemperature = this.field_4194_e.func_4112_a(this.biomeTemperature, x2, y2, width, width, 0.00625, 0.00625, 0.25);
        this.biomeHumidity = this.field_4193_f.func_4112_a(this.biomeHumidity, x2, y2, width, width, 0.0125, 0.0125, 0.3);
        this.fuzziness = this.field_4192_g.func_4112_a(this.fuzziness, x2, y2, width, length, 0.25, 0.25, 0.5);
        int i1 = 0;
        for (int j1 = 0; j1 < width; ++j1) {
            for (int k1 = 0; k1 < length; ++k1) {
                int terrainHeight = heights[j1 * 16 + k1];
                int aboveOceanHeight = maxTerrainHeight - oceanHeight;
                int aboveOceanTerrainHeight = terrainHeight - oceanHeight;
                float modifier = aboveOceanTerrainHeight <= 0 ? 1.0f : (float)aboveOceanTerrainHeight / (float)aboveOceanHeight;
                double d2 = this.fuzziness[i1] * 1.1 + 0.5;
                double d1 = 0.01;
                double d22 = 1.0 - d1;
                double d3 = (this.temperature[i1] * 0.15 + 0.7) * d22 + d2 * d1;
                d3 *= (double)modifier;
                d1 = 0.002;
                d22 = 1.0 - d1;
                double d4 = (this.humidity[i1] * 0.15 + 0.5) * d22 + d2 * d1;
                d4 *= (double)modifier;
                if ((d3 = 1.0 - (1.0 - d3) * (1.0 - d3)) < 0.0) {
                    d3 = 0.0;
                }
                if (d4 < 0.0) {
                    d4 = 0.0;
                }
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                if (d4 > 1.0) {
                    d4 = 1.0;
                }
                this.temperature[i1] = d3;
                this.humidity[i1] = d4;
                abiomegenbase[i1++] = BiomeGenBase.getBiomeFromLookup(d3, d4);
            }
        }
        return abiomegenbase;
    }

    public BiomeGenBase[] loadBlockGeneratorData(BiomeGenBase[] abiomegenbase, int x2, int z2, int width, int length) {
        if (abiomegenbase == null || abiomegenbase.length < width * length) {
            abiomegenbase = new BiomeGenBase[width * length];
        }
        this.temperature = this.field_4194_e.func_4112_a(this.temperature, x2, z2, width, width, 0.025, 0.025, 0.25);
        this.humidity = this.field_4193_f.func_4112_a(this.humidity, x2, z2, width, width, 0.05, 0.05, 0.3);
        this.fuzziness = this.field_4192_g.func_4112_a(this.fuzziness, x2, z2, width, length, 0.25, 0.25, 0.5);
        int i1 = 0;
        for (int j1 = 0; j1 < width; ++j1) {
            for (int k1 = 0; k1 < length; ++k1) {
                double d2 = this.fuzziness[i1] * 1.1 + 0.5;
                double d1 = 0.01;
                double d22 = 1.0 - d1;
                double d3 = (this.temperature[i1] * 0.15 + 0.7) * d22 + d2 * d1;
                d1 = 0.002;
                d22 = 1.0 - d1;
                double d4 = (this.humidity[i1] * 0.15 + 0.5) * d22 + d2 * d1;
                if ((d3 = 1.0 - (1.0 - d3) * (1.0 - d3)) < 0.0) {
                    d3 = 0.0;
                }
                if (d4 < 0.0) {
                    d4 = 0.0;
                }
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                if (d4 > 1.0) {
                    d4 = 1.0;
                }
                this.temperature[i1] = d3;
                this.humidity[i1] = d4;
                abiomegenbase[i1++] = BiomeGenBase.getBiomeFromLookup(d3, d4);
            }
        }
        return abiomegenbase;
    }
}

