/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.World;
import net.minecraft.src.WorldChunkManager;

public class WorldChunkManagerDeeper
extends WorldChunkManager {
    public WorldChunkManagerDeeper(World world) {
        super(world);
    }

    @Override
    public double[] getTemperatures(double[] ad2, int i2, int j2, int k2, int l2) {
        if (ad2 == null || ad2.length < k2 * l2) {
            ad2 = new double[k2 * l2];
        }
        ad2 = this.field_4194_e.func_4112_a(ad2, i2, j2, k2, l2, 0.00625, 0.00625, 0.25);
        this.fuzziness = this.field_4192_g.func_4112_a(this.fuzziness, i2, j2, k2, l2, 8.0, 8.0, 0.025);
        int i1 = 0;
        for (int j1 = 0; j1 < k2; ++j1) {
            for (int k1 = 0; k1 < l2; ++k1) {
                double d2 = this.fuzziness[i1] * 1.1 + 2.5;
                double d1 = 0.01;
                double d22 = 1.0 - d1;
                double d3 = (ad2[i1] * 0.15 + 0.7) * d22 + d2 * d1;
                if ((d3 = 1.0 - (1.0 - d3) * (1.0 - d3)) < 0.0) {
                    d3 = 0.0;
                }
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                ad2[i1] = d3;
                ++i1;
            }
        }
        return ad2;
    }

    @Override
    public BiomeGenBase[] updateBlockGeneratorDataFromHeight(BiomeGenBase[] abiomegenbase, int[] heights, int oceanHeight, int maxTerrainHeight, int x2, int y2, int width, int length) {
        if (abiomegenbase == null || abiomegenbase.length < width * length) {
            abiomegenbase = new BiomeGenBase[width * length];
        }
        this.temperature = this.field_4194_e.func_4112_a(this.temperature, x2, y2, width, width, 0.00625, 0.00625, 0.25);
        this.humidity = this.field_4193_f.func_4112_a(this.humidity, x2, y2, width, width, 0.0125, 0.0125, 0.3);
        this.biomeTemperature = this.field_4194_e.func_4112_a(this.biomeTemperature, x2, y2, width, width, 0.00625, 0.00625, 0.25);
        this.biomeHumidity = this.field_4193_f.func_4112_a(this.biomeHumidity, x2, y2, width, width, 0.0125, 0.0125, 0.3);
        this.fuzziness = this.field_4192_g.func_4112_a(this.fuzziness, x2, y2, width, width, 8.0, 8.0, 0.025);
        int i1 = 0;
        for (int j1 = 0; j1 < width; ++j1) {
            for (int k1 = 0; k1 < length; ++k1) {
                float modifier;
                double d2 = this.fuzziness[i1] * 1.1 + 0.5;
                int terrainHeight = heights[j1 * 16 + k1];
                int aboveOceanTerrainHeight = terrainHeight - oceanHeight;
                int minHeight = 32;
                int maxHeight = 96;
                if (aboveOceanTerrainHeight <= minHeight) {
                    modifier = 1.0f;
                } else if (aboveOceanTerrainHeight >= maxHeight) {
                    modifier = 0.0f;
                } else {
                    float terrain = (float)(aboveOceanTerrainHeight - minHeight) / (float)(maxHeight - minHeight);
                    terrain += (float)(d2 * (double)terrain * (double)0.03f);
                    modifier = 1.0f - terrain;
                }
                double d1 = 0.01;
                double d22 = 1.0 - d1;
                double d3 = (this.temperature[i1] * 0.15 + 0.7) * d22 * (double)modifier + d2 * d1;
                d1 = 0.002;
                d22 = 1.0 - d1;
                double d4 = (this.humidity[i1] * 0.15 + 2.5) * d22 + d2 * d1;
                d3 = 1.0 - (1.0 - d3) * (1.0 - d3);
                if (d3 < 0.0) {
                    d3 = 0.0;
                }
                if (d4 < 0.0) {
                    d4 = 0.0;
                }
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                if (d4 > 1.0) {
                    d4 = 1.0;
                }
                this.temperature[i1] = d3;
                this.humidity[i1] = d4;
                abiomegenbase[i1++] = BiomeGenBase.getBiomeFromLookup(d3, d4);
            }
        }
        return abiomegenbase;
    }

    @Override
    public BiomeGenBase[] loadBlockGeneratorData(BiomeGenBase[] abiomegenbase, int i2, int j2, int width, int height) {
        if (abiomegenbase == null || abiomegenbase.length < width * height) {
            abiomegenbase = new BiomeGenBase[width * height];
        }
        this.temperature = this.field_4194_e.func_4112_a(this.temperature, i2, j2, width, width, 0.00625, 0.00625, 0.25);
        this.humidity = this.field_4193_f.func_4112_a(this.humidity, i2, j2, width, width, 0.0125, 0.0125, 0.3);
        this.fuzziness = this.field_4192_g.func_4112_a(this.fuzziness, i2, j2, width, width, 8.0, 8.0, 0.025);
        int i1 = 0;
        for (int j1 = 0; j1 < width; ++j1) {
            for (int k1 = 0; k1 < height; ++k1) {
                double d2 = this.fuzziness[i1] * 1.1 + 0.25;
                double d1 = 0.01;
                double d22 = 1.0 - d1;
                double d3 = (this.temperature[i1] * 0.15 + 0.7) * d22 + d2 * d1;
                d1 = 0.01;
                d22 = 1.0 - d1;
                double d4 = (this.humidity[i1] * 0.15 + 0.5) * d22 + d2 * d1;
                if ((d3 = 1.0 - (1.0 - d3) * (1.0 - d3)) < 0.0) {
                    d3 = 0.0;
                }
                if (d4 < 0.0) {
                    d4 = 0.0;
                }
                if (d3 > 1.0) {
                    d3 = 1.0;
                }
                if (d4 > 1.0) {
                    d4 = 1.0;
                }
                this.temperature[i1] = d3;
                this.humidity[i1] = d4;
                abiomegenbase[i1++] = BiomeGenBase.getBiomeFromLookup(d3, d4);
            }
        }
        return abiomegenbase;
    }
}

