/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.Block;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.TileEntityChest;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenerator;

public class WorldGenFlotsam
extends WorldGenerator {
    @Override
    public boolean generate(World world, Random random, int x2, int y2, int z2) {
        int blockId;
        int val;
        int rz2;
        int rx2;
        int topYUnderwater;
        int topY = world.findTopSolidBlock(x2, z2) - 1;
        if (topY == (topYUnderwater = world.findTopSolidNonLiquidBlock(x2, z2) - 1)) {
            return false;
        }
        if (topY < topYUnderwater + 4) {
            return false;
        }
        for (rx2 = -8; rx2 <= 8; ++rx2) {
            for (rz2 = -8; rz2 <= 8; ++rz2) {
                int r2 = 256;
                if (rx2 < -5 || rx2 > 5 || rz2 < -5 || rz2 > 5) {
                    r2 *= 3;
                }
                val = random.nextInt(r2);
                blockId = 0;
                if (val < 16) {
                    blockId = Block.planksOak.blockID;
                } else if (val < 20) {
                    blockId = Block.logOak.blockID;
                } else if (val < 22) {
                    blockId = Block.glass.blockID;
                } else if (val < 26) {
                    blockId = Block.wool.blockID;
                } else if (val < 28) {
                    blockId = Block.bookshelfPlanksOak.blockID;
                } else if (val < 29) {
                    blockId = Block.workbench.blockID;
                } else if (val < 30) {
                    blockId = Block.jukebox.blockID;
                }
                if (blockId == 0) continue;
                world.setBlockWithNotify(x2 + rx2, topY, z2 + rz2, blockId);
            }
        }
        for (rx2 = -8; rx2 <= 8; ++rx2) {
            for (rz2 = -8; rz2 <= 8; ++rz2) {
                int id2 = world.getBlockId(x2 + rx2, topY, z2 + rz2);
                if (id2 == Block.fluidWaterStill.blockID || id2 == Block.fluidWaterFlowing.blockID) continue;
                val = random.nextInt(32);
                blockId = 0;
                if (val < 1) {
                    blockId = Block.stairsPlanksOak.blockID;
                } else if (val >= 2) {
                    if (val < 3) {
                        blockId = Block.torchCoal.blockID;
                    } else if (val < 4) {
                        blockId = Block.fencePlanksOak.blockID;
                    } else if (val >= 5) {
                        if (val < 6) {
                            blockId = Block.pressureplateStone.blockID;
                        } else if (val < 7) {
                            blockId = Block.pressureplatePlanksOak.blockID;
                        } else if (val < 8) {
                            blockId = Block.pressureplateCobbleStone.blockID;
                        } else if (val < 9) {
                            blockId = Block.torchRedstoneActive.blockID;
                        }
                    }
                }
                if (blockId == 0) continue;
                world.setBlockWithNotify(x2 + rx2, topY + 1, z2 + rz2, blockId);
            }
        }
        int chestX = x2 + (random.nextInt(16) - 8);
        int chestZ = z2 + (random.nextInt(16) - 8);
        world.setBlockWithNotify(chestX, topY, chestZ, Block.chestPlanksOak.blockID);
        this.doChestLoot((TileEntityChest)world.getBlockTileEntity(chestX, topY, chestZ), random);
        return true;
    }

    protected void doChestLoot(TileEntityChest entity, Random random) {
        for (int count = 0; count < 8; ++count) {
            ItemStack itemstack = this.pickChestLootItem(random);
            if (itemstack == null) continue;
            entity.setInventorySlotContents(random.nextInt(entity.getSizeInventory()), itemstack);
        }
    }

    private ItemStack pickChestLootItem(Random random) {
        int i2 = random.nextInt(14);
        if (i2 == 0) {
            return new ItemStack(Item.saddle);
        }
        if (i2 == 1) {
            return new ItemStack(Item.ingotIron, random.nextInt(4) + 1);
        }
        if (i2 == 2) {
            return new ItemStack(Item.foodBread);
        }
        if (i2 == 3) {
            return new ItemStack(Item.wheat, random.nextInt(4) + 1);
        }
        if (i2 == 4) {
            return new ItemStack(Item.sulphur, random.nextInt(4) + 1);
        }
        if (i2 == 5) {
            return new ItemStack(Item.string, random.nextInt(4) + 1);
        }
        if (i2 == 6) {
            return new ItemStack(Item.bucket);
        }
        if (i2 == 7 && random.nextInt(100) == 0) {
            return new ItemStack(Item.foodAppleGold);
        }
        if (i2 == 8 && random.nextInt(2) == 0) {
            return new ItemStack(Item.dustRedstone, random.nextInt(4) + 1);
        }
        if (i2 == 9 && random.nextInt(10) == 0) {
            return new ItemStack(Item.itemsList[Item.record13.itemID + random.nextInt(9)]);
        }
        if (i2 == 10) {
            return new ItemStack(Item.dye, 1, 3);
        }
        if (i2 == 11) {
            return new ItemStack(Item.itemsList[Block.spongeDry.blockID], random.nextInt(4) + 1);
        }
        if (i2 == 12) {
            return new ItemStack(Item.bone, random.nextInt(4) + 1);
        }
        if (i2 == 13) {
            return new ItemStack(Item.foodApple);
        }
        return null;
    }
}

