/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.Material;
import net.minecraft.src.TileEntityChest;
import net.minecraft.src.TileEntityDispenser;
import net.minecraft.src.TileEntityMobSpawner;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenerator;

public class WorldGenLabyrinth
extends WorldGenerator {
    int dungeonSize = 0;
    int dungeonLimit;
    int dungeonCount = 0;
    boolean treasureGenerated = false;
    boolean libraryGenerated = false;
    int wallBlockA;
    int wallBlockB;
    int brickBlockA;
    int brickBlockB;
    int slabBlock;

    public WorldGenLabyrinth() {
        this.wallBlockA = Block.cobbleStone.blockID;
        this.wallBlockB = Block.cobbleStoneMossy.blockID;
        this.brickBlockA = Block.brickStonePolished.blockID;
        this.brickBlockB = Block.brickStonePolishedMossy.blockID;
        this.slabBlock = Block.slabStonePolished.blockID;
    }

    @Override
    public boolean generate(World world, Random random, int blockX, int blockY, int blockZ) {
        BiomeGenBase biome = world.getWorldChunkManager().getBiomeGenAt(blockX, blockZ);
        if (biome == BiomeGenBase.desert || biome == BiomeGenBase.outback) {
            this.wallBlockA = Block.sandstone.blockID;
            this.wallBlockB = Block.sandstone.blockID;
            this.brickBlockA = Block.brickSandstone.blockID;
            this.brickBlockB = Block.brickSandstone.blockID;
            this.slabBlock = Block.slabSandstone.blockID;
        }
        if (this.canReplace(world, blockX, blockY, blockZ)) {
            this.dungeonLimit = 1;
            this.generateBranch(world, random, blockX, blockY, blockZ);
            return true;
        }
        return false;
    }

    public void generateBranch(World world, Random random, int blockX, int blockY, int blockZ) {
        boolean generateTrapOnWall = false;
        for (int x2 = blockX - 2; x2 <= blockX + 2; ++x2) {
            boolean xWallCheck = x2 == blockX - 2 || x2 == blockX + 2;
            for (int y2 = blockY - 2; y2 <= blockY + 1; ++y2) {
                boolean yWallCheck = y2 == blockY - 2;
                for (int z2 = blockZ - 2; z2 <= blockZ + 2; ++z2) {
                    boolean zWallCheck;
                    boolean bl2 = zWallCheck = z2 == blockZ - 2 || z2 == blockZ + 2;
                    if (!this.canReplace(world, x2, y2, z2)) continue;
                    if (xWallCheck && zWallCheck) {
                        world.setBlockWithNotify(x2, y2, z2, random.nextInt(4) == 0 ? this.brickBlockB : this.brickBlockA);
                    } else if (xWallCheck || zWallCheck) {
                        world.setBlockWithNotify(x2, y2, z2, this.wallBlockB);
                    } else if (yWallCheck) {
                        world.setBlockWithNotify(x2, y2, z2, this.wallBlockB);
                    } else {
                        world.setBlockWithNotify(x2, y2, z2, 0);
                    }
                    if (generateTrapOnWall || !xWallCheck && !zWallCheck || x2 != blockZ && z2 != blockZ || y2 != blockY) continue;
                    world.setBlockWithNotify(x2, y2, z2, Block.motionsensorIdle.blockID);
                    world.setBlockWithNotify(x2, y2 - 1, z2, Block.dispenserCobbleStone.blockID);
                    TileEntityDispenser tileEntityDispenser = (TileEntityDispenser)world.getBlockTileEntity(x2, blockY - 1, z2);
                    for (int k4 = 0; k4 < 3; ++k4) {
                        ItemStack itemstack = this.pickDispenserLootItem(random);
                        if (itemstack == null) continue;
                        tileEntityDispenser.setInventorySlotContents(random.nextInt(tileEntityDispenser.getSizeInventory()), itemstack);
                    }
                    generateTrapOnWall = true;
                }
            }
        }
        if (this.dungeonSize < 10) {
            ++this.dungeonSize;
            int corridorsToSpawn = random.nextInt(4);
            for (int i2 = 0; i2 <= corridorsToSpawn; ++i2) {
                this.createCorridor(world, random, blockX, blockY, blockZ, random.nextInt(4), 0);
            }
        }
    }

    public void generateDrop(World world, Random random, int blockX, int blockY, int blockZ) {
        if (random.nextBoolean()) {
            this.generateDungeon(world, random, blockX, blockY, blockZ, false);
        }
        int dropHeight = random.nextInt(10) + 10;
        for (int x2 = blockX - 2; x2 <= blockX + 2; ++x2) {
            for (int y2 = blockY - dropHeight; y2 <= blockY + 1; ++y2) {
                for (int z2 = blockZ - 2; z2 <= blockZ + 2; ++z2) {
                    boolean yWallCheck;
                    boolean xWallCheck = x2 == blockX - 2 || x2 == blockX + 2;
                    boolean zWallCheck = z2 == blockZ - 2 || z2 == blockZ + 2;
                    boolean bl2 = yWallCheck = y2 == blockY - dropHeight;
                    if (!this.canReplace(world, x2, y2, z2)) continue;
                    if (xWallCheck || zWallCheck) {
                        world.setBlockWithNotify(x2, y2, z2, this.wallBlockB);
                        continue;
                    }
                    if (yWallCheck) {
                        world.setBlockWithNotify(x2, y2, z2, this.wallBlockB);
                        if (this.dungeonSize < 10) continue;
                        world.setBlockWithNotify(x2, y2 + 1, z2, Block.spikes.blockID);
                        continue;
                    }
                    if (x2 != blockX && z2 != blockZ && random.nextInt(20) == 0 && world.getBlockId(x2, y2 + 1, z2) != this.slabBlock) {
                        world.setBlockWithNotify(x2, y2, z2, this.slabBlock);
                        continue;
                    }
                    world.setBlockWithNotify(x2, y2, z2, 0);
                }
            }
        }
        if (this.dungeonSize < 10) {
            ++this.dungeonSize;
            int corridorsToSpawn = random.nextInt(4) + 1;
            for (int i2 = 1; i2 <= corridorsToSpawn; ++i2) {
                this.createCorridor(world, random, blockX, blockY - (dropHeight - 2), blockZ, random.nextInt(4), 0);
            }
        }
    }

    private boolean canReplace(World world, int x2, int y2, int z2) {
        if (y2 <= 11) {
            return false;
        }
        if (world.getBlockId(x2, y2, z2) == this.brickBlockA || world.getBlockId(x2, y2, z2) == Block.planksOak.blockID || world.getBlockId(x2, y2, z2) == Block.cobweb.blockID || world.getBlockId(x2, y2, z2) == Block.bookshelfPlanksOak.blockID || world.getBlockId(x2, y2, z2) == Block.mobspawner.blockID || world.getBlockId(x2, y2, z2) == this.brickBlockB) {
            return false;
        }
        if (world.getBlockId(x2, y2, z2) == Block.motionsensorIdle.blockID || world.getBlockId(x2, y2, z2) == Block.dispenserCobbleStone.blockID || world.getBlockId(x2, y2, z2) == Block.motionsensorActive.blockID) {
            world.removeBlockTileEntity(x2, y2, z2);
            world.setBlockWithNotify(x2, y2, z2, 0);
            return true;
        }
        return world.getBlockMaterial(x2, y2, z2) == Material.grass || world.getBlockMaterial(x2, y2, z2) == Material.ground || world.getBlockMaterial(x2, y2, z2) == Material.rock || world.getBlockMaterial(x2, y2, z2) == Material.sand || world.getBlockMaterial(x2, y2, z2) == Material.moss;
    }

    private void generateCorridor(World world, Random random, int blockX, int blockY, int blockZ, int rot, int corridorIteration) {
        int height = 2;
        int width = 2;
        int length = 2;
        for (int x2 = blockX - width; x2 <= blockX + width; ++x2) {
            boolean xWallCheck = x2 == blockX - width || x2 == blockX + width;
            for (int y2 = blockY - height; y2 <= blockY + (height - 1); ++y2) {
                boolean yWallCheck = y2 == blockY - height;
                for (int z2 = blockZ - length; z2 <= blockZ + length; ++z2) {
                    boolean zWallCheck;
                    boolean bl2 = zWallCheck = z2 == blockZ - length || z2 == blockZ + length;
                    if (!this.canReplace(world, x2, y2, z2) || (xWallCheck || zWallCheck || yWallCheck) && world.getBlockId(x2, y2 + 1, z2) == 0 && random.nextInt(3) > 0) continue;
                    if (rot == 0) {
                        if (xWallCheck) {
                            world.setBlockWithNotify(x2, y2, z2, this.wallBlockA);
                        } else if (z2 == blockZ + length) {
                            world.setBlockWithNotify(x2, y2, z2, this.wallBlockA);
                        } else if (yWallCheck) {
                            if (random.nextInt(3) == 0) {
                                world.setBlockWithNotify(x2, y2, z2, this.wallBlockB);
                            } else {
                                world.setBlockWithNotify(x2, y2, z2, this.wallBlockA);
                            }
                        } else {
                            world.setBlockWithNotify(x2, y2, z2, 0);
                        }
                    } else if (rot == 1) {
                        if (x2 == blockX - width) {
                            world.setBlockWithNotify(x2, y2, z2, this.wallBlockA);
                        } else if (zWallCheck) {
                            world.setBlockWithNotify(x2, y2, z2, this.wallBlockA);
                        } else if (yWallCheck) {
                            if (random.nextInt(3) == 0) {
                                world.setBlockWithNotify(x2, y2, z2, this.wallBlockB);
                            } else {
                                world.setBlockWithNotify(x2, y2, z2, this.wallBlockA);
                            }
                        } else {
                            world.setBlockWithNotify(x2, y2, z2, 0);
                        }
                    } else if (rot == 2) {
                        if (xWallCheck) {
                            world.setBlockWithNotify(x2, y2, z2, this.wallBlockA);
                        } else if (z2 == blockZ - length) {
                            world.setBlockWithNotify(x2, y2, z2, this.wallBlockA);
                        } else if (yWallCheck) {
                            if (random.nextInt(3) == 0) {
                                world.setBlockWithNotify(x2, y2, z2, this.wallBlockB);
                            } else {
                                world.setBlockWithNotify(x2, y2, z2, this.wallBlockA);
                            }
                        } else {
                            world.setBlockWithNotify(x2, y2, z2, 0);
                        }
                    } else if (x2 == blockX + width) {
                        world.setBlockWithNotify(x2, y2, z2, this.wallBlockA);
                    } else if (zWallCheck) {
                        world.setBlockWithNotify(x2, y2, z2, this.wallBlockA);
                    } else if (yWallCheck) {
                        if (random.nextInt(3) == 0) {
                            world.setBlockWithNotify(x2, y2, z2, this.wallBlockB);
                        } else {
                            world.setBlockWithNotify(x2, y2, z2, this.wallBlockA);
                        }
                    } else {
                        world.setBlockWithNotify(x2, y2, z2, 0);
                    }
                    if (y2 != blockY + (height - 1) || zWallCheck || xWallCheck || random.nextInt(20) != 0) continue;
                    world.setBlockWithNotify(x2, y2, z2, Block.cobweb.blockID);
                }
            }
        }
        if (random.nextInt(2) == 0 && corridorIteration > 1) {
            if (random.nextInt(2) == 0) {
                this.generateBranch(world, random, blockX, blockY, blockZ);
            } else {
                this.generateDrop(world, random, blockX, blockY, blockZ);
            }
        } else if (random.nextInt(2) == 0 && corridorIteration > 1 && this.dungeonSize > 3 || this.dungeonSize >= 10 && this.dungeonCount < this.dungeonLimit) {
            this.createDungeon(world, random, blockX, blockY, blockZ, rot);
            ++this.dungeonCount;
        } else {
            if (random.nextInt(10) == 0 && corridorIteration > 1 && this.dungeonSize > 5) {
                return;
            }
            this.createCorridor(world, random, blockX, blockY, blockZ, rot, corridorIteration + 1);
        }
    }

    private void createCorridor(World world, Random random, int blockX, int blockY, int blockZ, int rot, int size) {
        if (rot == 0) {
            this.generateCorridor(world, random, blockX, blockY, blockZ + 4, 0, size);
        }
        if (rot == 1) {
            this.generateCorridor(world, random, blockX - 4, blockY, blockZ, 1, size);
        }
        if (rot == 2) {
            this.generateCorridor(world, random, blockX, blockY, blockZ - 4, 2, size);
        }
        if (rot == 3) {
            this.generateCorridor(world, random, blockX + 4, blockY, blockZ, 3, size);
        }
    }

    private void generateDungeon(World world, Random random, int blockX, int blockY, int blockZ, boolean doSpawner) {
        int chestZ;
        int size = 4;
        if (blockY < 10) {
            return;
        }
        for (int x2 = blockX - size; x2 <= blockX + size; ++x2) {
            for (int y2 = blockY - 2; y2 <= blockY + 2; ++y2) {
                for (int z2 = blockZ - size; z2 <= blockZ + size; ++z2) {
                    boolean yWallCheck;
                    boolean xWallCheck = x2 == blockX - size || x2 == blockX + size;
                    boolean zWallCheck = z2 == blockZ - size || z2 == blockZ + size;
                    boolean bl2 = yWallCheck = y2 == blockY - 2;
                    if (!this.canReplace(world, x2, y2, z2)) continue;
                    if (xWallCheck || zWallCheck) {
                        world.setBlockWithNotify(x2, y2, z2, this.wallBlockB);
                        continue;
                    }
                    if (yWallCheck) {
                        if (random.nextInt(5) == 0) {
                            world.setBlockWithNotify(x2, y2, z2, this.wallBlockB);
                            continue;
                        }
                        world.setBlockWithNotify(x2, y2, z2, this.wallBlockA);
                        continue;
                    }
                    world.setBlockWithNotify(x2, y2, z2, 0);
                }
            }
        }
        int chestX = blockX + random.nextInt(size - 1) - (size - 1);
        if (this.canReplace(world, chestX, blockY - 2, chestZ = blockZ + random.nextInt(size - 1) - (size - 1))) {
            world.setBlockWithNotify(chestX, blockY - 1, chestZ, Block.chestPlanksOak.blockID);
            TileEntityChest tileentitychest = (TileEntityChest)world.getBlockTileEntity(chestX, blockY - 1, chestZ);
            for (int k4 = 0; k4 < 10; ++k4) {
                ItemStack itemstack = this.pickCheckLootItem(random);
                if (itemstack == null) continue;
                tileentitychest.setInventorySlotContents(random.nextInt(tileentitychest.getSizeInventory()), itemstack);
            }
        }
        if (doSpawner) {
            world.setBlockWithNotify(blockX, blockY - 1, blockZ, Block.mobspawner.blockID);
            TileEntityMobSpawner tileentitymobspawner = (TileEntityMobSpawner)world.getBlockTileEntity(blockX, blockY - 1, blockZ);
            if (tileentitymobspawner != null) {
                tileentitymobspawner.setMobID(this.pickMobSpawner(random));
            }
        }
    }

    private void generateLibrary(World world, Random random, int blockX, int blockY, int blockZ) {
        int size = 10;
        int sideFacing = random.nextInt(2);
        if (blockY < 10) {
            return;
        }
        for (int x2 = blockX - size; x2 <= blockX + size; ++x2) {
            for (int y2 = blockY - 2; y2 <= blockY + 3; ++y2) {
                for (int z2 = blockZ - size; z2 <= blockZ + size; ++z2) {
                    boolean yWallCheck;
                    int xRoom = x2 - blockX + size;
                    int zRoom = z2 - blockZ + size;
                    boolean xWallCheck = x2 == blockX - size || x2 == blockX + size;
                    boolean zWallCheck = z2 == blockZ - size || z2 == blockZ + size;
                    boolean bl2 = yWallCheck = y2 == blockY - 2;
                    if (!this.canReplace(world, x2, y2, z2)) continue;
                    if (xWallCheck) {
                        if (zRoom % 4 != 0) {
                            world.setBlockWithNotify(x2, y2, z2, this.wallBlockB);
                        } else {
                            world.setBlockWithNotify(x2, y2, z2, this.brickBlockA);
                        }
                    } else if (zWallCheck) {
                        if (xRoom % 4 != 0) {
                            world.setBlockWithNotify(x2, y2, z2, this.wallBlockB);
                        } else {
                            world.setBlockWithNotify(x2, y2, z2, this.brickBlockA);
                        }
                    } else if (yWallCheck) {
                        if (x2 > blockX - 2 && x2 < blockX + 2 || z2 > blockZ - 2 && z2 < blockZ + 2) {
                            world.setBlockWithNotify(x2, y2, z2, Block.planksOak.blockID);
                        } else if (random.nextInt(5) == 0) {
                            world.setBlockWithNotify(x2, y2, z2, this.wallBlockB);
                        } else {
                            world.setBlockWithNotify(x2, y2, z2, this.wallBlockA);
                        }
                        if (x2 > blockX - 3 && x2 < blockX + 3 && z2 > blockZ - 3 && z2 < blockZ + 3) {
                            world.setBlockWithNotify(x2, y2, z2, this.wallBlockB);
                        }
                    } else if (y2 == blockY + 3) {
                        if (random.nextInt(5) == 0) {
                            world.setBlockWithNotify(x2, y2, z2, this.wallBlockB);
                        } else {
                            world.setBlockWithNotify(x2, y2, z2, this.wallBlockA);
                        }
                    } else if (x2 > blockX - size && x2 < blockX + size || z2 > blockZ - size && z2 < blockX + size) {
                        if (!(xRoom % 4 == 0 || zRoom % 2 != 0 || x2 > blockX - 2 && x2 < blockX + 2 || z2 > blockZ - 1 && z2 < blockZ + 1 || y2 >= blockY + 2)) {
                            if (xRoom % 2 == 0) {
                                world.setBlockWithNotify(x2, y2, z2, Block.bookshelfPlanksOak.blockID);
                            } else if (random.nextInt(5) == 0) {
                                world.setBlockWithNotify(x2, y2, z2, Block.logOakMossy.blockID);
                            } else {
                                world.setBlockWithNotify(x2, y2, z2, Block.logOak.blockID);
                            }
                        } else {
                            world.setBlockWithNotify(x2, y2, z2, 0);
                        }
                    } else {
                        world.setBlockWithNotify(x2, y2, z2, 0);
                    }
                    if (zRoom % 2 != 0 || x2 != blockX - 2 && x2 != blockX + 2 || z2 != blockZ - 2 && z2 != blockZ + 2) continue;
                    world.setBlockWithNotify(x2, y2, z2, this.brickBlockA);
                }
            }
        }
        this.generateDrop(world, random, blockX, blockY, blockZ);
    }

    private void createDungeon(World world, Random random, int blockX, int blockY, int blockZ, int rot) {
        int dx2 = 0;
        int dz2 = 0;
        if (rot == 0) {
            dz2 = 1;
        }
        if (rot == 1) {
            dx2 = -1;
        }
        if (rot == 2) {
            dz2 = -1;
        }
        if (rot == 3) {
            dx2 = 1;
        }
        if (this.canReplace(world, blockX + dx2 * 5, blockY, blockZ + dz2 * 5)) {
            if (this.dungeonSize == 10 && !this.libraryGenerated) {
                this.libraryGenerated = true;
                this.generateLibrary(world, random, blockX + dx2 * 4, blockY, blockZ + dz2 * 4);
            } else {
                this.generateDungeon(world, random, blockX + dx2 * 4, blockY, blockZ + dz2 * 4, true);
            }
        }
    }

    private ItemStack pickDispenserLootItem(Random random) {
        int i2 = random.nextInt(6);
        if (i2 == 1 || i2 > 3) {
            return new ItemStack(Item.ammoArrow, random.nextInt(3) + 5);
        }
        if (i2 == 2 && random.nextInt(10) == 0) {
            return new ItemStack(Item.ammoArrowGold, 1);
        }
        if (i2 == 3 && random.nextInt(200) == 0) {
            return new ItemStack(Item.ammoChargeExplosive, 1);
        }
        return null;
    }

    private ItemStack pickCheckLootItem(Random random) {
        if (!this.treasureGenerated && this.dungeonSize > 7) {
            this.treasureGenerated = true;
            return new ItemStack(Item.armorQuiverGold);
        }
        int i2 = random.nextInt(16);
        if (i2 == 1) {
            return new ItemStack(Item.ingotIron, random.nextInt(6) + 1);
        }
        if (i2 == 2) {
            return new ItemStack(Item.ingotGold, random.nextInt(4) + 1);
        }
        if (i2 == 3) {
            return new ItemStack(Item.sulphur, random.nextInt(6) + 3);
        }
        if (i2 == 4 && random.nextInt(50) == 0) {
            return new ItemStack(Item.diamond, random.nextInt(3) + 1);
        }
        if (i2 == 5 && random.nextInt(100) == 0) {
            return new ItemStack(Item.foodAppleGold);
        }
        if (i2 == 6) {
            return new ItemStack(Item.dustRedstone, random.nextInt(4) + 1);
        }
        if (i2 == 7 && random.nextInt(10) == 0) {
            return new ItemStack(Item.itemsList[Item.record13.itemID + random.nextInt(9)]);
        }
        if (i2 == 8) {
            return new ItemStack(Item.foodApple);
        }
        if (i2 == 9) {
            return new ItemStack(Item.itemsList[Block.spongeDry.blockID], random.nextInt(4) + 1);
        }
        if (i2 == 10 && random.nextInt(20) == 0) {
            if (random.nextInt(10) == 0) {
                return new ItemStack(Item.handcannonLoaded);
            }
            return new ItemStack(Item.handcannonUnloaded);
        }
        if (i2 == 11 && random.nextInt(5) == 0) {
            return new ItemStack(Item.armorHelmetChainmail, 1, Item.armorHelmetChainmail.getMaxDamage() - random.nextInt(Item.armorHelmetChainmail.getMaxDamage() / 2));
        }
        if (i2 == 12 && random.nextInt(5) == 0) {
            return new ItemStack(Item.armorChestplateChainmail, 1, Item.armorChestplateChainmail.getMaxDamage() - random.nextInt(Item.armorChestplateChainmail.getMaxDamage() / 2));
        }
        if (i2 == 13 && random.nextInt(5) == 0) {
            return new ItemStack(Item.armorBootsChainmail, 1, Item.armorBootsChainmail.getMaxDamage() - random.nextInt(Item.armorBootsChainmail.getMaxDamage() / 2));
        }
        if (i2 == 14 && random.nextInt(5) == 0) {
            return new ItemStack(Item.armorLeggingsChainmail, 1, Item.armorLeggingsChainmail.getMaxDamage() - random.nextInt(Item.armorLeggingsChainmail.getMaxDamage() / 2));
        }
        if (i2 == 15 && random.nextInt(10) == 0) {
            return new ItemStack(Item.ingotSteelCrude, random.nextInt(3) + 1);
        }
        return null;
    }

    private String pickMobSpawner(Random random) {
        int i2 = random.nextInt(4);
        if (i2 == 0) {
            return "Skeleton";
        }
        if (i2 == 1) {
            return "Zombie";
        }
        return "ArmouredZombie";
    }
}

