/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.EnumLightType;
import net.minecraft.src.Material;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenerator;

public class WorldGenLakes
extends WorldGenerator {
    private int liquidId;

    public WorldGenLakes(int liquidId) {
        this.liquidId = liquidId;
    }

    @Override
    public boolean generate(World world, Random random, int x2, int y2, int z2) {
        int dy2;
        int dx2;
        Block liquid = Block.blocksList[this.liquidId];
        BiomeGenBase biome = world.getBlockBiome(x2, z2);
        boolean shouldBeFrozen = liquid != null && liquid.blockMaterial == Material.water && biome != null && biome.hasSurfaceSnow();
        x2 -= 8;
        z2 -= 8;
        while (y2 > 0 && world.isAirBlock(x2, y2, z2)) {
            --y2;
        }
        y2 -= 4;
        boolean[] shouldPlaceLiquid = new boolean[2048];
        int l2 = random.nextInt(4) + 4;
        for (int i2 = 0; i2 < l2; ++i2) {
            double d2 = random.nextDouble() * 6.0 + 3.0;
            double d1 = random.nextDouble() * 4.0 + 2.0;
            double d22 = random.nextDouble() * 6.0 + 3.0;
            double d3 = random.nextDouble() * (16.0 - d2 - 2.0) + 1.0 + d2 / 2.0;
            double d4 = random.nextDouble() * (8.0 - d1 - 4.0) + 2.0 + d1 / 2.0;
            double d5 = random.nextDouble() * (16.0 - d22 - 2.0) + 1.0 + d22 / 2.0;
            for (int dx3 = 1; dx3 < 15; ++dx3) {
                for (int dz2 = 1; dz2 < 15; ++dz2) {
                    for (int dy3 = 1; dy3 < 7; ++dy3) {
                        double d6 = ((double)dx3 - d3) / (d2 / 2.0);
                        double d7 = ((double)dy3 - d4) / (d1 / 2.0);
                        double d8 = ((double)dz2 - d5) / (d22 / 2.0);
                        double d9 = d6 * d6 + d7 * d7 + d8 * d8;
                        if (!(d9 < 1.0)) continue;
                        shouldPlaceLiquid[(dx3 * 16 + dz2) * 8 + dy3] = true;
                    }
                }
            }
        }
        for (dx2 = 0; dx2 < 16; ++dx2) {
            for (int dz3 = 0; dz3 < 16; ++dz3) {
                for (dy2 = 0; dy2 < 8; ++dy2) {
                    boolean flag;
                    boolean bl2 = flag = !shouldPlaceLiquid[(dx2 * 16 + dz3) * 8 + dy2] && (dx2 < 15 && shouldPlaceLiquid[((dx2 + 1) * 16 + dz3) * 8 + dy2] || dx2 > 0 && shouldPlaceLiquid[((dx2 - 1) * 16 + dz3) * 8 + dy2] || dz3 < 15 && shouldPlaceLiquid[(dx2 * 16 + (dz3 + 1)) * 8 + dy2] || dz3 > 0 && shouldPlaceLiquid[(dx2 * 16 + (dz3 - 1)) * 8 + dy2] || dy2 < 7 && shouldPlaceLiquid[(dx2 * 16 + dz3) * 8 + (dy2 + 1)] || dy2 > 0 && shouldPlaceLiquid[(dx2 * 16 + dz3) * 8 + (dy2 - 1)]);
                    if (!flag) continue;
                    Material material = world.getBlockMaterial(x2 + dx2, y2 + dy2, z2 + dz3);
                    if (dy2 >= 4 && material.getIsLiquid()) {
                        return false;
                    }
                    if (dy2 < 4 && !material.isSolid() && world.getBlockId(x2 + dx2, y2 + dy2, z2 + dz3) != this.liquidId) {
                        return false;
                    }
                    if (world.getBlockId(x2 + dx2, y2 + dy2, z2 + dz3) != Block.ice.blockID) continue;
                    return false;
                }
            }
        }
        for (dx2 = 0; dx2 < 16; ++dx2) {
            for (int dz4 = 0; dz4 < 16; ++dz4) {
                for (dy2 = 0; dy2 < 8; ++dy2) {
                    if (!shouldPlaceLiquid[(dx2 * 16 + dz4) * 8 + dy2]) continue;
                    if (dy2 == 3 && shouldBeFrozen) {
                        world.setBlock(x2 + dx2, y2 + dy2, z2 + dz4, Block.ice.blockID);
                        continue;
                    }
                    world.setBlock(x2 + dx2, y2 + dy2, z2 + dz4, dy2 < 4 ? this.liquidId : 0);
                }
            }
        }
        for (dx2 = 0; dx2 < 16; ++dx2) {
            for (int dz5 = 0; dz5 < 16; ++dz5) {
                for (dy2 = 4; dy2 < 8; ++dy2) {
                    if (!shouldPlaceLiquid[(dx2 * 16 + dz5) * 8 + dy2] || world.getBlockId(x2 + dx2, y2 + dy2 - 1, z2 + dz5) != Block.dirt.blockID || world.getSavedLightValue(EnumLightType.Sky, x2 + dx2, y2 + dy2, z2 + dz5) <= 0) continue;
                    world.setBlock(x2 + dx2, y2 + dy2 - 1, z2 + dz5, Block.grass.blockID);
                }
            }
        }
        if (Block.blocksList[this.liquidId].blockMaterial == Material.lava) {
            for (dx2 = 0; dx2 < 16; ++dx2) {
                for (int dz6 = 0; dz6 < 16; ++dz6) {
                    for (dy2 = 0; dy2 < 8; ++dy2) {
                        boolean flag1;
                        boolean bl3 = flag1 = !shouldPlaceLiquid[(dx2 * 16 + dz6) * 8 + dy2] && (dx2 < 15 && shouldPlaceLiquid[((dx2 + 1) * 16 + dz6) * 8 + dy2] || dx2 > 0 && shouldPlaceLiquid[((dx2 - 1) * 16 + dz6) * 8 + dy2] || dz6 < 15 && shouldPlaceLiquid[(dx2 * 16 + (dz6 + 1)) * 8 + dy2] || dz6 > 0 && shouldPlaceLiquid[(dx2 * 16 + (dz6 - 1)) * 8 + dy2] || dy2 < 7 && shouldPlaceLiquid[(dx2 * 16 + dz6) * 8 + (dy2 + 1)] || dy2 > 0 && shouldPlaceLiquid[(dx2 * 16 + dz6) * 8 + (dy2 - 1)]);
                        if (!flag1 || dy2 >= 4 && random.nextInt(2) == 0 || !world.getBlockMaterial(x2 + dx2, y2 + dy2, z2 + dz6).isSolid()) continue;
                        world.setBlock(x2 + dx2, y2 + dy2, z2 + dz6, Block.stone.blockID);
                    }
                }
            }
        }
        return true;
    }
}

