/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenerator;

public class WorldGenTreeShapeShrub
extends WorldGenerator {
    protected int leavesID;
    protected int logID;

    public WorldGenTreeShapeShrub(int leavesID, int logID) {
        this.leavesID = leavesID;
        this.logID = logID;
    }

    @Override
    public boolean generate(World world, Random random, int i2, int j2, int k2) {
        int maxHeight = 1;
        boolean flag = true;
        if (j2 < 1 || j2 + maxHeight + 1 > Minecraft.WORLD_HEIGHT_BLOCKS) {
            return false;
        }
        for (int i1 = j2; i1 <= j2 + 1 + maxHeight; ++i1) {
            int byte0 = 2;
            for (int i22 = i2 - byte0; i22 <= i2 + byte0 && flag; ++i22) {
                for (int l2 = k2 - byte0; l2 <= k2 + byte0 && flag; ++l2) {
                    if (i1 >= 0 && i1 < Minecraft.WORLD_HEIGHT_BLOCKS) {
                        int j3 = world.getBlockId(i22, i1, l2);
                        if (j3 == 0 || j3 == this.leavesID) continue;
                        flag = false;
                        continue;
                    }
                    flag = false;
                }
            }
        }
        if (!flag) {
            return false;
        }
        int j1 = world.getBlockId(i2, j2 - 1, k2);
        if (Block.blocksList[j1] == null || !Block.blocksList[j1].plantable || j2 >= Minecraft.WORLD_HEIGHT_BLOCKS - maxHeight - 1) {
            return false;
        }
        world.setBlock(i2, j2 - 1, k2, Block.dirt.blockID);
        for (int k1 = j2 - 2 + maxHeight; k1 <= j2 + maxHeight; ++k1) {
            int j22 = k1 - (j2 + maxHeight + 1);
            int i3 = 1 - j22 / 2;
            for (int k3 = i2 - i3; k3 <= i2 + i3; ++k3) {
                int l3 = k3;
                for (int i4 = k2 - i3; i4 <= k2 + i3; ++i4) {
                    int j4 = i4 - k2;
                    if (Math.abs(l3) == i3 && Math.abs(j4) == i3 && random.nextInt(2) == 0 || Block.opaqueCubeLookup[world.getBlockId(k3, k1, i4)] || (k3 == i2 - i3 || k3 == i2 + i3) && (i4 == k2 - i3 || i4 == k2 + i3)) continue;
                    world.setBlockWithNotify(k3, k1, i4, this.leavesID);
                }
            }
        }
        int k22 = world.getBlockId(i2, j2, k2);
        if (k22 == 0 || k22 == this.leavesID) {
            world.setBlock(i2, j2, k2, this.logID);
        }
        return true;
    }
}

