/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.BlockGrass;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenAlgae;
import net.minecraft.src.WorldGenerator;

public class WorldGenTreeShapeSwamp
extends WorldGenerator {
    protected int leavesID;
    protected int logID;
    protected int heightMod;
    protected Random treeRand = new Random();

    public WorldGenTreeShapeSwamp(int leavesID, int logID, int heightMod) {
        this.leavesID = leavesID;
        this.logID = logID;
        this.heightMod = heightMod;
    }

    @Override
    public boolean generate(World world, Random random, int i2, int j2, int k2) {
        int trunkLength = random.nextInt(4) + this.heightMod;
        boolean flag = true;
        if (j2 < 1 || j2 + trunkLength + 1 > Minecraft.WORLD_HEIGHT_BLOCKS) {
            return false;
        }
        for (int i1 = j2; i1 <= j2 + 1 + trunkLength; ++i1) {
            int byte0 = 1;
            if (i1 == j2) {
                byte0 = 0;
            }
            if (i1 >= j2 + 1 + trunkLength - 2) {
                byte0 = 2;
            }
            for (int i22 = i2 - byte0; i22 <= i2 + byte0 && flag; ++i22) {
                for (int l2 = k2 - byte0; l2 <= k2 + byte0 && flag; ++l2) {
                    if (i1 >= 0 && i1 < Minecraft.WORLD_HEIGHT_BLOCKS) {
                        int j3 = world.getBlockId(i22, i1, l2);
                        if (j3 == 0 || j3 == this.leavesID) continue;
                        flag = false;
                        continue;
                    }
                    flag = false;
                }
            }
        }
        if (!flag) {
            return false;
        }
        int sinkToFloor = 0;
        while (world.getBlockId(i2, j2 - sinkToFloor - 1, k2) == Block.fluidWaterStill.blockID) {
            if (sinkToFloor > 3) {
                return false;
            }
            ++sinkToFloor;
        }
        int oldY = j2;
        int baseId = world.getBlockId(i2, (j2 -= sinkToFloor) - 1, k2);
        if (!(Block.blocksList[baseId] instanceof BlockGrass) && baseId != Block.dirt.blockID || j2 >= Minecraft.WORLD_HEIGHT_BLOCKS - trunkLength + sinkToFloor - 1) {
            return false;
        }
        world.setBlockWithNotify(i2, j2 - 1, k2, Block.dirt.blockID);
        for (int k1 = j2 - 3 + trunkLength + sinkToFloor; k1 <= j2 + trunkLength + sinkToFloor; ++k1) {
            int j22 = k1 - (j2 + trunkLength + sinkToFloor);
            int i3 = 2 - j22 / 2;
            for (int k3 = i2 - i3; k3 <= i2 + i3; ++k3) {
                int l3 = k3 - i2;
                for (int i4 = k2 - i3; i4 <= k2 + i3; ++i4) {
                    int j4 = i4 - k2;
                    if (Math.abs(l3) == i3 && Math.abs(j4) == i3 && (random.nextInt(2) == 0 || j22 == 0) || Block.opaqueCubeLookup[world.getBlockId(k3, k1, i4)]) continue;
                    world.setBlockWithNotify(k3, k1, i4, this.leavesID);
                    if (this.treeRand.nextInt(5) != 0) continue;
                    int vineLength = this.treeRand.nextInt(5);
                    for (int q2 = 0; q2 < vineLength; ++q2) {
                        if (world.getBlockId(k3, k1 - q2, i4) != 0) continue;
                        world.setBlock(k3, k1 - q2, i4, this.leavesID);
                    }
                }
            }
        }
        for (int l1 = 0; l1 < trunkLength + sinkToFloor; ++l1) {
            int k22 = world.getBlockId(i2, j2 + l1, k2);
            if (k22 != 0 && k22 != this.leavesID && k22 != Block.fluidWaterStill.blockID && k22 != Block.fluidWaterFlowing.blockID) continue;
            world.setBlockWithNotify(i2, j2 + l1, k2, this.logID);
        }
        new WorldGenAlgae().generate(world, this.treeRand, i2, oldY - 1, k2);
        return true;
    }
}

