/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.BlockGrass;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenerator;

public class WorldGenTreeShapeTaigaBushy
extends WorldGenerator {
    protected int leavesID;
    protected int logID;

    public WorldGenTreeShapeTaigaBushy(int leavesID, int logID) {
        this.leavesID = leavesID;
        this.logID = logID;
    }

    @Override
    public boolean generate(World world, Random random, int x2, int y2, int z2) {
        int heightMod = random.nextInt(2) + 10;
        int l2 = random.nextInt(4) + heightMod;
        int i1 = 1 + random.nextInt(2);
        int j1 = l2 - i1;
        int k1 = 2 + random.nextInt(2);
        boolean flag = true;
        if (y2 < 1 || y2 + l2 + 1 > Minecraft.WORLD_HEIGHT_BLOCKS) {
            return false;
        }
        for (int l1 = y2; l1 <= y2 + 1 + l2 && flag; ++l1) {
            int j2 = l1 - y2 < i1 ? 0 : k1;
            for (int l22 = x2 - j2; l22 <= x2 + j2 && flag; ++l22) {
                for (int j3 = z2 - j2; j3 <= z2 + j2 && flag; ++j3) {
                    if (l1 >= 0 && l1 < Minecraft.WORLD_HEIGHT_BLOCKS) {
                        int k3 = world.getBlockId(l22, l1, j3);
                        if (k3 == 0 || k3 == this.leavesID) continue;
                        flag = false;
                        continue;
                    }
                    flag = false;
                }
            }
        }
        if (!flag) {
            return false;
        }
        int i2 = world.getBlockId(x2, y2 - 1, z2);
        if (!(Block.blocksList[i2] instanceof BlockGrass) && i2 != Block.dirt.blockID || y2 >= Minecraft.WORLD_HEIGHT_BLOCKS - l2 - 1) {
            return false;
        }
        world.setBlockWithNotify(x2, y2 - 1, z2, Block.dirt.blockID);
        int k2 = random.nextInt(2);
        int i3 = 1;
        boolean flag1 = false;
        for (int l3 = 0; l3 <= j1; ++l3) {
            int j4 = y2 + l2 - l3;
            for (int l4 = x2 - k2; l4 <= x2 + k2; ++l4) {
                int j5 = l4 - x2;
                for (int k5 = z2 - k2; k5 <= z2 + k2; ++k5) {
                    int l5 = k5 - z2;
                    if (Math.abs(j5) == k2 && Math.abs(l5) == k2 && k2 > 0 || Block.opaqueCubeLookup[world.getBlockId(l4, j4, k5)]) continue;
                    world.setBlockWithNotify(l4, j4, k5, this.leavesID);
                }
            }
            if (k2 >= i3) {
                k2 = flag1 ? 1 : 0;
                flag1 = true;
                if (++i3 <= k1) continue;
                i3 = k1;
                continue;
            }
            ++k2;
        }
        int i4 = random.nextInt(3);
        for (int k4 = 0; k4 < l2 - i4; ++k4) {
            int i5 = world.getBlockId(x2, y2 + k4, z2);
            if (i5 != 0 && i5 != this.leavesID) continue;
            world.setBlockWithNotify(x2, y2 + k4, z2, this.logID);
        }
        return true;
    }
}

