/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.Random;
import net.minecraft.shared.Minecraft;
import net.minecraft.src.Block;
import net.minecraft.src.BlockGrass;
import net.minecraft.src.World;
import net.minecraft.src.WorldGenerator;

public class WorldGenTreeShapeTaigaTall
extends WorldGenerator {
    protected int leavesID;
    protected int logID;

    public WorldGenTreeShapeTaigaTall(int leavesID, int logID) {
        this.leavesID = leavesID;
        this.logID = logID;
    }

    @Override
    public boolean generate(World world, Random random, int x2, int y2, int z2) {
        int l2 = random.nextInt(5) + 7;
        int i1 = l2 - random.nextInt(2) - 3;
        int j1 = l2 - i1;
        int k1 = 1 + random.nextInt(j1 + 1);
        boolean flag = true;
        if (y2 < 1 || y2 + l2 + 1 > Minecraft.WORLD_HEIGHT_BLOCKS) {
            return false;
        }
        for (int l1 = y2; l1 <= y2 + 1 + l2 && flag; ++l1) {
            int j2 = 1;
            j2 = l1 - y2 < i1 ? 0 : k1;
            for (int l22 = x2 - j2; l22 <= x2 + j2 && flag; ++l22) {
                for (int k3 = z2 - j2; k3 <= z2 + j2 && flag; ++k3) {
                    if (l1 >= 0 && l1 < Minecraft.WORLD_HEIGHT_BLOCKS) {
                        int j4 = world.getBlockId(l22, l1, k3);
                        if (j4 == 0 || j4 == this.leavesID) continue;
                        flag = false;
                        continue;
                    }
                    flag = false;
                }
            }
        }
        if (!flag) {
            return false;
        }
        int i2 = world.getBlockId(x2, y2 - 1, z2);
        if (!(Block.blocksList[i2] instanceof BlockGrass) && i2 != Block.dirt.blockID || y2 >= Minecraft.WORLD_HEIGHT_BLOCKS - l2 - 1) {
            return false;
        }
        world.setBlockWithNotify(x2, y2 - 1, z2, Block.dirt.blockID);
        int k2 = 0;
        for (int i3 = y2 + l2; i3 >= y2 + i1; --i3) {
            for (int l3 = x2 - k2; l3 <= x2 + k2; ++l3) {
                int k4 = l3 - x2;
                for (int l4 = z2 - k2; l4 <= z2 + k2; ++l4) {
                    int i5 = l4 - z2;
                    if (Math.abs(k4) == k2 && Math.abs(i5) == k2 && k2 > 0 || Block.opaqueCubeLookup[world.getBlockId(l3, i3, l4)]) continue;
                    world.setBlockWithNotify(l3, i3, l4, this.leavesID);
                }
            }
            if (k2 >= 1 && i3 == y2 + i1 + 1) {
                --k2;
                continue;
            }
            if (k2 >= k1) continue;
            ++k2;
        }
        for (int j3 = 0; j3 < l2 - 1; ++j3) {
            int i4 = world.getBlockId(x2, y2 + j3, z2);
            if (i4 != 0 && i4 != this.leavesID) continue;
            world.setBlockWithNotify(x2, y2 + j3, z2, this.logID);
        }
        return true;
    }
}

