/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.List;
import net.minecraft.src.Dimension;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.NBTTagCompound;
import net.minecraft.src.WorldType;

public class WorldInfo {
    private long randomSeed;
    private int spawnX;
    private int spawnY;
    private int spawnZ;
    private long worldTime;
    private long lastTimePlayed;
    private long sizeOnDisk;
    private NBTTagCompound playerTag;
    private byte[] worldTypes;
    private int dimension;
    private int gamemode;
    private String levelName;
    private int saveVersion;
    private int weatherId;
    private int newWeatherId;
    private long weatherDuration;
    private float weatherIntensity;
    private float weatherPower;
    private boolean cheatsEnabled;

    public WorldInfo(NBTTagCompound nbttagcompound) {
        this.randomSeed = nbttagcompound.getLong("RandomSeed");
        this.spawnX = nbttagcompound.getInteger("SpawnX");
        this.spawnY = nbttagcompound.getInteger("SpawnY");
        this.spawnZ = nbttagcompound.getInteger("SpawnZ");
        this.worldTime = nbttagcompound.getLong("Time");
        this.lastTimePlayed = nbttagcompound.getLong("LastPlayed");
        this.sizeOnDisk = nbttagcompound.getLong("SizeOnDisk");
        this.levelName = nbttagcompound.getString("LevelName");
        this.saveVersion = nbttagcompound.getInteger("version");
        this.weatherId = nbttagcompound.getInteger("WeatherID");
        this.newWeatherId = nbttagcompound.getInteger("NewWeatherID");
        this.weatherDuration = nbttagcompound.getLong("WeatherDuration");
        this.weatherIntensity = nbttagcompound.getFloat("WeatherIntensity");
        this.weatherPower = nbttagcompound.getFloat("WeatherPower");
        this.cheatsEnabled = nbttagcompound.getBoolean("CheatsEnabled");
        this.worldTypes = nbttagcompound.getByteArray("WorldTypes");
        if (nbttagcompound.hasKey("Player")) {
            this.playerTag = nbttagcompound.getCompoundTag("Player");
            this.dimension = this.playerTag.getInteger("Dimension");
            this.gamemode = this.playerTag.getInteger("Gamemode");
        }
        if (this.worldTypes.length < Dimension.dimensionList.length) {
            byte[] newWorldTypes = new byte[Dimension.dimensionList.length];
            System.arraycopy(this.worldTypes, 0, newWorldTypes, 0, this.worldTypes.length);
            for (int i2 = this.worldTypes.length; i2 < newWorldTypes.length; ++i2) {
                newWorldTypes[i2] = (byte)Dimension.dimensionList[i2].worldType.id;
            }
            newWorldTypes[0] = (byte)nbttagcompound.getInteger("WorldType");
            this.worldTypes = newWorldTypes;
        }
    }

    public WorldInfo(long l2, String s2) {
        this.randomSeed = l2;
        this.levelName = s2;
        this.worldTypes = new byte[Dimension.dimensionList.length];
        for (int i2 = 0; i2 < this.worldTypes.length; ++i2) {
            this.worldTypes[i2] = (byte)Dimension.dimensionList[i2].worldType.id;
        }
    }

    public WorldInfo(WorldInfo worldinfo) {
        this.randomSeed = worldinfo.randomSeed;
        this.spawnX = worldinfo.spawnX;
        this.spawnY = worldinfo.spawnY;
        this.spawnZ = worldinfo.spawnZ;
        this.worldTime = worldinfo.worldTime;
        this.lastTimePlayed = worldinfo.lastTimePlayed;
        this.sizeOnDisk = worldinfo.sizeOnDisk;
        this.playerTag = worldinfo.playerTag;
        this.dimension = worldinfo.dimension;
        this.levelName = worldinfo.levelName;
        this.saveVersion = worldinfo.saveVersion;
        this.weatherId = worldinfo.weatherId;
        this.newWeatherId = worldinfo.newWeatherId;
        this.weatherDuration = worldinfo.weatherDuration;
        this.weatherIntensity = worldinfo.weatherIntensity;
        this.weatherPower = worldinfo.weatherPower;
        this.cheatsEnabled = worldinfo.cheatsEnabled;
        this.worldTypes = worldinfo.worldTypes;
        if (this.worldTypes.length < Dimension.dimensionList.length) {
            byte[] newWorldTypes = new byte[Dimension.dimensionList.length];
            System.arraycopy(this.worldTypes, 0, newWorldTypes, 0, this.worldTypes.length);
            for (int i2 = this.worldTypes.length; i2 < newWorldTypes.length; ++i2) {
                this.worldTypes[i2] = (byte)Dimension.dimensionList[i2].worldType.id;
            }
            this.worldTypes = newWorldTypes;
        }
    }

    public NBTTagCompound getNBTTagCompound() {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        this.updateTagCompound(nbttagcompound, this.playerTag);
        return nbttagcompound;
    }

    public NBTTagCompound getNBTTagCompoundWithPlayer(List list) {
        NBTTagCompound nbttagcompound = new NBTTagCompound();
        EntityPlayer entityplayer = null;
        NBTTagCompound nbttagcompound1 = null;
        if (list.size() > 0) {
            entityplayer = (EntityPlayer)list.get(0);
        }
        if (entityplayer != null) {
            nbttagcompound1 = new NBTTagCompound();
            entityplayer.writeToNBT(nbttagcompound1);
        }
        this.updateTagCompound(nbttagcompound, nbttagcompound1);
        return nbttagcompound;
    }

    private void updateTagCompound(NBTTagCompound nbttagcompound, NBTTagCompound nbttagcompound1) {
        nbttagcompound.setLong("RandomSeed", this.randomSeed);
        nbttagcompound.setInteger("SpawnX", this.spawnX);
        nbttagcompound.setInteger("SpawnY", this.spawnY);
        nbttagcompound.setInteger("SpawnZ", this.spawnZ);
        nbttagcompound.setLong("Time", this.worldTime);
        nbttagcompound.setLong("SizeOnDisk", this.sizeOnDisk);
        nbttagcompound.setLong("LastPlayed", System.currentTimeMillis());
        nbttagcompound.setString("LevelName", this.levelName);
        nbttagcompound.setInteger("version", this.saveVersion);
        nbttagcompound.setInteger("WeatherID", this.weatherId);
        nbttagcompound.setInteger("NewWeatherID", this.newWeatherId);
        nbttagcompound.setLong("WeatherDuration", this.weatherDuration);
        nbttagcompound.setFloat("WeatherIntensity", this.weatherIntensity);
        nbttagcompound.setFloat("WeatherPower", this.weatherPower);
        nbttagcompound.setBoolean("CheatsEnabled", this.cheatsEnabled);
        nbttagcompound.setByteArray("WorldTypes", this.worldTypes);
        if (nbttagcompound1 != null) {
            nbttagcompound.setCompoundTag("Player", nbttagcompound1);
        }
    }

    public long getRandomSeed() {
        return this.randomSeed;
    }

    public int getSpawnX() {
        return this.spawnX;
    }

    public int getSpawnY() {
        return this.spawnY;
    }

    public int getSpawnZ() {
        return this.spawnZ;
    }

    public long getWorldTime() {
        return this.worldTime;
    }

    public long getSizeOnDisk() {
        return this.sizeOnDisk;
    }

    public NBTTagCompound getPlayerNBTTagCompound() {
        return this.playerTag;
    }

    public int getDimension() {
        return this.dimension;
    }

    public void setSpawnX(int i2) {
        this.spawnX = i2;
    }

    public void setSpawnY(int i2) {
        this.spawnY = i2;
    }

    public void setSpawnZ(int i2) {
        this.spawnZ = i2;
    }

    public void setWorldTime(long l2) {
        this.worldTime = l2;
    }

    public void setSizeOnDisk(long l2) {
        this.sizeOnDisk = l2;
    }

    public void setPlayerNBTTagCompound(NBTTagCompound nbttagcompound) {
        this.playerTag = nbttagcompound;
    }

    public void setSpawn(int i2, int j2, int k2) {
        this.spawnX = i2;
        this.spawnY = j2;
        this.spawnZ = k2;
    }

    public String getWorldName() {
        return this.levelName;
    }

    public void setWorldName(String s2) {
        this.levelName = s2;
    }

    public int getSaveVersion() {
        return this.saveVersion;
    }

    public void setSaveVersion(int i2) {
        this.saveVersion = i2;
    }

    public long getLastTimePlayed() {
        return this.lastTimePlayed;
    }

    public int getWeatherId() {
        return this.weatherId;
    }

    public void setWeatherId(int i2) {
        this.weatherId = i2;
    }

    public int getNewWeatherId() {
        return this.newWeatherId;
    }

    public void setNewWeatherId(int i2) {
        this.newWeatherId = i2;
    }

    public long getWeatherDuration() {
        return this.weatherDuration;
    }

    public void setWeatherDuration(long l2) {
        this.weatherDuration = l2;
    }

    public float getWeatherIntensity() {
        return this.weatherIntensity;
    }

    public void setWeatherIntensity(float f2) {
        this.weatherIntensity = f2;
    }

    public float getWeatherPower() {
        return this.weatherPower;
    }

    public void setWeatherPower(float f2) {
        this.weatherPower = f2;
    }

    public int getGamemode() {
        return this.gamemode;
    }

    public void setGamemode(int gamemode) {
        this.gamemode = gamemode;
    }

    public boolean getCheatsEnabled() {
        return this.cheatsEnabled;
    }

    public void setCheatsEnabled(boolean enabled) {
        this.cheatsEnabled = enabled;
    }

    public int getWorldType(int dim) {
        return this.worldTypes[dim];
    }

    public void setWorldType(int dim, int type) {
        this.worldTypes[dim] = (byte)type;
    }

    public void setWorldTypes(byte[] types) {
        this.worldTypes = types;
    }

    public byte[] getWorldTypes() {
        return this.worldTypes;
    }

    public void printWorldTypes() {
        for (int i2 = 0; i2 < this.worldTypes.length; ++i2) {
            int id2 = this.getWorldType(i2);
            System.out.println("DIM: " + i2 + " WorldType: " + WorldType.get(id2) + " (" + id2 + ")");
        }
    }
}

