/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.ChunkProviderHell;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.Vec3D;
import net.minecraft.src.WorldChunkManagerHell;
import net.minecraft.src.WorldProvider;

public class WorldProviderHell
extends WorldProvider {
    @Override
    public void registerWorldChunkManager() {
        this.worldChunkMgr = new WorldChunkManagerHell(this.worldObj, BiomeGenBase.hell, 1.0, 0.0);
        this.hasNoSky = true;
    }

    @Override
    public Vec3D func_4096_a(float f2, float f1) {
        return Vec3D.createVector(0.2f, 0.03f, 0.03f);
    }

    @Override
    protected void generateLightBrightnessTable() {
        float f2 = 0.1f;
        for (int i2 = 0; i2 <= 15; ++i2) {
            float f1 = 1.0f - (float)i2 / 15.0f;
            this.lightBrightnessTable[i2] = (1.0f - f1) / (f1 * 3.0f + 1.0f) * (1.0f - f2) + f2;
        }
    }

    @Override
    public IChunkProvider getChunkProvider() {
        return new ChunkProviderHell(this.worldObj, this.worldObj.getRandomSeed());
    }

    @Override
    public boolean canCoordinateBeSpawn(int i2, int j2) {
        int k2 = this.worldObj.getFirstUncoveredBlock(i2, j2);
        if (k2 == Block.bedrock.blockID) {
            return false;
        }
        if (k2 == 0) {
            return false;
        }
        return Block.opaqueCubeLookup[k2];
    }

    @Override
    public float calculateCelestialAngle(long l2, float f2) {
        return 0.5f;
    }

    @Override
    public boolean canRespawnHere() {
        return false;
    }
}

