/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import net.minecraft.src.BiomeGenBase;
import net.minecraft.src.Block;
import net.minecraft.src.ChunkProviderSky;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.MathHelper;
import net.minecraft.src.Vec3D;
import net.minecraft.src.WorldChunkManagerHell;
import net.minecraft.src.WorldProvider;

public class WorldProviderSky
extends WorldProvider {
    @Override
    public void registerWorldChunkManager() {
        this.worldChunkMgr = new WorldChunkManagerHell(this.worldObj, BiomeGenBase.sky, 0.5, 0.0);
    }

    @Override
    public boolean canRespawnHere() {
        return false;
    }

    @Override
    public IChunkProvider getChunkProvider() {
        return new ChunkProviderSky(this.worldObj, this.worldObj.getRandomSeed());
    }

    @Override
    public float calculateCelestialAngle(long l2, float f2) {
        return 0.0f;
    }

    @Override
    public float[] calcSunriseSunsetColors(float f2, float f1) {
        return null;
    }

    @Override
    public Vec3D func_4096_a(float f2, float f1) {
        int i2 = 0x8080A0;
        float f22 = MathHelper.cos(f2 * 3.141593f * 2.0f) * 2.0f + 0.5f;
        if (f22 < 0.0f) {
            f22 = 0.0f;
        }
        if (f22 > 1.0f) {
            f22 = 1.0f;
        }
        float f3 = (float)(i2 >> 16 & 0xFF) / 255.0f;
        float f4 = (float)(i2 >> 8 & 0xFF) / 255.0f;
        float f5 = (float)(i2 & 0xFF) / 255.0f;
        return Vec3D.createVector(f3 *= f22 * 0.94f + 0.06f, f4 *= f22 * 0.94f + 0.06f, f5 *= f22 * 0.91f + 0.09f);
    }

    @Override
    public boolean func_28112_c() {
        return false;
    }

    @Override
    public float getCloudHeight() {
        return 8.0f;
    }

    @Override
    public boolean canCoordinateBeSpawn(int i2, int j2) {
        int k2 = this.worldObj.getFirstUncoveredBlock(i2, j2);
        if (k2 == 0) {
            return false;
        }
        return Block.blocksList[k2].blockMaterial.getIsSolid();
    }
}

