/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.src.AxisAlignedBB;
import net.minecraft.src.Block;
import net.minecraft.src.Chunk;
import net.minecraft.src.ChunkCache;
import net.minecraft.src.Entity;
import net.minecraft.src.ICamera;
import net.minecraft.src.MathHelper;
import net.minecraft.src.RenderBlocks;
import net.minecraft.src.RenderEngine;
import net.minecraft.src.RenderItem;
import net.minecraft.src.Tessellator;
import net.minecraft.src.TileEntity;
import net.minecraft.src.TileEntityRenderer;
import net.minecraft.src.World;
import org.lwjgl.opengl.GL11;

public class WorldRenderer {
    private RenderEngine renderEngine;
    public World worldObj;
    private int glRenderList = -1;
    private static Tessellator tessellator;
    public static int chunksUpdated;
    public int posX;
    public int posY;
    public int posZ;
    public int sizeWidth;
    public int sizeHeight;
    public int sizeDepth;
    public int posXMinus;
    public int posYMinus;
    public int posZMinus;
    public int posXClip;
    public int posYClip;
    public int posZClip;
    public boolean isInFrustum = false;
    public boolean[] skipRenderPass = new boolean[2];
    public int posXPlus;
    public int posYPlus;
    public int posZPlus;
    public float rendererRadius;
    public boolean needsUpdate;
    public AxisAlignedBB rendererBoundingBox;
    public int chunkIndex;
    public boolean isVisible = true;
    public boolean isWaitingOnOcclusionQuery;
    public int glOcclusionQuery;
    public boolean isChunkLit;
    private boolean isInitialized = false;
    public List tileEntityRenderers = new ArrayList();
    private List tileEntities;

    public WorldRenderer(RenderEngine renderEngine, World world, List list, int i2, int j2, int k2, int l2, int i1) {
        this.worldObj = world;
        this.tileEntities = list;
        this.sizeHeight = this.sizeDepth = l2;
        this.sizeWidth = this.sizeDepth;
        this.rendererRadius = MathHelper.sqrt_float(this.sizeWidth * this.sizeWidth + this.sizeHeight * this.sizeHeight + this.sizeDepth * this.sizeDepth) / 2.0f;
        this.glRenderList = i1;
        this.posX = -999;
        this.setPosition(i2, j2, k2);
        this.needsUpdate = false;
        this.renderEngine = renderEngine;
    }

    public void setPosition(int i2, int j2, int k2) {
        if (i2 == this.posX && j2 == this.posY && k2 == this.posZ) {
            return;
        }
        this.setDontDraw();
        this.posX = i2;
        this.posY = j2;
        this.posZ = k2;
        this.posXPlus = i2 + this.sizeWidth / 2;
        this.posYPlus = j2 + this.sizeHeight / 2;
        this.posZPlus = k2 + this.sizeDepth / 2;
        this.posXClip = i2 & 0x3FF;
        this.posYClip = j2;
        this.posZClip = k2 & 0x3FF;
        this.posXMinus = i2 - this.posXClip;
        this.posYMinus = j2 - this.posYClip;
        this.posZMinus = k2 - this.posZClip;
        float f2 = 6.0f;
        this.rendererBoundingBox = AxisAlignedBB.getBoundingBox((float)i2 - f2, (float)j2 - f2, (float)k2 - f2, (float)(i2 + this.sizeWidth) + f2, (float)(j2 + this.sizeHeight) + f2, (float)(k2 + this.sizeDepth) + f2);
        GL11.glNewList((int)(this.glRenderList + 2), (int)4864);
        RenderItem.renderAABB(AxisAlignedBB.getBoundingBoxFromPool((float)this.posXClip - f2, (float)this.posYClip - f2, (float)this.posZClip - f2, (float)(this.posXClip + this.sizeWidth) + f2, (float)(this.posYClip + this.sizeHeight) + f2, (float)(this.posZClip + this.sizeDepth) + f2));
        GL11.glEndList();
        this.markDirty();
    }

    private void setupGLTranslation() {
        GL11.glTranslatef((float)this.posXClip, (float)this.posYClip, (float)this.posZClip);
    }

    public void updateRenderer() {
        if (!this.needsUpdate) {
            return;
        }
        ++chunksUpdated;
        int i2 = this.posX;
        int j2 = this.posY;
        int k2 = this.posZ;
        int l2 = this.posX + this.sizeWidth;
        int i1 = this.posY + this.sizeHeight;
        int j1 = this.posZ + this.sizeDepth;
        for (int k1 = 0; k1 < 2; ++k1) {
            this.skipRenderPass[k1] = true;
        }
        Chunk.isLit = false;
        HashSet hashset = new HashSet();
        hashset.addAll(this.tileEntityRenderers);
        this.tileEntityRenderers.clear();
        int l1 = 1;
        ChunkCache chunkcache = new ChunkCache(this.worldObj, i2 - l1, j2 - l1, k2 - l1, l2 + l1, i1 + l1, j1 + l1);
        RenderBlocks renderblocks = new RenderBlocks(this.worldObj, chunkcache);
        for (int i22 = 0; i22 < 2; ++i22) {
            boolean flag = false;
            boolean flag1 = false;
            boolean flag2 = false;
            for (int j22 = j2; j22 < i1; ++j22) {
                for (int k22 = k2; k22 < j1; ++k22) {
                    for (int l22 = i2; l22 < l2; ++l22) {
                        Block block;
                        int j3;
                        TileEntity tileentity;
                        int i3 = chunkcache.getBlockId(l22, j22, k22);
                        if (i3 <= 0) continue;
                        if (!flag2) {
                            flag2 = true;
                            GL11.glNewList((int)(this.glRenderList + i22), (int)4864);
                            GL11.glPushMatrix();
                            this.setupGLTranslation();
                            float f2 = 1.000001f;
                            GL11.glTranslatef((float)((float)(-this.sizeDepth) / 2.0f), (float)((float)(-this.sizeHeight) / 2.0f), (float)((float)(-this.sizeDepth) / 2.0f));
                            GL11.glScalef((float)f2, (float)f2, (float)f2);
                            GL11.glTranslatef((float)((float)this.sizeDepth / 2.0f), (float)((float)this.sizeHeight / 2.0f), (float)((float)this.sizeDepth / 2.0f));
                            tessellator.startDrawingQuads();
                            tessellator.setTranslationD(-this.posX, -this.posY, -this.posZ);
                        }
                        if (i22 == 0 && Block.isBlockContainer[i3] && TileEntityRenderer.instance.hasSpecialRenderer(tileentity = chunkcache.getBlockTileEntity(l22, j22, k22))) {
                            this.tileEntityRenderers.add(tileentity);
                        }
                        if ((j3 = (block = Block.blocksList[i3]).getRenderBlockPass()) != i22) {
                            flag = true;
                            continue;
                        }
                        if (j3 != i22) continue;
                        flag1 |= renderblocks.renderBlockByRenderType(block, l22, j22, k22);
                        if (!block.hasOverbright) continue;
                        renderblocks.overbright = true;
                        flag1 |= renderblocks.renderBlockByRenderType(block, l22, j22, k22);
                        renderblocks.overbright = false;
                    }
                }
            }
            if (flag2) {
                tessellator.draw();
                GL11.glPopMatrix();
                GL11.glEndList();
                tessellator.setTranslationD(0.0, 0.0, 0.0);
            } else {
                flag1 = false;
            }
            if (flag1) {
                this.skipRenderPass[i22] = false;
            }
            if (!flag) break;
        }
        HashSet hashset1 = new HashSet();
        hashset1.addAll(this.tileEntityRenderers);
        hashset1.removeAll(hashset);
        this.tileEntities.addAll(hashset1);
        hashset.removeAll(this.tileEntityRenderers);
        this.tileEntities.removeAll(hashset);
        this.isChunkLit = Chunk.isLit;
        this.isInitialized = true;
    }

    public float distanceToEntitySquared(Entity entity) {
        float f2 = (float)(entity.posX - (double)this.posXPlus);
        float f1 = (float)(entity.posY - (double)this.posYPlus);
        float f22 = (float)(entity.posZ - (double)this.posZPlus);
        return f2 * f2 + f1 * f1 + f22 * f22;
    }

    public void setDontDraw() {
        for (int i2 = 0; i2 < 2; ++i2) {
            this.skipRenderPass[i2] = true;
        }
        this.isInFrustum = false;
        this.isInitialized = false;
    }

    public void func_1204_c() {
        this.setDontDraw();
        this.worldObj = null;
    }

    public int getGLCallListForPass(int i2) {
        if (!this.isInFrustum) {
            return -1;
        }
        if (!this.skipRenderPass[i2]) {
            return this.glRenderList + i2;
        }
        return -1;
    }

    public void updateInFrustrum(ICamera icamera) {
        this.isInFrustum = icamera.isBoundingBoxInFrustum(this.rendererBoundingBox);
    }

    public void callOcclusionQueryList() {
        GL11.glCallList((int)(this.glRenderList + 2));
    }

    public boolean skipAllRenderPasses() {
        if (!this.isInitialized) {
            return false;
        }
        return this.skipRenderPass[0] && this.skipRenderPass[1];
    }

    public void markDirty() {
        this.needsUpdate = true;
    }

    static {
        chunksUpdated = 0;
        tessellator = Tessellator.instance;
    }
}

