/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.server.MinecraftServer;
import net.minecraft.src.ChunkProviderServer;
import net.minecraft.src.Dimension;
import net.minecraft.src.Entity;
import net.minecraft.src.EntityAnimal;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityWaterMob;
import net.minecraft.src.Explosion;
import net.minecraft.src.ExplosionCannonball;
import net.minecraft.src.IChunkLoader;
import net.minecraft.src.IChunkProvider;
import net.minecraft.src.ISaveHandler;
import net.minecraft.src.MCHash;
import net.minecraft.src.MathHelper;
import net.minecraft.src.Packet38EntityStatus;
import net.minecraft.src.Packet54PlayNoteBlock;
import net.minecraft.src.Packet60Explosion;
import net.minecraft.src.Packet71Weather;
import net.minecraft.src.Packet73WeatherStatus;
import net.minecraft.src.TileEntity;
import net.minecraft.src.World;

public class WorldServer
extends World {
    public ChunkProviderServer chunkProviderServer;
    public boolean field_819_z = false;
    public boolean levelSaving;
    private MinecraftServer mcServer;
    private MCHash field_20912_E = new MCHash();

    public WorldServer(MinecraftServer minecraftserver, ISaveHandler isavehandler, String s2, int i2, long l2) {
        super(isavehandler, s2, l2, Dimension.dimensionList[i2]);
        this.mcServer = minecraftserver;
    }

    @Override
    public void updateEntityWithOptionalForce(Entity entity, boolean flag) {
        if (!this.mcServer.spawnPeacefulMobs && (entity instanceof EntityAnimal || entity instanceof EntityWaterMob)) {
            entity.setEntityDead();
        }
        if (entity.riddenByEntity == null || !(entity.riddenByEntity instanceof EntityPlayer)) {
            super.updateEntityWithOptionalForce(entity, flag);
        }
    }

    public void func_12017_b(Entity entity, boolean flag) {
        super.updateEntityWithOptionalForce(entity, flag);
    }

    @Override
    protected IChunkProvider getChunkProvider() {
        IChunkLoader ichunkloader = this.saveHandler.getChunkLoader(this.dimension);
        this.chunkProviderServer = new ChunkProviderServer(this, ichunkloader, this.dimension.worldType.worldProvider.getChunkProvider());
        return this.chunkProviderServer;
    }

    public List getTileEntityList(int i2, int j2, int k2, int l2, int i1, int j1) {
        ArrayList<TileEntity> arraylist = new ArrayList<TileEntity>();
        for (int k1 = 0; k1 < this.loadedTileEntityList.size(); ++k1) {
            TileEntity tileentity = (TileEntity)this.loadedTileEntityList.get(k1);
            if (tileentity.xCoord < i2 || tileentity.yCoord < j2 || tileentity.zCoord < k2 || tileentity.xCoord >= l2 || tileentity.yCoord >= i1 || tileentity.zCoord >= j1) continue;
            arraylist.add(tileentity);
        }
        return arraylist;
    }

    @Override
    public boolean canMineBlock(EntityPlayer entityplayer, int i2, int j2, int k2) {
        int i1;
        int l2 = (int)MathHelper.abs(i2 - this.worldInfo.getSpawnX());
        if (l2 > (i1 = (int)MathHelper.abs(k2 - this.worldInfo.getSpawnZ()))) {
            i1 = l2;
        }
        return i1 > 16 || this.mcServer.configManager.isOp(entityplayer.username);
    }

    @Override
    protected void obtainEntitySkin(Entity entity) {
        super.obtainEntitySkin(entity);
        this.field_20912_E.addKey(entity.entityId, entity);
    }

    @Override
    protected void releaseEntitySkin(Entity entity) {
        super.releaseEntitySkin(entity);
        this.field_20912_E.removeObject(entity.entityId);
    }

    public Entity func_6158_a(int i2) {
        return (Entity)this.field_20912_E.lookup(i2);
    }

    @Override
    public boolean addWeatherEffect(Entity entity) {
        if (super.addWeatherEffect(entity)) {
            this.mcServer.configManager.sendPacketToPlayersAroundPoint(entity.posX, entity.posY, entity.posZ, 512.0, this.dimension.dimId, new Packet71Weather(entity));
            return true;
        }
        return false;
    }

    @Override
    public void sendTrackedEntityStatusUpdatePacket(Entity entityId, byte entityStatus) {
        Packet38EntityStatus packet38entitystatus = new Packet38EntityStatus(entityId.entityId, entityStatus);
        this.mcServer.getEntityTracker(this.dimension.dimId).sendPacketToTrackedPlayersAndTrackedEntity(entityId, packet38entitystatus);
    }

    @Override
    public void sendTrackedEntityStatusUpdatePacket(Entity entityId, byte entityStatus, float attackedAtYaw) {
        Packet38EntityStatus packet38entitystatus = new Packet38EntityStatus(entityId.entityId, entityStatus, attackedAtYaw);
        this.mcServer.getEntityTracker(this.dimension.dimId).sendPacketToTrackedPlayersAndTrackedEntity(entityId, packet38entitystatus);
    }

    @Override
    public Explosion createExplosion(Entity entity, double d2, double d1, double d22, float f2) {
        return this.newExplosion(entity, d2, d1, d22, f2, false, false);
    }

    @Override
    public Explosion newExplosion(Entity entity, double d2, double d1, double d22, float f2, boolean flag, boolean isCannonBall) {
        Explosion explosion = !isCannonBall ? new Explosion(this, entity, d2, d1, d22, f2) : new ExplosionCannonball(this, entity, d2, d1, d22, f2);
        explosion.isFlaming = flag;
        explosion.doExplosionA();
        explosion.doExplosionB(true);
        this.mcServer.configManager.sendPacketToPlayersAroundPoint(d2, d1, d22, 64.0, this.dimension.dimId, new Packet60Explosion(d2, d1, d22, f2, explosion.destroyedBlockPositions, isCannonBall));
        return explosion;
    }

    @Override
    public void playNoteAt(int i2, int j2, int k2, int l2, int i1) {
        super.playNoteAt(i2, j2, k2, l2, i1);
        this.mcServer.configManager.sendPacketToPlayersAroundPoint(i2, j2, k2, 64.0, this.dimension.dimId, new Packet54PlayNoteBlock(i2, j2, k2, l2, i1));
    }

    public void func_30006_w() {
        this.saveHandler.checkSessionLock();
    }

    @Override
    protected boolean updateWeather() {
        boolean result = super.updateWeather();
        if (result) {
            this.mcServer.configManager.sendPacketToAllPlayers(new Packet73WeatherStatus(this.dimension.dimId, this.currentWeather != null ? this.currentWeather.weatherId : -1, this.newWeather != null ? this.newWeather.weatherId : -1, this.weatherDuration, this.weatherIntensity, this.weatherPower));
        }
        return result;
    }
}

