/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command;

import net.minecraft.client.Minecraft;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.World;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;
import net.minecraft.src.command.Commands;

public class ClientCommandHandler
implements CommandHandler {
    public final Minecraft minecraft;

    public ClientCommandHandler(Minecraft minecraft) {
        this.minecraft = minecraft;
        Commands.initClientCommands(minecraft);
    }

    @Override
    public void sendMessageToAdmins(String msg) {
        if (this.minecraft.theWorld.getWorldInfo().getCheatsEnabled()) {
            this.minecraft.ingameGUI.addChatMessage(msg);
        }
    }

    @Override
    public void sendMessageToAllPlayers(String msg) {
        this.minecraft.ingameGUI.addChatMessage(msg);
    }

    @Override
    public EntityPlayer getPlayer(String name) {
        return this.minecraft.thePlayer;
    }

    @Override
    public void sendMessageToPlayer(EntityPlayer player, String msg) {
        if (player == this.minecraft.thePlayer) {
            this.minecraft.ingameGUI.addChatMessage(msg);
        }
    }

    @Override
    public boolean playerExists(String name) {
        return name.equalsIgnoreCase(this.minecraft.thePlayer.username);
    }

    @Override
    public void sendCommandFeedback(CommandSender sender, String message) {
        sender.sendMessage(message);
    }

    @Override
    public World getWorld(int dimension) {
        return this.minecraft.theWorld;
    }
}

