/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;

public abstract class Command {
    private final List<String> names = new ArrayList<String>();

    public Command(String name, String ... alts) {
        if (name == null) {
            throw new NullPointerException();
        }
        this.names.add(name);
        if (alts != null) {
            for (String n2 : alts) {
                this.names.add(n2);
            }
        }
    }

    public abstract boolean execute(CommandHandler var1, CommandSender var2, String[] var3);

    public abstract boolean opRequired(String[] var1);

    public boolean isName(String name) {
        for (String n2 : this.names) {
            if (!n2.equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        return this.names.get(0);
    }

    public abstract void sendCommandSyntax(CommandHandler var1, CommandSender var2);

    public String getName() {
        return this.names.get(0);
    }

    public List<String> getNames() {
        return this.names;
    }
}

