/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.src.command.Command;
import net.minecraft.src.command.MeCommand;
import net.minecraft.src.command.commands.ClearCommand;
import net.minecraft.src.command.commands.ColorCommand;
import net.minecraft.src.command.commands.DeopCommand;
import net.minecraft.src.command.commands.DifficultyCommand;
import net.minecraft.src.command.commands.GamemodeCommand;
import net.minecraft.src.command.commands.GenerateCommand;
import net.minecraft.src.command.commands.GiveCommand;
import net.minecraft.src.command.commands.HelpCommand;
import net.minecraft.src.command.commands.KillCommand;
import net.minecraft.src.command.commands.ListCommand;
import net.minecraft.src.command.commands.NicknameCommand;
import net.minecraft.src.command.commands.OpCommand;
import net.minecraft.src.command.commands.ScoreCommand;
import net.minecraft.src.command.commands.SeedCommand;
import net.minecraft.src.command.commands.SetBlockCommand;
import net.minecraft.src.command.commands.SetSpawnCommand;
import net.minecraft.src.command.commands.SpawnCommand;
import net.minecraft.src.command.commands.StopCommand;
import net.minecraft.src.command.commands.SummonCommand;
import net.minecraft.src.command.commands.TeleportCommand;
import net.minecraft.src.command.commands.TimeCommand;
import net.minecraft.src.command.commands.WeatherCommand;
import net.minecraft.src.command.commands.WhisperCommand;
import net.minecraft.src.command.commands.WhoisCommand;

public final class Commands {
    public static List<Command> commands = new ArrayList<Command>();

    public static void initCommands() {
        if (commands.size() > 0) {
            throw new RuntimeException();
        }
        commands.add(new TeleportCommand());
        commands.add(new WhisperCommand());
        commands.add(new GiveCommand());
        commands.add(new HelpCommand());
        commands.add(new WeatherCommand());
        commands.add(new SummonCommand());
        commands.add(new TimeCommand());
        commands.add(new ClearCommand());
        commands.add(new SeedCommand());
        commands.add(new GamemodeCommand());
        commands.add(new SetSpawnCommand());
        commands.add(new SpawnCommand());
        commands.add(new SetBlockCommand());
        commands.add(new KillCommand());
        commands.add(new GenerateCommand());
    }

    public static void initServerCommands(MinecraftServer server) {
        if (commands.size() > 0) {
            throw new RuntimeException();
        }
        Commands.initCommands();
        commands.add(new StopCommand(server));
        commands.add(new OpCommand(server));
        commands.add(new DeopCommand(server));
        commands.add(new ListCommand(server));
        commands.add(new DifficultyCommand(server));
        commands.add(new ColorCommand(server));
        commands.add(new NicknameCommand(server));
        commands.add(new WhoisCommand(server));
        commands.add(new ScoreCommand(server));
        commands.add(new MeCommand(server));
    }

    public static void initClientCommands(Minecraft minecraft) {
        if (commands.size() > 0) {
            throw new RuntimeException();
        }
        Commands.initCommands();
    }

    public static Command getCommand(String string) {
        for (Command command : commands) {
            for (String name : command.getNames()) {
                if (!name.equalsIgnoreCase(string)) continue;
                return command;
            }
        }
        return null;
    }
}

