/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command;

import net.minecraft.server.MinecraftServer;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Packet3Chat;
import net.minecraft.src.World;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;

public class ServerCommandHandler
implements CommandHandler {
    public final MinecraftServer minecraftServer;

    public ServerCommandHandler(MinecraftServer minecraftServer) {
        this.minecraftServer = minecraftServer;
    }

    @Override
    public void sendMessageToAdmins(String msg) {
        this.minecraftServer.configManager.sendChatMessageToAllOps(msg);
    }

    @Override
    public EntityPlayer getPlayer(String name) {
        return this.minecraftServer.configManager.getPlayerEntity(name);
    }

    @Override
    public void sendMessageToAllPlayers(String msg) {
        this.minecraftServer.configManager.sendPacketToAllPlayers(new Packet3Chat(msg));
    }

    @Override
    public void sendMessageToPlayer(EntityPlayer player, String messsage) {
        this.minecraftServer.configManager.sendPacketToPlayer(player.username, new Packet3Chat(messsage));
    }

    @Override
    public boolean playerExists(String name) {
        return this.minecraftServer.configManager.getPlayerEntity(name) != null;
    }

    @Override
    public void sendCommandFeedback(CommandSender sender, String message) {
        sender.sendMessage(message);
        String message2 = "\u00a77" + sender.getName() + ": " + message;
        for (EntityPlayer entityPlayer : this.minecraftServer.configManager.playerEntities) {
            if (!this.minecraftServer.configManager.isOp(entityPlayer.username) || sender.getPlayer() != null && sender.getPlayer() == entityPlayer) continue;
            this.sendMessageToPlayer(entityPlayer, message2);
        }
        this.minecraftServer.log(message2);
    }

    @Override
    public World getWorld(int dimension) {
        return this.minecraftServer.getWorldManager(dimension);
    }
}

