/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command.commands;

import net.minecraft.server.MinecraftServer;
import net.minecraft.src.EntityPlayerMP;
import net.minecraft.src.Packet72UpdatePlayerProfile;
import net.minecraft.src.command.ChatColor;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;
import net.minecraft.src.command.ServerCommand;

public class DeopCommand
extends ServerCommand {
    public DeopCommand(MinecraftServer server) {
        super(server, "deop", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length == 0) {
            return false;
        }
        String name = args[0];
        this.server.configManager.deopPlayer(name);
        handler.sendCommandFeedback(sender, "De-opping " + name);
        EntityPlayerMP player = (EntityPlayerMP)handler.getPlayer(name);
        if (player != null) {
            handler.sendMessageToPlayer(player, ChatColor.yellow + "You are no longer op!");
            player.mcServer.configManager.sendPacketToAllPlayers(new Packet72UpdatePlayerProfile(player.username, player.nickname, player.score, player.chatColor, true, player.isOperator()));
        }
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/deop <Player>");
    }
}

