/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command.commands;

import net.minecraft.server.MinecraftServer;
import net.minecraft.src.WorldServer;
import net.minecraft.src.command.CommandError;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;
import net.minecraft.src.command.ServerCommand;

public class DifficultyCommand
extends ServerCommand {
    public static String[] diffString = new String[]{"Peaceful", "Easy", "Normal", "Hard"};

    public DifficultyCommand(MinecraftServer server) {
        super(server, "difficulty", "dif");
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length == 0) {
            sender.sendMessage("The difficulty is " + diffString[handler.asServer().getWorld((int)0).difficultySetting]);
            return true;
        }
        if (args.length == 1) {
            int diff = Integer.parseInt(args[0]);
            if (diff < 0 || diff > 3) {
                throw new CommandError("Invalid Difficulty!");
            }
            for (WorldServer world : this.server.worldMngr) {
                world.difficultySetting = diff;
            }
            this.server.difficulty = diff;
            handler.sendCommandFeedback(sender, "Set difficulty to " + diff);
            return true;
        }
        return false;
    }

    @Override
    public boolean opRequired(String[] args) {
        return args != null && args.length != 0;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/difficulty");
        if (sender.isAdmin()) {
            sender.sendMessage("/difficulty <0-3>");
        }
    }
}

