/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command.commands;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.Gamemode;
import net.minecraft.src.command.Command;
import net.minecraft.src.command.CommandError;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;

public class GamemodeCommand
extends Command {
    public GamemodeCommand() {
        super("gamemode", "gm");
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        Gamemode gamemode;
        if (args.length == 0) {
            return false;
        }
        String gamemodeString = args[0];
        try {
            gamemode = Gamemode.gamemodesList[Integer.parseInt(gamemodeString)];
        }
        catch (Exception e2) {
            gamemode = GamemodeCommand.getGamemode(gamemodeString);
        }
        if (gamemode == null) {
            throw new CommandError("Can't find gamemode \"" + gamemodeString + "\"!");
        }
        EntityPlayer player = sender.getPlayer();
        if (args.length > 1) {
            player = handler.getPlayer(args[1]);
        }
        if (player == null) {
            throw new CommandError("Must be used by a player, or a player name must be defined!");
        }
        player.setGamemode(gamemode);
        handler.sendCommandFeedback(sender, "Set gamemode to " + gamemode.languageKey.substring(9) + " for " + player.getDisplayName());
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/gamemode <gamemode> <player>");
    }

    public static Gamemode getGamemode(String string) {
        for (Gamemode gamemode : Gamemode.gamemodesList) {
            if (!string.equalsIgnoreCase(gamemode.languageKey.substring(9))) continue;
            return gamemode;
        }
        return null;
    }
}

