/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command.commands;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPlayerMP;
import net.minecraft.src.EntityPlayerSP;
import net.minecraft.src.Item;
import net.minecraft.src.ItemStack;
import net.minecraft.src.command.Command;
import net.minecraft.src.command.CommandError;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;
import net.minecraft.src.command.PlayerCommandSender;

public class GiveCommand
extends Command {
    public GiveCommand() {
        super("give", "item", "i");
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        EntityPlayer player;
        int count = 1;
        int meta = 0;
        int arg = 0;
        if (args.length == 0) {
            return false;
        }
        if (handler.playerExists(args[0])) {
            player = handler.getPlayer(args[0]);
            ++arg;
        } else {
            player = sender.getPlayer();
        }
        if (player == null) {
            throw new CommandError("no player");
        }
        String[] ids = args[arg].split(":");
        Item item = GiveCommand.getItem(ids[0]);
        if (item == null) {
            throw new CommandError("Item not found: \"" + ids[0] + "\"");
        }
        if (ids.length > 1) {
            meta = Integer.parseInt(ids[1]);
        }
        if (args.length > ++arg) {
            count = Integer.parseInt(args[arg]);
        }
        ItemStack itemStack = new ItemStack(item, count, meta);
        return GiveCommand.givePlayerItem(handler, sender, player, itemStack);
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/give <Player> <ID:Meta> <Count>");
        if (sender instanceof PlayerCommandSender) {
            sender.sendMessage("/give <ID:Meta> <Count>");
        }
    }

    public static Item getItem(String id2) {
        try {
            int i2 = Integer.parseInt(id2);
            return GiveCommand.getItem(i2);
        }
        catch (Exception e2) {
            String id22 = "tile." + id2;
            String id3 = "item." + id2;
            for (Item item : Item.itemsList) {
                if (item == null) continue;
                if (item.getItemName().equalsIgnoreCase(id2)) {
                    return item;
                }
                if (item.getItemName().equalsIgnoreCase(id22)) {
                    return item;
                }
                if (!item.getItemName().equalsIgnoreCase(id3)) continue;
                return item;
            }
            return null;
        }
    }

    public static Item getItem(int id2) {
        return Item.itemsList[id2];
    }

    public static boolean givePlayerItem(CommandHandler handler, CommandSender sender, EntityPlayer player, ItemStack item) {
        if (player instanceof EntityPlayerSP) {
            if (!player.inventory.addItemStackToInventory(item)) {
                player.dropPlayerItem(item);
            }
            return true;
        }
        if (player instanceof EntityPlayerMP) {
            handler.sendCommandFeedback(sender, "Gave " + item.stackSize + " of " + item.getItemName() + " to " + player.getDisplayName());
            EntityPlayerMP playerMP = (EntityPlayerMP)player;
            playerMP.dropPlayerItem(item);
            return true;
        }
        return false;
    }
}

