/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command.commands;

import net.minecraft.src.command.ChatColor;
import net.minecraft.src.command.Command;
import net.minecraft.src.command.CommandError;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;
import net.minecraft.src.command.Commands;

public class HelpCommand
extends Command {
    public HelpCommand() {
        super("help", "?");
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length == 1) {
            Command command = Commands.getCommand(args[0]);
            if (command == null) {
                throw new CommandError("Can't find command: \"" + args[0] + "\"");
            }
            if (!sender.isAdmin() && command.opRequired(args)) {
                throw new CommandError("You don't have permission to use this command!");
            }
            StringBuilder aliasStr = new StringBuilder();
            aliasStr.append("Aliases: ");
            for (int i2 = 0; i2 < command.getNames().size(); ++i2) {
                if (i2 > 0) {
                    aliasStr.append(", ");
                }
                aliasStr.append(command.getNames().get(i2));
            }
            sender.sendMessage(aliasStr.toString());
            return true;
        }
        StringBuilder commandsString = new StringBuilder();
        for (Command command : Commands.commands) {
            if (!sender.isAdmin() && command.opRequired(null)) continue;
            commandsString.append(", ").append(command.getName());
        }
        commandsString = new StringBuilder(ChatColor.lightGray + "Commands: " + ChatColor.white + commandsString.substring(2));
        sender.sendMessage(commandsString.toString());
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return false;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/help");
    }
}

