/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command.commands;

import net.minecraft.server.MinecraftServer;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;
import net.minecraft.src.command.ServerCommand;

public class ListCommand
extends ServerCommand {
    public ListCommand(MinecraftServer server) {
        super(server, "list", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        int playerCount = this.server.configManager.playerEntities.size();
        String text = null;
        if (playerCount < 100) {
            StringBuilder builder = new StringBuilder();
            for (int i2 = 0; i2 < this.server.configManager.playerEntities.size(); ++i2) {
                if (i2 > 0) {
                    builder.append(", ");
                }
                builder.append(this.server.configManager.playerEntities.get(i2).getDisplayName());
            }
            text = playerCount + (playerCount == 1 ? " Player online: " : " Players online: ") + builder.toString();
        } else {
            text = playerCount + " Players online";
        }
        sender.sendMessage(text);
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return false;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/list");
    }
}

