/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command.commands;

import net.minecraft.server.MinecraftServer;
import net.minecraft.src.EntityPlayerMP;
import net.minecraft.src.Packet72UpdatePlayerProfile;
import net.minecraft.src.command.ChatColor;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;
import net.minecraft.src.command.ServerCommand;

public class OpCommand
extends ServerCommand {
    public OpCommand(MinecraftServer server) {
        super(server, "op", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length == 0) {
            return false;
        }
        String name = args[0];
        this.server.configManager.opPlayer(name);
        handler.sendCommandFeedback(sender, "Opping " + name);
        EntityPlayerMP player = (EntityPlayerMP)handler.getPlayer(name);
        if (player != null) {
            handler.sendMessageToPlayer(player, ChatColor.yellow + "You are now op!");
            player.mcServer.configManager.sendPacketToAllPlayers(new Packet72UpdatePlayerProfile(player.username, player.nickname, player.score, player.chatColor, true, player.isOperator()));
        }
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/op <player>");
    }
}

