/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command.commands;

import net.minecraft.server.MinecraftServer;
import net.minecraft.src.EntityPlayerMP;
import net.minecraft.src.Packet72UpdatePlayerProfile;
import net.minecraft.src.command.ChatColor;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;
import net.minecraft.src.command.ServerCommand;

public class ScoreCommand
extends ServerCommand {
    public ScoreCommand(MinecraftServer server) {
        super(server, "score", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        if (args.length < 2) {
            return false;
        }
        EntityPlayerMP player = (EntityPlayerMP)handler.getPlayer(args[0]);
        if (player == null) {
            return false;
        }
        if (args[1].equalsIgnoreCase("set")) {
            int newScore;
            if (args.length != 3) {
                return false;
            }
            player.score = newScore = Integer.parseInt(args[2]);
            this.server.configManager.sendPacketToAllPlayers(new Packet72UpdatePlayerProfile(player.username, player.nickname, player.score, player.chatColor, true, player.isOperator()));
            sender.sendMessage("Set " + player.getDisplayName() + ChatColor.white + "'s score to " + player.score);
            handler.sendMessageToPlayer(player, "Your score was set to " + player.score);
            return true;
        }
        if (args[1].equalsIgnoreCase("get")) {
            sender.sendMessage(player.getDisplayName() + "\u00a7f's score is " + player.score);
            return true;
        }
        if (args[1].equalsIgnoreCase("reset")) {
            player.score = 0;
            this.server.configManager.sendPacketToAllPlayers(new Packet72UpdatePlayerProfile(player.username, player.nickname, player.score, player.chatColor, true, player.isOperator()));
            sender.sendMessage("Set " + player.getDisplayName() + ChatColor.white + "'s score to " + player.score);
            handler.sendMessageToPlayer(player, "Your score was set to " + player.score);
            return true;
        }
        return false;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/score <username> get");
        sender.sendMessage("/score <username> set <value>");
        sender.sendMessage("/score <username> reset");
    }
}

