/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command.commands;

import net.minecraft.src.ChunkCoordinates;
import net.minecraft.src.EntityPlayer;
import net.minecraft.src.World;
import net.minecraft.src.command.Command;
import net.minecraft.src.command.CommandError;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;
import net.minecraft.src.command.PlayerCommandSender;

public class SetSpawnCommand
extends Command {
    public SetSpawnCommand() {
        super("setworldspawn", "setspawn");
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        int z2;
        int y2;
        int x2;
        EntityPlayer player = sender.getPlayer();
        if (args.length > 0) {
            try {
                x2 = Integer.parseInt(args[0]);
                y2 = Integer.parseInt(args[1]);
                z2 = Integer.parseInt(args[2]);
            }
            catch (NumberFormatException nfe) {
                throw new CommandError("Coordinates must be integers!");
            }
        } else {
            if (player == null) {
                throw new CommandError("Must be used by a player, or define coordinates!");
            }
            x2 = (int)Math.floor(player.posX);
            y2 = (int)Math.floor(player.posY);
            z2 = (int)Math.floor(player.posZ);
        }
        ChunkCoordinates pos = new ChunkCoordinates(x2, y2, z2);
        World world = handler.getWorld(0);
        world.setSpawnPoint(pos);
        handler.sendCommandFeedback(sender, "Set spawn location to x: " + x2 + " y: " + y2 + " z: " + z2);
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        if (sender instanceof PlayerCommandSender) {
            sender.sendMessage("/setworldspawn");
        }
        sender.sendMessage("/setworldspawn <x> <y> <z>");
    }
}

