/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.src.command.commands;

import net.minecraft.src.EntityPlayer;
import net.minecraft.src.EntityPlayerMP;
import net.minecraft.src.command.ChatColor;
import net.minecraft.src.command.Command;
import net.minecraft.src.command.CommandError;
import net.minecraft.src.command.CommandHandler;
import net.minecraft.src.command.CommandSender;
import net.minecraft.src.command.PlayerCommandSender;
import net.minecraft.src.command.ServerCommandHandler;

public class TeleportCommand
extends Command {
    public TeleportCommand() {
        super("tp", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        System.out.println("TP Command");
        System.out.println("handler: " + handler);
        System.out.println("sender: " + sender);
        boolean sentByPlayer = sender instanceof PlayerCommandSender;
        if (args.length > 0) {
            if (args.length <= 2) {
                EntityPlayer from = null;
                EntityPlayer to2 = null;
                if (args.length == 1) {
                    if (sentByPlayer) {
                        from = sender.getPlayer();
                        to2 = this.getPlayer(handler, args[0]);
                    } else {
                        return false;
                    }
                }
                if (args.length == 2) {
                    from = this.getPlayer(handler, args[0]);
                    to2 = this.getPlayer(handler, args[1]);
                }
                TeleportCommand.teleport(handler, sender, from, to2);
                return true;
            }
            EntityPlayer player = null;
            double x2 = 0.0;
            double y2 = 0.0;
            double z2 = 0.0;
            if (args.length == 3 && sentByPlayer) {
                x2 = this.parseDouble(args[0]);
                y2 = this.parseDouble(args[1]);
                z2 = this.parseDouble(args[2]);
                player = sender.getPlayer();
            }
            if (args.length == 4) {
                player = this.getPlayer(handler, args[0]);
                x2 = this.parseDouble(args[1]);
                y2 = this.parseDouble(args[2]);
                z2 = this.parseDouble(args[3]);
            }
            TeleportCommand.teleport(handler, sender, player, null, x2, y2, z2, player.rotationYaw, player.rotationPitch, null);
            return true;
        }
        return false;
    }

    public double parseDouble(String str) {
        try {
            return Double.parseDouble(str);
        }
        catch (Exception e2) {
            throw new CommandError("Not a number: \"" + str + "\"");
        }
    }

    public EntityPlayer getPlayer(CommandHandler handler, String name) {
        EntityPlayer player = handler.getPlayer(name);
        if (player == null) {
            throw new CommandError("Player not found: " + name);
        }
        return player;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        boolean server = handler instanceof ServerCommandHandler;
        boolean sentByPlayer = sender instanceof PlayerCommandSender;
        if (server) {
            sender.sendMessage("/tp <FromPlayer> <ToPlayer>");
        }
        if (sentByPlayer && server) {
            sender.sendMessage("/tp <ToPlayer>");
        }
        if (server) {
            sender.sendMessage("/tp <Player> <x> <y> <z>");
        }
        if (sentByPlayer) {
            sender.sendMessage("/tp <x> <y> <z>");
        }
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    public static void teleport(CommandHandler handler, CommandSender sender, EntityPlayer p1, Integer dimension, double x2, double y2, double z2, double yaw, double pitch, EntityPlayer p2) {
        if (p1 instanceof EntityPlayerMP) {
            EntityPlayerMP p1MP = (EntityPlayerMP)p1;
            if (dimension != null && p1MP.dimension != dimension && handler instanceof ServerCommandHandler) {
                ServerCommandHandler serverCommandHandler = (ServerCommandHandler)handler;
                serverCommandHandler.minecraftServer.configManager.sendPlayerToOtherDimension(p1MP, dimension);
            }
            p1MP.playerNetServerHandler.teleportTo(x2, y2, z2, p1MP.rotationYaw, p1MP.rotationPitch);
        } else {
            p1.setLocationAndAngles(x2, y2, z2, p1.rotationYaw, p1.rotationPitch);
        }
        if (p2 != null) {
            handler.sendCommandFeedback(sender, "Teleporting " + p1.getDisplayName() + ChatColor.white + " to " + p2.getDisplayName());
        } else {
            handler.sendCommandFeedback(sender, "Teleporting " + p1.getDisplayName() + ChatColor.white + " to x: " + TeleportCommand.floor10(x2) + " y: " + TeleportCommand.floor10(y2) + " z: " + TeleportCommand.floor10(z2));
        }
    }

    public static void teleport(CommandHandler handler, CommandSender sender, EntityPlayer p1, EntityPlayer p2) {
        TeleportCommand.teleport(handler, sender, p1, p2.dimension, p2.posX, p2.posY, p2.posZ, p2.rotationYaw, p2.rotationPitch, p2);
    }

    public static double floor10(double a2) {
        return (double)((int)(a2 * 10.0)) / 10.0;
    }
}

